<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="readonly" required="true" rtexprvalue="true" %>

<re:mark>Display all publishers table</re:mark>

<c:set var="obj" >
	publishers
</c:set>

<c:if test="${fn:length(requestScope.formData[obj])>0}">
	<table class="table table-striped">
		<tr>
			<th><wmsform:getlocalestring page="${page}" obj="${obj}.name"/></th>
			<th style="width:15px"><wmsform:getlocalestring page="${page}" obj="${obj}.action"/></th>
		</tr>
		<c:forEach items="${requestScope.formData[obj]}" var="item">
			<tr>
				<c:choose>
					<c:when test="${readonly}">
						<td class="breakall">${item}</td>
						<td></td>
					</c:when>
					<c:otherwise>
						<td class="breakall"><a href='javascript:showPublisher("${item}")'>${item}</a></td>
						<td>
							<sec:authorize access="hasAnyRole('admin')">		
								<a href='javascript:showEditPublisher("${item}")' ><i class='fa fa-pencil fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='<wmsform:getlocalestring page="serverPublishers.tooltip" obj="edit"/>'></i></a>
								<a href='javascript:removePublisher("${item}")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='<wmsform:getlocalestring page="serverPublishers.tooltip" obj="delete"/>'></i></a>
							</sec:authorize>
						</td>
					</c:otherwise>
				</c:choose>
			</tr>
		</c:forEach>
	</table>
</c:if>

<wmsdialog:deletepublisher page="${page}"/>
<script>

var deletePublisherName="";

function removePublisher(name)
{
	deletePublisherName=name;
	deletePublisherShow();
}

function showPublisher(name)
{
	loadAjaxMainContent("server/publisher/view.htm", "publisherName="+name); 	
}

function showEditPublisher(name)
{
	loadAjaxMainContent("server/publisher/edit.htm", "publisherName="+name+"&action=quickEdit"); 
}		

var tblDataPublishers = new Array();

initTableDataPublishers();

function initTableDataPublishers()
{
	<c:set var="count" value="0"/>
	<c:forEach items="${requestScope.formData[obj]}" var="item">
		var newItem = new Object();
		newItem.name = "${item}";
		tblDataPublishers.push(newItem);
		<c:set var="count" value="${count + 1}"/>
	</c:forEach>
}
</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>