<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<re:mark>Display all host ports table</re:mark>

<c:set var="obj" >
	hostPorts
</c:set>
<div class="row">
	<div class="col-md-6">
		<h4 id="hostPorts"><wmsform:getlocalestring page="${page}" obj="hostPorts"/> 
		<small></small></h4>
	</div>
	<div class="col-md-2">
		<div class="pull-right">
		</div>
	</div>
</div>
<div class="table-responsive">
	<table class="table table-striped">
		<tr>
			<th><wmsform:getlocalestring page="${page}" obj="${obj}.name"/></th>
			<th><wmsform:getlocalestring page="${page}" obj="${obj}.type"/></th>
			<th><wmsform:getlocalestring page="${page}" obj="${obj}.ipAddress"/></th>
			<th><wmsform:getlocalestring page="${page}" obj="${obj}.port"/></th>
			<th><wmsform:getlocalestring page="${page}" obj="${obj}.sslEnable"/></th>
		</tr>
		<c:forEach items="${requestScope.formData[obj]}" var="item">
			<tr>
				<td class="breakall">${item['name']}</td>
				<td>${item['type']}</td>
				<td>${item['ipAddress']}</td>
				<td>${item['port']}</td>
				<td>${item['sslEnable']}</td>
			</tr>
		</c:forEach>
	</table>
</div>
