<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<re:mark>Display all buyDRM stream maps tables</re:mark>

<c:set var="obj" >
	buyDRMStreamMapList
</c:set>
<h4 id="buyDRMStreamMaps" class="control-label">
	<wmsform:getlocalestring page="${page}" obj="buyDRMStreamMaps"/>
</h4>
<table class="table table-striped">
	<tr>
		<th><wmsform:getlocalestring page="appconfig.drm_buydrm" obj="buyDRMStreamMapList.streamName"/></th>
		<th colspan=2><wmsform:getlocalestring page="appconfig.drm_buydrm" obj="buyDRMStreamMapList.streamNameInfo"/></th>
	</tr>
	<c:forEach items="${requestScope.formData[obj]}" var="item">
		<tr>
			<td rowspan=3>${item['streamName']}</td>
			<td><label><wmsform:getlocalestring page="appconfig.drm_buydrm" obj="buyDRMStreamMapList.keyID"/>:</label></td>
			<td>${item['keyID']}</td>
		</tr>
		<tr>
			<td><label><wmsform:getlocalestring page="appconfig.drm_buydrm" obj="buyDRMStreamMapList.contentID"/>:</label></td>
			<td>${item['contentID']}</td>
		</tr>
		<tr>
			<td><label><wmsform:getlocalestring page="appconfig.drm_buydrm" obj="buyDRMStreamMapList.mediaID"/>:</label></td>
			<td>${item['mediaID']}</td>
		</tr>
	</c:forEach>
</table>
