<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<re:mark>edit stream name group tables</re:mark>

<c:set var="obj" >
	overlaysList
</c:set>

<div class="advanced-table-title">
	<h4><wmsform:getlocalestring page="${page}" obj="overlaysList"/></h4>
	<wmsform:button page="${page}" obj="${obj}.addOverlay" onClick="javascript:overlayEditShow(-1,true)" icon="fa fa-plus"/>
</div>

<table class="table table-striped" id="overlaysTable">
</table>
<wmsdialog:editoverlay page="transcoder.template.overlay"/>

<c:set var="enabledLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.enabled"/>
</c:set>
<c:set var="nameLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.name"/>
</c:set>
<c:set var="imagePathLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.imagePath"/>
</c:set>
<c:set var="actionLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.action"/>
</c:set>

<script>


updateTableOverlay();


function updateTableOverlay()
{
	var tbl = document.getElementById('overlaysTable');
	if(tbl==null)
		return;
	while (tbl.firstChild) {
		tbl.removeChild(tbl.firstChild);
	}
	var tblString="";
	tblString+="<tr>";
	tblString+="<th style='vertical-align:bottom;text-align:center'>${enabledLabel}</th>";
	tblString+="<th style='vertical-align:bottom'>${nameLabel}</th>";
	tblString+="<th style='vertical-align:bottom;'>${imagePathLabel}</th>";
	tblString+="<th style='vertical-align:bottom;'>${actionLabel}</th>";
	tblString+="</tr>";

	var goodItems=0;
	for (tblItem in tblDataOverlay) {
		if(!tblDataOverlay[tblItem].removed)
		{
			goodItems++;
		}
	}
	var displayed=0;
	for (tblItem in tblDataOverlay) {
		if(tblDataOverlay[tblItem].removed)
		{
			tblString+="<tr style='display:none'><td>";
		}
		else {
			tblString+="<tr>";
		}
		
		tblString+="<input id='${obj}"+tblItem+".index' name='${obj}["+tblItem+"].index' type='hidden' value='"+tblDataOverlay[tblItem].index+"'>";			
		tblString+="<input id='${obj}"+tblItem+".removed' name='${obj}["+tblItem+"].removed' type='hidden' value='"+tblDataOverlay[tblItem].removed+"'>";			
		tblString+="<input id='${obj}"+tblItem+".checkForUpdates' name='${obj}["+tblItem+"].checkForUpdates' type='hidden' value='"+tblDataOverlay[tblItem].checkForUpdates+"'>";			
		tblString+="<input id='${obj}"+tblItem+".opacity' name='${obj}["+tblItem+"].opacity' type='hidden' value='"+tblDataOverlay[tblItem].opacity+"'>";			
		tblString+="<input id='${obj}"+tblItem+".width' name='${obj}["+tblItem+"].width' type='hidden' value='"+tblDataOverlay[tblItem].width+"'>";			
		tblString+="<input id='${obj}"+tblItem+".height' name='${obj}["+tblItem+"].height' type='hidden' value='"+tblDataOverlay[tblItem].height+"'>";			
		tblString+="<input id='${obj}"+tblItem+".align' name='${obj}["+tblItem+"].align' type='hidden' value='"+tblDataOverlay[tblItem].align+"'>";			
		tblString+="<input id='${obj}"+tblItem+".xLocation' name='${obj}["+tblItem+"].xLocation' type='hidden' value='"+tblDataOverlay[tblItem].xLocation+"'>";			
		tblString+="<input id='${obj}"+tblItem+".yLocation' name='${obj}["+tblItem+"].yLocation' type='hidden' value='"+tblDataOverlay[tblItem].yLocation+"'>";			
		
		if(tblDataOverlay[tblItem].removed)
		{
			tblString+="</td></tr>";
			tblString+="<tr style='display:none'></tr>";
		}
		else 
		{	
			tblString+="<td><center>";
			if(tblDataOverlay[tblItem].enable)
			{
				tblString+="<input id='${obj}"+tblItem+".enable' name='${obj}["+tblItem+"].enable' type='checkbox' onclick='javascript:swapOverlayEnable(" + tblItem + ")' checked >";
			}
			else 
			{
				tblString+="<input id='${obj}"+tblItem+".enable' name='${obj}["+tblItem+"].enable' type='checkbox'  onclick='javascript:swapOverlayEnable(" + tblItem + ")' >";			
			}
			tblString+="</center></td>";
			tblString+="<td>";
			tblString+=showOverlayInput(tblItem,"overlayName",tblDataOverlay[tblItem].overlayName,"");
			tblString+="</td>";
			tblString+="<td class=\"breakall\">";
			tblString+=showOverlayInput(tblItem,"imagePath",tblDataOverlay[tblItem].imagePath,"");
			tblString+="</td>";
			if(displayed==0 && goodItems>1) 
			{
				tblString+="<td nowrap class='action-icons-triple'><div class='row'>";
				tblString+="<div class='col-md-4 sort-down'><a href='javascript:moveOverlayDown("+ tblItem + ")' ><i class='fa fa-chevron-down fa-lg icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Move overlay z-order down'></i></a></div>";
				tblString+="<div class='col-md-4 trash-icon'><a href='javascript:overlayEditShow("+tblItem+",true)' ><i class='fa fa-pencil fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Edit this overlay'></i></a></div>";				
				tblString+="<div class='col-md-4 trash-icon'><a href='javascript:removeOverlay("+tblItem+")' ><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='right' data-toggle='tooltip' data-delay='250' data-original-title='Delete this overlay'></i></a></div>";
				tblString+="</div></td>"
			}
			if(displayed!=0 && displayed==goodItems-1) 
			{
				tblString+="<td nowrap class='action-icons-triple'><div class='row'>";
				tblString+="<div class='col-md-4'><a href='javascript:moveOverlayUp("+ tblItem + ")'><i class='fa fa-chevron-up fa-lg icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Move overlay z-order up'></i></a></div>";
				tblString+="<div class='col-md-4 trash-icon'><a href='javascript:overlayEditShow("+tblItem+",true)' ><i class='fa fa-pencil fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Edit this overlay'></i></a></div>";				
				tblString+="<div class='col-md-4 trash-icon'><a href='javascript:removeOverlay("+tblItem+")' ><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='right' data-toggle='tooltip' data-delay='250' data-original-title='Delete this overlay'></i></a></div>";
				tblString+="</div></td>"
			}
			if(displayed!=goodItems-1 && displayed!=0 && goodItems!=1)
			{
				tblString+="<td nowrap class='action-icons-triple'><div class='row'>";
				tblString+="<div class='col-md-4'><a href='javascript:moveOverlayUp("+ tblItem + ")'><i class='fa fa-chevron-up fa-lg icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Move overlay z-order up'></i></a><br>";
				tblString+="<a href='javascript:moveOverlayDown("+ tblItem + ")' ><i class='fa fa-chevron-down fa-lg icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Move overlay z-order down'></i></a></div>";
				tblString+="<div class='col-md-4 trash-icon'><a href='javascript:overlayEditShow("+tblItem+",true)' ><i class='fa fa-pencil fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Edit this overlay'></i></a></div>";				
				tblString+="<div class='col-md-4 trash-icon'><a href='javascript:removeOverlay("+tblItem+")' ><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='right' data-toggle='tooltip' data-delay='250' data-original-title='Delete this overlay'></i></a></div>";
				tblString+="</div></td>"
			}							
			if(goodItems==1)
			{
				tblString+="<td nowrap class='action-icons-triple'><div class='row'>";
				tblString+="<a href='javascript:overlayEditShow("+tblItem+",true)' ><i class='fa fa-pencil fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Edit this overlay'></i></a>&nbsp;&nbsp;";				
				tblString+="<a href='javascript:removeOverlay("+tblItem+")' ><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='right' data-toggle='tooltip' data-delay='250' data-original-title='Delete this overlay'></i></a>";
				tblString+="</div></td>"
			}
			tblString+="</tr>";
			displayed++;
		}
	}

	$('#overlaysTable').html(tblString);
}

function showOverlayInput(tblItem,field,valueStr,errorStr)
{
	if(errorStr != undefined)
	{
		retVal="<div class='form-group error' id='${obj}CtrlGroup'>";
	}
	else {
		retVal="<div class='form-group' id='${obj}CtrlGroup'>";		
	}
	retVal+="<input id='${obj}"+tblItem+"."+field+"' name='${obj}["+tblItem+"]."+field+"' value='"+valueStr+"' type='hidden' >";
	retVal+=valueStr;
	if(errorStr != undefined)
	{
		retVal+="<span class='help-block-has-error'>"+errorStr+"</span>";
	}
	retVal+="</div>";
	return retVal;
}

function removeOverlay(orgIdx)
{
	tblDataOverlay[orgIdx].removed=true;
	if(tblDataOverlay[orgIdx].added) //value did not exsits before and was just added
	{
		tblDataOverlay.splice(orgIdx,1); //remove it
	}
	updateTableOverlay();
}

function swapOverlayEnable(idx)
{
	tblDataOverlay[idx].enable=!tblDataOverlay[idx].enable;
}

function moveOverlayDown(idx)
{
	if(idx >= tblDataOverlay.length-1) {
		return;
	}
	//move swap the .order of local var tablData
	var a = tblDataOverlay[idx];
	var b= tblDataOverlay[idx+1];
	tblDataOverlay[idx]=b;
	tblDataOverlay[idx+1]=a;
	a.order=idx+1;
	b.order=idx;
	updateTableOverlay();
}

function moveOverlayUp(idx)
{
	if(idx <=0) {
		return;
	}
	var a = tblDataOverlay[idx];
	var b= tblDataOverlay[idx-1];
	tblDataOverlay[idx]=b;
	tblDataOverlay[idx-1]=a;
	a.order=idx-1;
	b.order=idx;
	updateTableOverlay();
}
</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>