<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="showTitle" required="false" rtexprvalue="true" %>
<%@ attribute name="showEmptyString" required="false" rtexprvalue="true" %>
<%@ attribute name="prefix" required="false" rtexprvalue="true" %>
<%@ attribute name="bind" required="false" rtexprvalue="true" %>
<%@ attribute name="getLocalString" required="false" rtexprvalue="true" %>
<%@ attribute name="cssClassTitle" required="false" rtexprvalue="true" %>
<%@ attribute name="ctrlGroupClass" required="false" rtexprvalue="true" %>
<%@ attribute name="icon" required="false" rtexprvalue="true" %>
<%@ attribute name="iconClass" required="false" rtexprvalue="true" %>
<%@ attribute name="objvalue" required="false" rtexprvalue="true" %>

<!-- %@ attribute name="title" required="false" rtexprvalue="true" % -->

<re:mark>Display a single item</re:mark>

<c:set var="ctrlGroupClass">
	<wmsform:getctrlgroupclass obj="${obj}"/>
</c:set>
<!-- Think we don't need this in bootstrap 3.0
<c:if test="${ empty cssClassTitle}">
	<c:set var="cssClassTitle" value="control-label"/>
</c:if>
-->
<c:set var="newline" value="<%= \"\n\" %>" />
<div class="${ctrlGroupClass}" id="${obj}CtrlGroup">
	<c:if test="${ empty showTitle}">
		<label class="${cssClassTitle}">
			<wmsform:getlocalestring page="${page}" obj="${obj}"/>
		</label>
	</c:if>
	<div class="controls">
		<c:if test="${empty bind or bind=='true'}">
			<re:mark> if you pass in an objvalue then we won't use what's in the obj otherwise we get the value of what's in var objvalue</re:mark>
			<c:if test="${ empty objvalue }">
				<c:set var="objvalue">
					<wmsform:objvalue page="${page}" obj="${obj}" />
				</c:set>
			</c:if>
			<re:mark>getLocalString is what is in the strings translation table (messages_en.properties) </re:mark>
			<c:if test="${ !empty getLocalString && getLocalString=='true' }">
				<c:set var="objvalue">
					<wmsform:getlocalestring page="${page}" obj="${obj}.${objvalue}" />
				</c:set>
			</c:if>
		</c:if>

		<c:if test="${ empty objvalue && !empty showEmptyString }">
			<c:set var="objvalue">
				${showEmptyString}
			</c:set>
		</c:if>
		
		<div class="value" id="${obj}Value">
			<c:choose>
				<c:when test="${ !empty icon && !empty iconClass }">
					<span class="${iconClass}"><I class="${icon}"></i></span>
				</c:when>
				<c:when test="${ !empty icon }">
					<span><I class="${icon}"></i></span>
				</c:when>
			</c:choose>
			${prefix}
			${fn:replace(fn:escapeXml(objvalue), newline, "<br>")}
			<span id="${obj}Help" class="help-block" style="display:none"></span>
			<wmsform:warnings path="view.${obj}"/>
		</div>
	</div>
</div>
