<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="disconnectStreamGroupModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="disconnectStreamGroupModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:disconnectStreamGroupClose()">x</button>
					<h4 id="disconnectStreamGroupModalLabel" class="modal-title"><wmsform:getlocalestring page="disconnectStreamGroupDialog" obj="title"/></h4>
				  </div>
				  <div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="disconnectStreamGroupDialog" obj="message"/> <b><span id="disconnectGroupName"></span></b>?</p>
						<p class="text-warning"><wmsform:getlocalestring page="disconnectStreamGroupDialog" obj="warning"/></p>
				  </div>
				  <div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:disconnectStreamGroupClose()"/>
					<wmsform:buttonok  onClick="javascript:doDisconnectStreamGroup()"/>
				  </div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>
var currentInstance;
var currentStream;
var currentApp;

function disconnectStreamGroupShow(app, appInstance, streamGroup) {
	$('#disconnectGroupName').text(streamGroup);
	currentApp=app;
	currentInstance=appInstance;
	currentGroup=streamGroup;
	$('#disconnectStreamGroupModal').on("shown.bs.modal", function() {});
	$('#disconnectStreamGroupModal').modal('show');	
}

function disconnectStreamGroupClose() {
	$('#disconnectStreamGroupModal').modal('hide');
}

function doDisconnectStreamGroup() {
	$('#disconnectStreamGroupModal').on('hidden.bs.modal', function() {
		postAJAXForm('groups/${page}/disconnectGroup.htm','vhost=${wmsutil:urlEncode(vhost)}&appName='+encodeURIComponent(currentApp)+'&appType=${appType}&appSection=${appSection}&instanceName='+encodeURIComponent(currentInstance)+'&group='+encodeURIComponent(currentGroup)+'&returnPage=${page}');
	});
	disconnectStreamGroupClose();
}

</script>