<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="disconnectStreamModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="disconnectStreamModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				<c:if test="${page=='appconfig.incomingstreams.details'}">
					<form:hidden path="managedStream"/>
					<form:hidden path="recordingSet"/>
				</c:if>
				<div class="modal-header">
					<button type="button" class="close" onClick="javascript:disconnectStreamClose()">x</button>
					<h4 id="disconnectStreamModalLabel" class="modal-title"><wmsform:getlocalestring page="disconnectStreamDialog" obj="title"/></h4>
				</div>
				<div class="modal-body">
					<p class="breakall"><wmsform:getlocalestring page="disconnectStreamDialog" obj="message"/> <b><span id="disconnectStreamName"></span></b>?</p>
				</div>
				<div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:disconnectStreamClose()"/>
					<wmsform:buttonok  onClick="javascript:doDisconnectStream()"/>
				</div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>
var currentInstance;
var currentStream;
var currentApp;

function disconnectStreamShow(app, appInstance, streamName) {
	$('#disconnectStreamName').text(streamName);
	currentApp=app;
	currentInstance=appInstance;
	currentStream=streamName;
	$('#disconnectStreamModal').on("shown.bs.modal", function() {});
	$('#disconnectStreamModal').modal('show');	
}

function disconnectStreamClose() {
	$('#disconnectStreamModal').modal('hide');
}

function doDisconnectStream() {
	$('#disconnectStreamModal').on('hidden.bs.modal', function() {
		postAJAXForm('streams/${page}/disconnectStream.htm','vhost=${wmsutil:urlEncode(vhost)}&appName='+encodeURIComponent(currentApp)+'&appType=${appType}&appSection=${appSection}&instanceName='+encodeURIComponent(currentInstance)+'&streamName='+encodeURIComponent(currentStream)+'&returnPage=${page}'+'&parentPage='+incomingStreamDetailsParentPage);
	});
	disconnectStreamClose();
}

</script>