<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="deleteStreamTargetModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="deleteStreamTargetModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:deleteStreamTargetClose()">x</button>
					<h4 id="deleteStreamTargetModalLabel" class="modal-title"><wmsform:getlocalestring page="deleteStreamTargetDialog" obj="title"/></h4>
				  </div>
				  <div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="deleteStreamTargetDialog" obj="message"/> <b><span id="deleteStreamTargetName"></span></b>?</p>
						<p class="text-warning"><wmsform:getlocalestring page="deleteStreamTargetDialog" obj="warning"/></p>
				  </div>
				  <div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:cancelDeleteStreamTarget()"/>
					<wmsform:buttonok  onClick="javascript:doDeleteStreamTarget()"/>
				  </div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>
var currentStreamTarget;
var currentApp;
var callback;

function deleteStreamTargetShow(app, streamTargetName, okToDeleteCb) {
	$('#deleteStreamTargetName').text(streamTargetName);
	currentApp=app;
	currentStreamTarget=streamTargetName;
	okToDelete=okToDeleteCb;
	$('#deleteStreamTargetModal').on("shown.bs.modal", function() {});
	$('#deleteStreamTargetModal').modal('show');
}

function deleteStreamTargetClose() {
	$('#deleteStreamTargetModal').modal('hide');
	restartRefresh();
}

function doDeleteStreamTarget() {
	handleDeleteStreamTargetResponse(okToDelete(currentStreamTarget, handleDeleteStreamTargetResponse)); 
}

function handleDeleteStreamTargetResponse(doDelete) {
	if (doDelete == true)
	{
		$('#deleteStreamTargetModal').on('hidden.bs.modal', function() {
			postAJAXForm('streamTarget/delete.htm','vhost=${wmsutil:urlEncode(vhost)}&appName='+encodeURIComponent(currentApp)+'&appType=${appType}&appSection=${appSection}&streamTargetName='+encodeURIComponent(currentStreamTarget)+'&returnPage=${page}');
		});
		deleteStreamTargetClose();
	}
	else if (doDelete == false)
	{
		$('#deleteStreamTargetModal').on('hidden.bs.modal', function() {
			postAJAXForm('streamTarget/showDeleteError.htm','vhost=${wmsutil:urlEncode(vhost)}&appName='+encodeURIComponent(currentApp)+'&appType=${appType}&appSection=${appSection}&streamTargetName='+encodeURIComponent(currentStreamTarget)+'&returnPage=${page}');
		});
		deleteStreamTargetClose();
	}
	// if doDelete == null do nothing... means true response will come asynchronously
}

function cancelDeleteStreamTarget() {
	deleteStreamTargetClose();
}
</script>