<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="addTranscoderTemplateModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="addTranscoderTemplateModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="addForm" class="form-modal">
				<fieldset>
					<div class="modal-header">
						<button type="button" class="close" onClick="javascript:addTranscoderTemplateClose()">x</button>
						<h4 id="addTranscoderTemplateModalLabel" class="modal-title">
							<wmsform:getlocalestring page="${page}" obj="addTranscoderTemplateDialog.title" />
						</h4>
					</div>
					<div class="modal-body">
						<p>
							<wmsform:getlocalestring page="${page}" obj="addTranscoderTemplateDialog.message" />
						</p>
						<label><wmsform:getlocalestring page="${page}" obj="addTranscoderTemplateDialog.prompt" /></label><input id="addTemplateName" path="addTemplateName" value="" class="form-control" />
						<span class="help-block"><wmsform:getlocalestring page="${page}" obj="addTranscoderTemplateDialog.help" /></span>
					</div>
					<div class="modal-footer">
						<div class="row">
							<div class="col-md-8">
								<div id="addTemplateNameWarnings" class="alert alert-danger"></div>
							</div>
							<div class="col-md-4">
								<wmsform:buttoncancel onClick="javascript:addTranscoderTemplateClose()" />
								<wmsform:buttonadd onClick="javascript:doAdd()" />
							</div>
						</div>
					</div>
				</fieldset>
			</form>
		</div>
	</div>
</div>
<c:set var="dupTemplateNameError">
	<wmsform:getlocalestring page="${page}" obj="template.templateName.dup"/>
</c:set>
<c:set var="blankNameError">
	<wmsform:getlocalestring page="${page}" obj="template.templateName.empty"/>
</c:set>
<c:set var="invalidNameError">
	<wmsform:getlocalestring page="${page}" obj="template.templateName.invalidchars"/>
</c:set>
<c:set var="invalidNameLengthError">
	<wmsform:getlocalestring page="$common" obj="invalidFileNameLength"/>
</c:set>

<script>
$(document).ready(function() {
	$("#addForm").bind("keypress", function(e) {
         if (e.keyCode == 13) {   
        	 doAdd();
             return false;
        }
     });
});

function addTranscoderTemplateShow() {
	//$("#addTemplateName").text(addTemplateDisplayName);
	$('#addTemplateNameWarnings').hide();

	$('#addTemplateName').val("");
	$('#addTranscoderTemplateModal').on("shown.bs.modal", function() {
		$('#addTemplateName').focus();
	});
	$('#addTranscoderTemplateModal').modal('show');
}

function addTranscoderTemplateClose() {
	$('#addTranscoderTemplateModal').modal('hide');
}

function doAdd()
{
	var ok=true;
	var fname= $("#addTemplateName").val().trim();
	
	if(fname=="")
	{
		$('#addTemplateNameWarnings').text("${blankNameError}");
		$('#addTemplateNameWarnings').show();
		ok=false;					
	}
	for (tblItem in tblDataTemplate) {
		if(!tblDataTemplate[tblItem].removed)
		{
			if(tblDataTemplate[tblItem].templateName==fname)
			{
				$('#addTemplateNameWarnings').text("${dupTemplateNameError}");
				$('#addTemplateNameWarnings').show();
				ok=false;
				break;
			}
		}
	}
	if(ok && !isValidFileName(fname) || (fname.indexOf(",") >= 0))
	{
		$('#addTemplateNameWarnings').text("${invalidNameError}");
		$('#addTemplateNameWarnings').show();
		ok=false;
	}
	if(ok && !isValidFileNameLength(fname))
	{
		$('#addTemplateNameWarnings').html("${invalidNameLengthError}");
		$('#addTemplateNameWarnings').show();
		ok=false;
	}
	if(ok)
	{
		createTemplate(fname);		
	}
	
}

function createTemplate(result) {
	lastTranscoderTemplate=result;
	lastTranscoderTemplateType="${TemplateType}";
	lastTranscoderTemplateSection='main';
	result=encodeURIComponent(result);
	$('#addTranscoderTemplateModal').on('hidden.bs.modal', function() {
		if("${appType}" == "")
		{
			postAJAXForm('transcoder/new.htm','vhost=${wmsutil:urlEncode(vhost)}&appType=${appType}&appName=${wmsutil:urlEncode(appName)}&dstTemplate='+result);
		}
		else {
			postAJAXForm('transcoder/new.htm','vhost=${wmsutil:urlEncode(vhost)}&appType=${appType}&appName=${wmsutil:urlEncode(appName)}&dstTemplate='+result);
		}
	});
	addTranscoderTemplateClose();
}

</script>