<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<wmsform:setpagetitle page="smilFiles"/>

<div>
	<div class="row">
		<wmsform:pageerror/>
		<wmsform:pagewarning/>
		<wmsform:pageinformation/>
	</div>
	<div class="row">
		<c:choose>
			<c:when test="${empty appType}">
				<div class="col-md-12">
					<happ><wmsform:getlocalestring page="smilFiles" obj="head"/></happ><br>
					<small class="text-muted">${wmsutil:escapeHtml(vhost)}</small>
				</div>
			</c:when>
			<c:otherwise>
				<div class="col-md-5">
					<happ>${wmsutil:escapeHtml(appName)} <wmsform:getlocalestring page="appconfig.smilFiles" obj="head"/></happ><br>
					<small class="text-muted">${uiAppType}</small>
				</div>
				<wmsform:applicationbuttons page="${page}"/>
			</c:otherwise>
		</c:choose>
	</div>
	<div class="row col-md-12">
		<p id="pageText"></p>
	</div>
	<div class="notabs">
		<hr/>
	</div>
	<div class="row">
		<div class="col-md-8 main-content">
			<wmsform:rightrailhideshow/>
			<p><wmsform:getlocalestring page="smilFiles" obj="header"/></p>
			<h4><wmsform:getlocalestring page="smilFiles" obj="tableTitle"/></h4>
			<sec:authorize access="hasAnyRole('admin')">
				<p>
					<c:if test="${fn:length(requestScope.formData['smilFiles'])>0}">
						<wmsform:buttonprimary page= "smilFiles" obj="copySMILFile" onClick="javascript:copySMILFileShow();" icon="fa fa-files-o"/>
					</c:if>
					<wmsform:button page= "smilFiles" obj="addSMILFile" onClick="javascript:addSMILFileShow();" icon="fa fa-plus" cssClass="btn btn-default"/>
				</p>
			</sec:authorize>

			<wmstable:viewsmilfiles page="smilFiles" readonly='false'/>

		</div>
		<div id="HelpBasic" class="col-md-4 right-rail well-help pull-right">
			<jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
		</div>
	</div>
</div>

<wmsdialog:copysmilfile page="smilFiles"/>
<wmsdialog:addsmilfile page="smilFiles"/>

<script>
$(document).ready(function() {
});
</script>
