<h4>Configuring SMIL Files</h4>
<p>New SMIL files that you add in Wowza Streaming Engine Manager contain a basic XML tag structure for describing an adaptive bitrate streaming presentation. Configure the following options that provide details about your presentation:</p>

<h5>Title Attribute</h5>
<p>To add or change the optional <strong>title</strong> attribute in the &lt;smil&gt; tag, click <strong>Edit</strong> and then enter a title in the <strong>Title</strong> box.</p>

<h5>Stream Tags</h5>
<p>Each of the adaptive bitrate streams that are part of the streaming presentation should be identified by stream tags in the SMIL file &lt;switch&gt; container. To add a stream, click <strong>Add SMIL Stream</strong> to open the <strong>Add SMIL Stream</strong> dialog box. In the <strong>Type</strong> list, select one of the following tag types that corresponds to the stream type and click <strong>Add</strong>.</p>
<ul>
	<li><strong>video</strong>. A video stream (with or without audio). Adds the &lt;video&gt; tag to the &lt;switch&gt; container.
	<li><strong>audio</strong>. An audio-only stream. Adds the &lt;audio&gt; tag to the &lt;switch&gt; container.
	<li><strong>textstream</strong>. A stream or file that has captions. Adds the &lt;textstream&gt; tag to the &lt;switch&gt; container.
</ul>

<blockquote><strong>Note:</strong> You must specify tag attributes, such as the video and audio bitrate, for each stream that you add. A multiple bitrate streaming video presentation typically has many video streams encoded at different bitrates. It may also have separate copies of each video stream that are encoded for different system languages. Be sure to add each individual stream and specify its attributes to make it available in the SMIL file.</blockquote>

<p>To change the tag attributes for a stream, click the <strong>Edit</strong> icon for the stream.</p>

<p>To delete a stream from the SMIL file, click the <strong>Delete</strong> icon for the stream.</p>

<h5>Stream Tag Order</h5>
<p>Players evaluate the stream tags in the order that they occur in the &lt;switch&gt; container and select the first stream that's suitable for playback under current conditions. You should arrange the streams in a desirable order. For example, to ensure that a player selects and plays the highest bitrate stream that it can, given current network conditions and its available CPU resources, arrange the streams from the highest to lowest bitrate. If you plan to stream to a variety of players where network conditions may vary, you can help to ensure that most players can play a stream by arranging the streams from the lowest to highest bitrate. To arrange the streams in the desired order, return to the <strong>SMIL Files</strong> page, click the <strong>Edit</strong> icon for the SMIL file, and then use the <strong>Move Up</strong> and <strong>Move Down</strong> icons.</p>