<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<h4>About Virtual Host Performance Tuning</h4>
<p>Wowza Streaming Engine&#8482; is automatically tuned to take best advantage of available hardware resources when the server starts. The server calculates the number of threads used at the VHost level to service connections based on available server resources. You can adjust the following VHost performance settings from the default values that are calculated by the server:</p>
<ul>
	<li><strong>Net Connections Processor Count</strong>. The number of threads that service connections made between computers running the server software (for example, when using the live stream repeater). A value equal to 4 times the number of server cores is recommended. If the calculated value is less than 6 or greater than 32, those values are displayed as the minimum or maximum.

	<li><strong>Media Caster Processor Count</strong>. The number of threads that service connections for re-streaming IP camera streams (RTSP/RTP streams), SHOUTcast/Icecast streams, and native RTP encoders. A value equal to 4 times the number of server cores is recommended. If the calculated value is less than 6 or greater than 32, those values are displayed as the minimum or maximum.

	<li><strong>Idle Worker Count</strong>. The number of threads that are used to generate idle events. <em>Idle events</em> represent the streaming heartbeat for Adobe Flash and RTSP/RTP streaming. It represents how often new data is sent to the player. A value equal to 2 times the number of server cores is recommended. If the calculated value is less than 4 or greater than 24, those values are displayed as the minimum or maximum.

	<li><strong>Unicast Incoming</strong>/<strong>Outgoing Processor Count</strong>. The number of threads allocated to incoming and outgoing unicast UDP streams. A value equal to the number of server cores is recommended. If the calculated value is less than 4 or greater than 24, those values are displayed as the minimum or maximum.

	<li><strong>Multicast Incoming</strong>/<strong>Outgoing Processor Count</strong>. The number of threads allocated to incoming and outgoing multicast UDP streaming connections. A value equal to the number of server cores is recommended. If the calculated value is less than 4 or greater than 24, those values are displayed as the minimum or maximum.

	<li><strong>Client Idle Frequency</strong>. The time (in milliseconds) between idle events for Adobe Flash client connections. For basic video on demand (VOD) streaming, a value of <strong>250</strong> provides the best reliability-to-performance ratio. For live streaming, a value between <strong>125</strong> and <strong>250</strong> is better. Values between <strong>1</strong> and <strong>1000</strong> are supported.

	<li><strong>RTP Idle Frequency</strong>. The time (in milliseconds) between idle events for RTP connections. Values between <strong>1</strong> and <strong>1000</strong> are supported.
</ul>

<p>For more information, see <a href="https://www.wowza.com/docs/tune-wowza-streaming-engine-for-optimal-performance" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Tune Wowza Streaming Engine for optimal performance</a>.</p>

<h5>Virtual Host Tuning Settings</h5>
<p>To use the default setting that's calculated by the server when it starts, select <strong>Set automatically</strong>. Otherwise, select the alternate option button and enter a specific value in the box.</p>