<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<p><wmsform:getlocalestring page="common" obj="requiredField"/></p>
<fieldset>
	<form:hidden path="version"/>
	<form:hidden path="action"/>
	<form:hidden path="vhost"/>
	<form:hidden path="appName"/>
	<form:hidden path="appType"/>
	<form:hidden path="templateName"/>
	<form:hidden path="enable"/>

	<p>
		<c:choose>
			<c:when test="${action=='new'}">
				<wmsform:buttonadd  onClick="saveTemplateEncode()"/>
			</c:when>
			<c:otherwise>
				<wmsform:buttonsave onClick="saveTemplateEncode()"/>
			</c:otherwise>
		</c:choose>
		<c:choose>
			<c:when test="${action=='new' || action=='quickEdit'}">
				<wmsform:buttoncancel onClick="javascript:returnTranscoderTemplate()" />
			</c:when>
			<c:otherwise>
				<wmsform:buttoncancel onClick="javascript:showEncode('${encodeName}')" />
			</c:otherwise>
		</c:choose>
	</p>
	<c:choose>
		<c:when test="${action=='new'}">
			<wmsform:editproperty page="transcoder.template.encode" obj="encodeName" required="true"/>
		</c:when>
		<c:otherwise>
			<form:hidden path="encodeName"/>
		</c:otherwise>
	</c:choose>
	<wmsform:editproperty page="transcoder.template.encode" obj="streamName" cssClass="form-control"  required="true"/>
	<wmsform:editpropertytextarea page="transcoder.template.encode" obj="description" cssClass="form-control" autocapitalize="sentences"/>
	<hr />
	<h4><wmsform:getlocalestring page="transcoder.template.encode" obj="videoSectionTitle"/></h4>

	<wmsform:editpropertyradiolist page="transcoder.template.encode" obj="videoCodec"/>
	<wmsform:editproperty page="transcoder.template.encode" obj="videoBitrate" cssClass="form-control" cssSize="col-md-2" inputFilter='integer'/>
	<wmsform:editpropertydropdown page="transcoder.template.encode" obj="implementation" getLocalString="true" cssSize="col-md-4"/>
	<div id="GPUData" >
		<wmsform:editpropertyradiolist page="transcoder.template.encode" obj="GPUIDList"/>
		<div class="indent1">
			<wmsform:editproperty page="transcoder.template.encode" obj="GPUID" cssClass="form-control" showTitle="false" cssSize="col-md-2" inputFilter='integer' />
		</div>
	</div>
	<wmsform:editpropertydropdown page="transcoder.template.encode" obj="profile" getLocalString="true" cssSize="col-md-4"/>
	<wmsform:editpropertyradiolist page="transcoder.template.encode" obj="followSource"/>
	<div class="indent1">
		<wmsform:editproperty page="transcoder.template.encode" obj="interval" cssClass="form-control" showTitle="false" cssSize="col-md-2" inputFilter='integer' />
	</div>
	<hr>
	<h4><wmsform:getlocalestring page="transcoder.template.encode" obj="frameSizeSectionTitle"/></h4>
	<wmsform:editpropertydropdown page="transcoder.template.encode" obj="fitMode" cssSize="col-md-4"/>
	<wmsform:editproperty page="transcoder.template.encode" obj="width" cssClass="form-control" cssSize="col-md-2" inputFilter='integer'/>
	<wmsform:editproperty page="transcoder.template.encode" obj="height" cssClass="form-control" cssSize="col-md-2" inputFilter='integer'/>
	<label class="control-label">Crop</label>
	<p class="help-block"><wmsform:getlocalestring page="transcoder.template.encode" obj="cropHelp"/></p>
	<table>
		<tr>
			<td width="100px">
			</td>
				<td width="100px" class="text-center">
				<wmsform:editproperty page="transcoder.template.encode" obj="cropTop" cssClass="form-control" inputFilter='integer'/>
			</td>
			<td width="100px">
			</td>
		</tr>
		<tr>
				<td class="text-center">
				<wmsform:editproperty page="transcoder.template.encode" obj="cropLeft" cssClass="form-control" inputFilter='integer'/>
			</td>
			<td style="vertical-align:middle;padding-top:30px;" class="text-center">
				<i class="fa fa-picture-o fa-4x"></i>
			</td>
				<td class="text-center">
				<wmsform:editproperty page="transcoder.template.encode" obj="cropRight" cssClass="form-control" inputFilter='integer'/>
			</td>
		</tr>
		<tr>
			<td>
			</td>
				<td class="text-center">
				<wmsform:editproperty page="transcoder.template.encode" obj="cropBottom" cssClass="form-control" inputFilter='integer'/>
			</td>
			<td>
			</td>
		</tr>
	</table>


	<hr>
	<h4><wmsform:getlocalestring page="transcoder.template.encode" obj="audioSectionTitle"/></h4><wmsform:editpropertyradiolist page="transcoder.template.encode" obj="audioCodec"/>
	<wmsform:editproperty page="transcoder.template.encode" obj="audioBitrate" cssClass="form-control" cssSize="col-md-2" inputFilter='integer'/>
	<hr />
	<wmstable:editoverlays page="transcoder.template"/>

	<p><c:choose>
		<c:when test="${action=='new'}">
			<wmsform:buttonadd  onClick="saveTemplateEncode()"/>
			<wmsform:buttoncancel onClick="javascript:returnTranscoderTemplate()" />
		</c:when>
		<c:otherwise>
			<wmsform:buttonsave onClick="saveTemplateEncode()"/>
			<wmsform:buttoncancel onClick="javascript:showEncode('${encodeName}')" />
		</c:otherwise>
	</c:choose></p>
</fieldset>

<script>
setGPUIDisabled();
setEncodeImplementation();
setIntervalDisabled();
setFitModeDisabled();
setAudioOptionsDisabled();
setVideoOptionsDisabled();

function saveTemplateEncode()
{
 		postAJAXFormDstFormName('server/transcoderencode/edit.htm','', "mainContent", "encodeEditForm");
}

$(document).ready(function() {

	$('input[name="videoCodec"]').click(function() {
		setVideoOptionsDisabled();
	});
	$('input[name="GPUIDList"]').click(function() {
		setGPUIDisabled();
	});
	$('#implementation').change(function() {
		setEncodeImplementation();
	});
	$('input[name="followSource"]').click(function() {
		setIntervalDisabled();
	});
	$('#fitMode').change(function() {
		setFitModeDisabled();
	});
	$('input[name="audioCodec"]').click(function() {
		setAudioOptionsDisabled();
	});
});

function setVideoOptionsDisabled()
{
	var elem=$('input[name="videoCodec"]:checked');
	var dis  = (elem.val()=="Disable" || elem.val()=="PassThru");
	var h263 = (elem.val()=="H.263");
	var h265 = (elem.val()=="H.265");
	$('#videoBitrate').prop('disabled', dis);
	$('#implementation').prop('disabled', dis);
	$('input[name=GPUIDList]').attr("disabled",dis);;
	$('#profile').prop('disabled', dis);
	$('input[name=followSource]').attr("disabled",dis);;
	$('#fitMode').prop('disabled', dis);
	$('#cropLeft').prop('disabled', dis);
	$('#cropRight').prop('disabled', dis);
	$('#cropTop').prop('disabled', dis);
	$('#cropBottom').prop('disabled', dis);
	if(dis)
	{
		$('#videoBitrate').val("");
		$("input:radio[name=GPUIDList]:first").prop('checked', true);
		$('#GPUID').prop('disabled', dis);
		$('#GPUID').val("");
		$("input:radio[name=followSource]:first").prop('checked', true);
		$('#interval').prop('disabled', dis);
		$('#interval').val("");
		$('#height').prop('disabled', dis);
		$('#width').prop('disabled', dis);
		$('#cropLeft').val("");
		$('#cropRight').val("");
		$('#cropTop').val("");
		$('#cropBottom').val("");
	}
	else
	{
		setFitModeDisabled();
		if ($('#cropLeft').val() == "")
			$('#cropLeft').val("0");
		if ($('#cropRight').val() == "")
			$('#cropRight').val("0");
		if ($('#cropTop').val() == "")
			$('#cropTop').val("0");
		if ($('#cropBottom').val() == "")
			$('#cropBottom').val("0");
	}

	if(h263)
	{
		$('input[name=GPUIDList]').prop("disabled",true);;
		$("input:radio[name=GPUIDList]:first").prop('checked', true);
		$('#GPUID').val("");
		$('#implementation').prop('disabled', true);
		$('#implementation').val("default");
	}
	else if(h265)
	{
		$('#profile').prop('disabled', true);
		$('#profile').val("main");
	}
}

function setGPUIDisabled()
{
	var dis = $("input:radio[name=GPUIDList]:first").is(':checked');
	$('#GPUID').prop('disabled', dis);
	if(dis)
	{
		$('#GPUID').val("");
	}
}

function setEncodeImplementation()
{
	if ($('#implementation').val() == "QuickSync")
	{
		$("input:radio[name=GPUIDList]:first").prop('checked', true);
		$('#GPUID').prop('disabled', true);
		$('#GPUID').val("");
		$('#GPUData').hide();
	}
	else
	{
		$('#GPUData').show();
	}
}

function setIntervalDisabled()
{
	var dis = $("input:radio[name=followSource]:first").is(':checked');
	$('#interval').prop('disabled', dis);
	if(dis)
	{
		$('#interval').val("");
	}
}

function setFitModeDisabled()
{
	var fmode = $("#fitMode").val();
	$('#width').prop('disabled', false);
	$('#height').prop('disabled', false);
	if(fmode=="fit-height")
	{
		$('#width').prop('disabled', true);
		$('#width').val("");
	}
	if(fmode=="fit-width")
	{
		$('#height').prop('disabled', true);
		$('#height').val("");
	}
	if(fmode=="match-source")
	{
		$('#width').prop('disabled', true);
		$('#height').prop('disabled', true);
		$('#width').val("");
		$('#height').val("");
	}
}

function setAudioOptionsDisabled()
{
	var elem=$('input[name="audioCodec"]:checked');
	var dis  = (elem.val()=="Disable" || elem.val()=="PassThru");
	$('#audioBitrate').prop('disabled', dis);
	if(dis)
	{
		$('#audioBitrate').val("");
	}
}
</script>
