<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<wmsform:setpagetitle page="transcoder"/>
<c:set var="licensed" value="${requestScope.formData['licensed']}"/>
<div>
  	<div id="generic.warnings" class="alert alert-warning" style="display:none"></div>
	<c:forEach var="msg" items="${formData.genericMessages}">
	    <div class="row">
	    	<div class="col-md-12">
	  	    	<div class="alert alert-success">
	        		<strong>${msg}</strong>
	    		</div> 
	        </div>
	    </div>
	</c:forEach>
	<div class="row">
        <div class="col-md-6">
      		<happ>Transcoder</happ><br>
	      	<small class="text-muted"></small>
        </div>
        <div class="col-md-6 appbuttons" id="transcoderButtons">
	    </div>
	</div>
	<c:choose>
		<c:when test="${!licensed}">
			<p><wmsform:getlocalestring page="transcoder.unlicensed" obj="header"/></p>
		</c:when>
		<c:otherwise>
			<hr>
			<div class="row">
				<div class="col-md-8 main-content">
                  <wmsform:rightrailhideshow/>
					<p><wmsform:getlocalestring page="transcoder.licensed" obj="header"/></p>
					<h4><wmsform:getlocalestring page="transcoder" obj="usage"/></h4>
					<wmsform:viewpropertyint page="transcoder" obj="licensesInUse"/>
					<c:if test="${requestScope.formData['licenses']>=0}">
						<wmsform:viewpropertyint page="transcoder" obj="licenses"/>
					</c:if>
					<hr>
					<h4><wmsform:getlocalestring page="transcoder" obj="tableTitle"/></h4>
					<sec:authorize access="hasAnyRole('admin')">		
						<p>
							<c:if test="${fn:length(requestScope.formData['templates'])>0}">
								<wmsform:buttonprimary page= "transcoder" obj="copyTemplate" onClick="javascript:copyTranscoderTemplateShow();" icon="fa fa-files-o"/>
							</c:if>
							<wmsform:button page= "transcoder" obj="addTemplate" onClick="javascript:addTranscoderTemplateShow();" icon="fa fa-plus"/>
						</p>
					</sec:authorize>
					<wmstable:viewtranscodertemplates page="transcoder" readonly='false'/>
					<br>
				</div>
				<div id="HelpBasic" class="col-md-4 well-help pull-right right-rail">
					<jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
				</div>
			</div>
		</c:otherwise>
	</c:choose>
</div>

<wmsform:setwarnings/>	
<wmsdialog:addtranscodertemplate page="transcoder"/>
<wmsdialog:copytranscodertemplate page="transcoder"/>

<script>
function copyTemplate(name,displayName)
{
	copyTemplateName=name;
	copyTemplateDisplayName=displayName;
	copyTranscoderTemplateShow();
	return;
}

$(document).ready(function() {

	lastTemplate="";
	//createCookie("lastTemplate",lastTemplate);
	lastTemplateEncode="";
	//createCookie("lastTemplateEncode",lastTemplateEncode);
});
</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>







