<h4>About Incoming Streams</h4>
<p>You can view details about all live streams published to this application or live streams that this application connects to and record the streams to video on demand (VOD) files for later playback.</p>

<p>To update the list of incoming streams, click <strong>Refresh</strong>. Wowza Streaming Engine doesn't update the list automatically as new streams are published to this application.</p>

<p>To view details about an incoming stream, click the incoming stream name in the list.</p>

<p>To organize the list of incoming streams alphabetically, click <strong>View by Stream</strong>. If the incoming streams are part of a group of streams, either the transcoded output in a stream name group or live streams referenced in a SMIL file, click <strong>View by Group</strong> to organize the list of incoming streams alphabetically by group name. Incoming streams that aren't part of a group will be displayed in a group named <strong>Ungrouped Streams</strong>.</p>

<p>For incoming streams from PTZ cameras, click the <strong>Pan/Tilt/Zoom</strong> icon for the stream. The <strong>Pan/Tilt/Zoom Controller</strong> dialog box that appears has camera controls and a preview of the camera feed.</p>

<blockquote><strong>Note:</strong><br />Different camera models implement the PTZ features in different ways. If your camera doesn't respond to these controls, it may not be supported at this time.</blockquote>

<p>To record an incoming live stream, click the <strong>Record</strong> icon for the stream to open the <strong>Record</strong> dialog box. In the dialog box, configure options that control how the live stream is recorded. For details, see <strong>Live Stream Recording Options</strong> below.</p>

<p>To stop recording an incoming live stream, click the <strong>Stop Recording</strong> icon for the stream.</p>

<p>To stop the current recording and then start recording the same incoming live stream to a new file, click the <strong>Split Recording</strong> icon for the stream.</p>

<p>For managed streams that this application connects to through the MediaCaster system, click the <strong>Disconnect</strong> icon to disconnect the application from stream. To reset the managed stream (disconnect and then reconnect), click the <strong>Reset Stream</strong> icon for the stream.</p>

<h4>Live Stream Recording Options</h4>
<p>You can record incoming live streams to video on demand files for later playback. You can split in-process live streams into multiple on-demand MP4 (QuickTime container) files or FLV (Flash Video container) files, with the split points based on video duration, clock time, or file size.</p>

<h5>File Name</h5>
<p>The base file name of the recorded file. You can change the default output file names of your recorded files by entering a new file name. The name can't contain less-than (&lt;), greater-than (&gt;), colon (&#58;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), asterisk (&#42;), double-dot (..), and tilde (&#126;) characters.</p>

<h5>Path</h5>
<p>The physical path of a location on the computer where the recorded files are stored. By default, the files are stored in the server <strong>content</strong> directory. If you want to store files in a different location, make sure that it exists on the computer and then specify its physical path. The path value can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), backslash (&#92;), pipe (&#124;), question mark (&#63;), and asterisk (&#42;) characters.</p>

<h5>Output File Format</h5>
<p>The video on demand format of the recorded file, either <strong>MP4</strong> (the default value) or <strong>FLV</strong>.</p>

<h5>Recording Options</h5>
<ul>
	<li><strong>Record data</strong>. If metadata is available in the live stream, include it in the recorded file.

	<li><strong>Start on key frame</strong>. Start recording the live stream at the first key frame that's encountered.
</ul>

<h5>Segmentation Option</h5>
<p>The segmentation options specify how live streams are recorded to multiple files. The split points can be based on the recorded file size or duration, or on a schedule:</p>

<p><strong>None</strong>. Record the live stream to a single file (the default setting). Select a <strong>Versioning Option</strong> that specifies what to do if the live stream is restarted:</p>
<ul>
	<li><strong>Append to existing file</strong>. Resume recording the live stream to the existing file.
	<li><strong>Version existing file</strong>. Start recording the live stream to a new file (the default setting). The live stream will be recorded to a new file with a file name that's generated using the format <em>[streamName]</em>_<em>[segmentNumber]</em>. The <strong>File Versioning Template</strong> value isn't used.
	<li><strong>Overwrite existing file</strong>. Start recording the live stream to a new file with the same name as the existing file. This option will replace the previously recorded file with a new one.
</ul>

<p><strong>Segment by size</strong>. Split the live stream into multiple on-demand files with a maximum size. Specify the maximum size value (in megabytes) in <strong>Segment Size</strong>. The minimum supported segment size is 1&nbsp;MB. The live stream will be recorded to a new file with a file name that's generated using the <strong>File Versioning Template</strong> value.</p>

<p><strong>Segment by duration</strong>. Split the live stream into multiple on-demand files with a maximum duration. Specify the maximum duration value (in <em>Hours</em>:<em>Minutes</em>:<em>Seconds</em>) in <strong>Segment Duration</strong>. The minimum supported segment duration is 10&nbsp;seconds. The live stream will be recorded to a new file with a file name that's generated using the <strong>File Versioning Template</strong> value.</p>

<p><strong>Segment by schedule</strong>. Split the live stream into multiple on-demand files based on a schedule. Specify the schedule by selecting one of the following <strong>Segment Schedule</strong> options:</p>
<ul>
	<li><strong>Every hour on the hour</strong>. Split the recording into a new file at the top of each hour. This is the default setting.
	<li><strong>Advanced</strong>. Split the recording using a customized segmentation schedule that's derived from an <a href="https://www.wowza.com/docs/how-to-record-live-streams-wowza-streaming-engine#crontab" target="_blank"><i class="fa fa-external-link"></i>&nbsp;nnCron cron expression</a>.</p>
</ul>

<h5>File Versioning Template/Module</h5>
<p>If you select a <strong>Segmentation Option</strong> that requires live streams to be recorded to multiple files, the file names of new recordings are created based on the template variables specified in <strong>File Versioning Template</strong> using the module specified in <strong>File Versioning Module</strong>. For more information about template variable values that you can use in <strong>File Versioning Template</strong>, see <a href="https://www.wowza.com/docs/how-to-record-live-streams-wowza-streaming-engine#setfiletemplate" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Defining filenames of recorded segments with template strings</a>. To specify your own module that creates file names, enter the custom module name in <strong>File Versioning Module</strong>.</p>