/*
 * Decompiled with CFR 0.152.
 */
package com.wowza.wms.http;

import com.wowza.wms.application.IApplication;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.client.ConnectionCounter;
import com.wowza.wms.client.IClient;
import com.wowza.wms.http.HTTPServerVersion;
import com.wowza.wms.http.HTTProvider2Base;
import com.wowza.wms.http.IHTTPRequest;
import com.wowza.wms.http.IHTTPResponse;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.logging.WMSLoggerFactory;
import com.wowza.wms.vhost.IVHost;
import com.wowza.wms.vhost.VHostSingleton;
import java.io.OutputStream;
import java.util.List;

public class HTTPServerStatsXML
extends HTTProvider2Base {
    private void outputConnectionInfo(StringBuffer ret, ConnectionCounter counter) {
        ret.append("<ConnectionsCurrent>" + counter.getCurrent() + "</ConnectionsCurrent>");
    }

    public String fixNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public void onHTTPRequest(IVHost inVhost, IHTTPRequest req, IHTTPResponse resp) {
        if (!this.doHTTPAuthentication(inVhost, req, resp)) {
            return;
        }
        StringBuffer ret = new StringBuffer();
        long currTime = System.currentTimeMillis();
        try {
            List vhostNames = VHostSingleton.getVHostNames();
            ret.append("<?xml version=\"1.0\"?>\n<WowzaMediaServerPro>");
            for (String vhostName : vhostNames) {
                IVHost vhost = VHostSingleton.getInstance((String)vhostName);
                if (vhost == null) continue;
                ret.append("<VHost>");
                ret.append("<Name>" + vhostName + "</Name>");
                this.outputConnectionInfo(ret, vhost.getConnectionCounter());
                List appNames = vhost.getApplicationNames();
                List appFolders = vhost.getApplicationFolderNames();
                for (String applicationName : appFolders) {
                    ret.append("<Application>");
                    ret.append("<Name><![CDATA[" + applicationName + "]]></Name>");
                    boolean appExists = appNames.contains(applicationName);
                    ret.append("<Status>" + (appExists ? "loaded" : "unloaded") + "</Status>");
                    if (appExists) {
                        IApplication application = vhost.getApplication(applicationName);
                        if (application == null) continue;
                        this.outputConnectionInfo(ret, application.getConnectionCounter());
                        List appInstances = application.getAppInstanceNames();
                        for (String appInstanceName : appInstances) {
                            IApplicationInstance appInstance = application.getAppInstance(appInstanceName);
                            if (appInstance == null) continue;
                            ret.append("<ApplicationInstance>");
                            this.outputConnectionInfo(ret, appInstance.getConnectionCounter());
                            List clients = appInstance.getClients();
                            List httpSessions = appInstance.getHTTPStreamerSessions();
                            for (IClient client : clients) {
                                if (client == null) continue;
                                ret.append("<Client>");
                                ret.append("<ID>" + client.getClientId() + "</ID>");
                                ret.append("<FlashVersion>" + client.getFlashVer() + "</FlashVersion>");
                                ret.append("<IpAddress>" + client.getIp() + "</IpAddress>");
                                ret.append("<TimeRunning>" + client.getTimeRunningSeconds() + "</TimeRunning>");
                                ret.append("<Type>rtmp</Type>");
                                ret.append("<URI><![CDATA[" + client.getUri() + "]]></URI>");
                                ret.append("<QueryString><![CDATA[" + this.fixNull(client.getQueryStr()) + "]]></QueryString>");
                                ret.append("</Client>");
                            }
                            for (IHTTPStreamerSession httpSession : httpSessions) {
                                if (httpSession == null) continue;
                                ret.append("<Client>");
                                ret.append("<ID>" + httpSession.getSessionId() + "</ID>");
                                ret.append("<IpAddress>" + httpSession.getIpAddress() + "</IpAddress>");
                                ret.append("<TimeRunning>" + httpSession.getTimeRunningSeconds() + "</TimeRunning>");
                                ret.append("<Type>http</Type>");
                                ret.append("<Proxy><![CDATA[" + httpSession.getUserAgent() + "]]></Proxy>");
                                ret.append("</Client>");
                            }
                            ret.append("</ApplicationInstance>");
                        }
                    }
                    ret.append("</Application>");
                }
                ret.append("</VHost>");
            }
            ret.append("</WowzaMediaServerPro>");
        }
        catch (Exception e) {
            WMSLoggerFactory.getLogger(HTTPServerVersion.class).error("HTTPServerStatsXML.onHTTPRequest: " + e.toString());
            e.printStackTrace();
        }
        try {
            resp.setHeader("Content-Type", "text/xml");
            OutputStream out = resp.getOutputStream();
            byte[] outBytes = ret.toString().getBytes();
            out.write(outBytes);
        }
        catch (Exception e) {
            WMSLoggerFactory.getLogger(HTTPServerVersion.class).error("HTTPServerStatsXML.onHTTPRequest: " + e.toString());
            e.printStackTrace();
        }
    }
}

