<?php
require_once("inc/protecao-admin.php");

if($dados_config["idioma_painel"] == "pt-br") {
$lang_sortable = "Portuguese-Brasil";
} elseif($dados_config["idioma_painel"] == "en-us") {
$lang_sortable = "English";
} else {
$lang_sortable = "Spanish";
}

?>
<!doctype html>
<html lang="es" dir="ltr">
	<head>
		<meta charset="UTF-8">
		<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Administraci&oacute;n</title>
		<link rel="icon" href="/img/favicon.png" type="image/x-icon"/>
		<link href="/inc/css/icons.css" rel="stylesheet">
		<link id="style" href="/inc/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" />
		<link href="/inc/css/theme.css" rel="stylesheet">
		<link href="/inc/css/theme-dark.css" rel="stylesheet">
		<link href="/inc/css/style-transparent.css" rel="stylesheet">
		<link href="/inc/css/skin-modes.css" rel="stylesheet" />
		<link href="/inc/css/animate.css" rel="stylesheet">
		<script type="text/javascript" src="/admin/inc/ajax.js"></script>
		<script type="text/javascript" src="/admin/inc/javascript.js"></script>
	</head>
	<body class="ltr main-body app sidebar-mini <?php if($dados_config["tema_painel"] == "light-theme") { ?>light-theme<?php } else { ?>dark-theme<?php } ?>">
		<!-- Loader -->
		<div id="global-loader">
			<img src="/inc/img/loader.svg" class="loader-img" alt="Loader">
		</div>
		<!-- /Loader -->
		<!-- Page -->
		<div class="page">
			<div class="open">
				<!-- main-header -->
				<?php require_once("header-admin.php");?>				
				<!-- /main-header -->
				<!-- main-sidebar -->
				<div class="sticky">
					<aside class="app-sidebar">
						<div class="main-sidebar-header active">
							<a class="header-logo active" href="/dashboard">
								<img src="/img/logo.png" class="main-logo  desktop-logo" alt="Painel Streaming">
								<img src="/img/logo.png" class="main-logo  desktop-dark" alt="Painel Streaming">
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-logo" alt="logo">
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-dark" alt="logo">
							</a>
						</div>
						<?php require_once("menu-admin.php");?>
					</aside>
				</div>
				<!-- main-sidebar -->
			</div>

			<!-- main-content -->
			<div class="main-content app-content">

				<!-- container -->
				<div class="main-container container-fluid">

					<!-- breadcrumb -->
					<div class="breadcrumb-header justify-content-between" style="padding-top:60px">
						<div class="left-content">
						  <span class="main-content-title mg-b-0 mg-b-lg-1"><?php echo lang_pagina_apps_titulo; ?></span>
						</div>
						<div class="justify-content-center mt-2">
							<ol class="breadcrumb">
								<li class="breadcrumb-item tx-15"><a href="/admin/admin-configuracoes">Dashboard</a></li>
								<li class="breadcrumb-item active" aria-current="page"><?php echo lang_pagina_apps_titulo; ?></li>
							</ol>
						</div>
					</div>
					<!-- /breadcrumb -->

					<!-- row -->
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header d-flex custom-card-header border-bottom-0 ">
                    <header><?php echo lang_pagina_revendas_titulo; ?></header>
                                        <div class="card-options">
                                            <button type="button" class="btn btn-info" onClick="window.location = '/admin/admin-cadastrar-revenda';"><i class="fa fa-file-plus"></i><?php echo lang_botao_titulo_cadastrar; ?></button>
                                        </div>
                  </div>
                <div class="card-body">
                    <table id="data_table" class="table dataTable no-footer table-hover" role="grid" aria-describedby="data_table_info">
                                                <thead>
                                                    <tr role="row">
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_revendas_responsavel; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_revendas_plano; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_revendas_streamings; ?></th>
                                                        <th><?php echo lang_pagina_revendas_acoes; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php

if(query_string('2') == 'resultado') {

if(preg_match("/@/i",query_string('3'))) {
$query = "SELECT * FROM revendas where email like '%".query_string('3')."%'";
} else {
$query = "SELECT * FROM revendas where (nome like '%".query_string('3')."%' AND tipo = '1') OR id = '".query_string('3')."'";
}

} else {
$query = "SELECT * FROM revendas where tipo = '1'";
}

$sql = mysqli_query($conexao,"".$query." ORDER by nome ASC");
while ($dados_revenda = mysqli_fetch_array($sql)) {

$total_stm = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings where codigo_cliente = '".$dados_revenda["codigo"]."'"));

$limite_subrevendas = ($dados_revenda["subrevendas"] == 999999) ? "Ilimitado" : $dados_revenda["subrevendas"];
$limite_streamings = ($dados_revenda["streamings"] == 999999) ? "Ilimitado" : $dados_revenda["streamings"];
$limite_espectadores = ($dados_revenda["espectadores"] == 999999) ? "Ilimitado" : $dados_revenda["espectadores"];

if($dados_revenda["status"] > 1) {
$cor_status = "class='table-danger'";
}

$revenda_code = code_decode($dados_revenda["codigo"],"E");

echo "<tr id='".$revenda_code."' ".$cor_status.">
<td height='25' align='left' scope='col'>&nbsp;".$dados_revenda["nome"]." - ".$dados_revenda["id"]."&nbsp;</td>
<td height='25' align='left' scope='col'>&nbsp;".$limite_subrevendas." / ".$limite_streamings." / ".$limite_espectadores." / ".$dados_revenda["bitrate"]." Kbps / ".tamanho($dados_revenda["espaco"])."</td>
<td height='25' align='center' scope='col'>&nbsp;".$total_stm."</td>
<td height='25' align='left' scope='col'><a href='javascript:acessar_painel_revenda(\"".$revenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_streamings_acao_acessar_painel."'><i class='fa fa-home f-16 text-pink'></i></a>&nbsp;<a href='/admin/admin-configurar-revenda/".$revenda_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_alterar_configuracao."'><i class='fa fa-edit f-16 text-blue'></i></a>&nbsp;
<a href='/admin/admin-streamings/resultado-revenda/".$revenda_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_listar_streamings."'><i class='fa fa-video-camera f-16 text-green'></i></a>&nbsp;
<a href='javascript:alterar_senha_revenda(\"".$revenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_alterar_senha."'><i class='fa fa-lock f-16 text-yellow'></i></a>&nbsp;
<a href='javascript:bloquear_revenda(\"".$revenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_bloquear."'><i class='fa fa-ban f-16 text-red'></i></a>&nbsp;
<a href='javascript:desbloquear_revenda(\"".$revenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_desbloquear."'><i class='fa fa-check-circle f-16 text-green'></i></a>&nbsp;
<a href='/admin/admin-revenda-mover-streamings/".$revenda_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_mover_streamings."'><i class='fa fa-retweet f-16 text-pink'></i></a>&nbsp;
<a href='/admin/admin-revenda-mover-streamings-servidor/".$revenda_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_mover_streamings_servidor."'><i class='fa fa-retweet f-16 text-purple'></i></a>&nbsp;
<a href='javascript:remover_revenda(\"".$revenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_remover."'><i class='fa fa-trash f-16 text-red'></i></a>&nbsp;</td>
</tr>";

unset($cor_status);

// Verifique se tem subrevenda e lista
$total_subrevendas = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM revendas WHERE codigo_revenda = '".$dados_revenda["codigo"]."'"));

if($total_subrevendas > 0) {

$sql_subrevenda = mysqli_query($conexao,"SELECT * FROM revendas where codigo_revenda = '".$dados_revenda["codigo"]."' ORDER by id ASC");
while ($dados_subrevenda = mysqli_fetch_array($sql_subrevenda)) {

$total_stm = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings where codigo_cliente = '".$dados_subrevenda["codigo"]."'"));

$limite_subrevendas = ($dados_subrevenda["subrevendas"] == 999999) ? "Ilimitado" : $dados_subrevenda["subrevendas"];
$limite_streamings = ($dados_subrevenda["streamings"] == 999999) ? "Ilimitado" : $dados_subrevenda["streamings"];
$limite_espectadores = ($dados_subrevenda["espectadores"] == 999999) ? "Ilimitado" : $dados_subrevenda["espectadores"];

if($dados_subrevenda["status"] > 1) {
$cor_status = "class='table-danger'";
}

$subrevenda_code = code_decode($dados_subrevenda["codigo"],"E");

echo "<tr id='".$subrevenda_code."' ".$cor_status.">
<td align='left' scope='col'><i class='fa fa-chevron-right f-12 text-blue' style='padding-left:20px'></i>&nbsp;".$dados_subrevenda["nome"]." - ".$dados_subrevenda["id"]."</td>
<td align='left' scope='col'>&nbsp;".$limite_subrevendas." / ".$limite_streamings." / ".$limite_espectadores." / ".$dados_subrevenda["bitrate"]." Kbps / ".tamanho($dados_subrevenda["espaco"])."</td>
<td align='center' scope='col'>&nbsp;".$total_stm."</td>
<td height='25' align='left' scope='col'><a href='javascript:acessar_painel_revenda(\"".$revenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_streamings_acao_acessar_painel."'><i class='fa fa-home f-16 text-pink'></i></a>&nbsp;<a href='/admin/admin-configurar-revenda/".$subrevenda_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_alterar_configuracao."'><i class='fa fa-pencil f-16 text-blue'></i></a>&nbsp;
<a href='/admin/admin-streamings/resultado-revenda/".$subrevenda_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_listar_streamings."'><i class='fa fa-video-camera f-16 text-green'></i></a>&nbsp;
<a href='javascript:alterar_senha_revenda(\"".$subrevenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_alterar_senha."'><i class='fa fa-lock f-16 text-yellow'></i></a>&nbsp;
<a href='javascript:bloquear_revenda(\"".$subrevenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_bloquear."'><i class='fa fa-ban f-16 text-red'></i></a>&nbsp;
<a href='javascript:desbloquear_revenda(\"".$subrevenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_desbloquear."'><i class='fa fa-check-circle f-16 text-green'></i></a>&nbsp;
<a href='/admin/admin-revenda-mover-streamings/".$subrevenda_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_mover_streamings."'><i class='fa fa-retweet f-16 text-pink'></i></a>&nbsp;
<a href='/admin/admin-revenda-mover-streamings-servidor/".$subrevenda_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_mover_streamings_servidor."'><i class='fa fa-retweet f-16 text-purple'></i></a>&nbsp;
<a href='javascript:remover_revenda(\"".$subrevenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_remover."'><i class='fa fa-trash f-16 text-red'></i></a>&nbsp;</td>
</tr>";

// Verifique se tem subrevenda e lista
$total_subrevendas_sub = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM revendas WHERE codigo_revenda = '".$dados_subrevenda["codigo"]."'"));

if($total_subrevendas_sub > 0) {

$sql_subrevenda_sub = mysqli_query($conexao,"SELECT * FROM revendas where codigo_revenda = '".$dados_subrevenda["codigo"]."' ORDER by id ASC");
while ($dados_subrevenda_sub = mysqli_fetch_array($sql_subrevenda_sub)) {

$total_stm = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings where codigo_cliente = '".$dados_subrevenda_sub["codigo"]."'"));

$limite_subrevendas = ($dados_subrevenda_sub["subrevendas"] == 999999) ? "Ilimitado" : $dados_subrevenda_sub["subrevendas"];
$limite_streamings = ($dados_subrevenda_sub["streamings"] == 999999) ? "Ilimitado" : $dados_subrevenda_sub["streamings"];
$limite_espectadores = ($dados_subrevenda_sub["espectadores"] == 999999) ? "Ilimitado" : $dados_subrevenda_sub["espectadores"];

if($dados_subrevenda["status"] > 1) {
$cor_status = "class='table-danger'";
}

$subrevenda_sub_code = code_decode($dados_subrevenda_sub["codigo"],"E");

echo "<tr id='".$subrevenda_sub_code."' ".$cor_status.">
<td align='left' scope='col'><i class='fa fa-long-arrow-right f-12 text-blue' style='padding-left:25px'></i>&nbsp;".$dados_subrevenda_sub["nome"]." - ".$dados_subrevenda_sub["id"]."</td>
<td align='left' scope='col'>&nbsp;".$limite_subrevendas." / ".$limite_streamings." / ".$limite_espectadores." / ".$dados_subrevenda_sub["bitrate"]." Kbps / ".tamanho($dados_subrevenda_sub["espaco"])."</td>
<td align='center' scope='col'>&nbsp;".$total_stm."</td>
<td height='25' align='left' scope='col'><a href='javascript:acessar_painel_revenda(\"".$revenda_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_streamings_acao_acessar_painel."'><i class='fa fa-home f-16 text-pink'></i></a>&nbsp;<a href='/admin/admin-configurar-revenda/".$subrevenda_sub_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_alterar_configuracao."'><i class='fa fa-pencil f-16 text-blue'></i></a>&nbsp;
<a href='/admin/admin-streamings/resultado-revenda/".$subrevenda_sub_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_listar_streamings."'><i class='fa fa-video-camera f-16 text-green'></i></a>&nbsp;
<a href='javascript:bloquear_revenda(\"".$subrevenda_sub_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_bloquear."'><i class='fa fa-ban f-16 text-red'></i></a>&nbsp;
<a href='javascript:desbloquear_revenda(\"".$subrevenda_sub_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_desbloquear."'><i class='fa fa-check-circle f-16 text-green'></i></a>&nbsp;
<a href='/admin/admin-revenda-mover-streamings/".$subrevenda_sub_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_mover_streamings."'><i class='fa fa-retweet f-16 text-pink'></i></a>&nbsp;
<a href='/admin/admin-revenda-mover-streamings-servidor/".$subrevenda_sub_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_mover_streamings_servidor."'><i class='fa fa-retweet f-16 text-purple'></i></a>&nbsp;
<a href='javascript:remover_revenda(\"".$subrevenda_sub_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_revendas_acao_remover."'><i class='fa fa-trash f-16 text-red'></i></a>&nbsp;</td>
</tr>";

unset($cor_status);
}
}

}
}

}
?>
                                                </tbody>
                                            </table>
                </div>
              </div>
            </div>

          <!-- cards closed -->
					</div>
					<!-- row closed -->
				</div>
				<!-- Container closed -->
			</div>
			<!-- main-content closed -->

			<!-- Country-selector modal-->
			<div class="modal fade" id="country-selector">
				<div class="modal-dialog modal-dialog-centered" role="document">
					<div class="modal-content">
						<div class="modal-header border-bottom">
							<h6 class="modal-title"><?php echo lang_pagina_configuracoes_idioma_painel; ?></h6><button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
						</div>
						<div class="modal-body">
							<ul class="row p-3">
								<li class="col-lg-6 mb-2">
									<a href="/admin/admin-mudar-idioma/es" class="btn btn-country btn-lg btn-block <?php if($dados_config["idioma_painel"] == "es") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/py.svg" class="me-3 language"></span>Espa&ntilde;ol
									</a>
								</li>
								<li class="col-lg-6 mb-2 mb-2">
									<a href="/admin/admin-mudar-idioma/pt-br" class="btn btn-country btn-lg btn-block <?php if($dados_config["idioma_painel"] == "pt-br") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/br.svg" class="me-3 language"></span>Portugu&ecirc;s(Brasil)
									</a>
								</li>
								<!--
								<li class="col-lg-6 mb-2">
									<a href="/admin/admin-mudar-idioma/en" class="btn btn-country btn-lg btn-block <?php if($dados_config["idioma_painel"] == "en") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/us.svg" class="me-3 language"></span>English(USA)
									</a>
								</li>-->
							</ul>
						</div>
					</div>
				</div>
			</div>
			<!-- Modal -->
			<?php require_once("modal-admin.php");?>
		</div>
		<!-- End Page -->
		<a href="#top" id="back-to-top"><i class="las la-arrow-up"></i></a>
  
		<script src="/inc/plugins/jquery/jquery.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/popper.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/bootstrap.min.js"></script>
		<script src="/inc/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
		<script src="/inc/plugins/side-menu/sidemenu.js"></script>
		<!-- Internal Data tables -->
		<script src="/inc/plugins/datatable/js/jquery.dataTables.min.js"></script>
		<script src="/inc/plugins/datatable/js/dataTables.bootstrap5.js"></script>
		<script src="/inc/plugins/datatable/js/dataTables.buttons.min.js"></script>
		<script src="/inc/plugins/datatable/js/buttons.bootstrap5.min.js"></script>
		<script src="/inc/plugins/datatable/js/jszip.min.js"></script>
		<script src="/inc/plugins/datatable/pdfmake/pdfmake.min.js"></script>
		<script src="/inc/plugins/datatable/pdfmake/vfs_fonts.js"></script>
		<script src="/inc/plugins/datatable/js/buttons.html5.min.js"></script>
		<script src="/inc/plugins/datatable/js/buttons.print.min.js"></script>
		<script src="/inc/plugins/datatable/js/buttons.colVis.min.js"></script>
		<script src="/inc/plugins/datatable/dataTables.responsive.min.js"></script>
		<script src="/inc/plugins/datatable/responsive.bootstrap5.min.js"></script>
		<script src="/inc/js/table-data.js"></script>
		<!-- End Internal Data tables -->
		<script src="/inc/js/theme.js"></script>
  <script>
  $('#busca_chave').keypress(function (e) {
    if (e.which == 13) {
       window.location = "/admin/admin-streamings/resultado/"+document.getElementById("busca_chave").value;
    }
  }); 
        $(document).ready(function() {

            var table = $('#data_table').DataTable({
                responsive: true,
                "aaSorting": [],
                "order": [],
                "lengthMenu": [[25, 50, 100, 200, -1], [25, 50, 100, 200, "Todos/All"]],
                language: {
                    "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo $lang_sortable; ?>.json"
                },
                select: true,
                'aoColumnDefs': [{
                    'bSortable': false,
                    'aTargets': ['nosort']
                }]
            });
            $('#data_table tbody').on( 'click', 'tr', function() {
                if ( $(this).hasClass('selected') ) {
                    $(this).removeClass('selected');
                }
                else {
                    table.$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });

        });  
  </script>
</body>
</html>