<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="readonly" required="true" rtexprvalue="true" %>

<re:mark>Display all streamFiles table</re:mark>
<re:mark>
	http://stackoverflow.com/questions/16750540/jstl-bug-in-function-endswith
	The ${fn:endsWith(item,'.stream')} does not work when item="mystream.stream.stream"
	Update all endsWith with substring
	${fn:substring(item, fn:length(item)-7, fn:length(item)) == '.stream'}
</re:mark>

<c:set var="obj" >
	streamFiles
</c:set>

<c:if test="${fn:length(requestScope.formData[obj])>0}">
	<table class="table table-striped">
		<tr>
			<th width="70%"><wmsform:getlocalestring page="${page}" obj="${obj}.name"/></th>
			<th width="30%"><wmsform:getlocalestring page="${page}" obj="${obj}.action"/></th>
		</tr>
		<c:forEach items="${requestScope.formData[obj]}" var="item">
			<c:set var="item" value="${wmsutil:escapeHtml(item)}"/>
			<c:set var="itemShort" value="${wmsutil:escapeHtml(item)}"/>
			<c:if test="${fn:substring(item, fn:length(item)-7, fn:length(item)) == '.stream'}">
				<c:set var="itemShort" value="${fn:substring(item,0,fn:length(item)-7)}"/>
			</c:if>
			<c:if test="${fn:substring(item, fn:length(item)-4, fn:length(item)) == '.sdp'}">
				<c:set var="itemShort" value="${fn:substring(item,0,fn:length(item)-4)}"/>
			</c:if>
			<tr>
				<c:choose>
					<c:when test="${readonly}">
						<td class="breakall">${item}</td>
						<td></td>
					</c:when>
					<c:otherwise>
						<td class="breakall">
							<c:choose>
								<c:when test="${fn:substring(item, fn:length(item)-7, fn:length(item)) == '.stream'}">
									<a onclick="showStreamFile('${itemShort}')" title="View">${item}</a>
								</c:when>
								<c:otherwise>
									${item}
								</c:otherwise>
							</c:choose>
						</td>
						<td class="action-icons">
							<sec:authorize access="hasAnyRole('admin')">		
								<a onclick='connectStreamFileShow("${wmsutil:escapeHtml(appName)}", "${item}")'><i class='fa fa-sign-in fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Connect to this stream'></i></a>&nbsp;&nbsp;
								<a onclick='addStreamToStartupStreamsShow("${wmsutil:escapeHtml(appName)}","${item}")'><i class='fa fa-plus fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Add to Startup Streams'></i></a>&nbsp;&nbsp;
								<c:if test="${fn:substring(item, fn:length(item)-7, fn:length(item)) == '.stream'}">
									<a onclick='showEditStreamFile("${itemShort}")' ><i class='fa fa-pencil fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Edit this stream file'></i></a>
									<a onclick='removeStreamFile("${item}")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='right' data-toggle='tooltip' data-delay='250' data-original-title='Delete this stream file'></i></a>
								</c:if>
							</sec:authorize>
						</td>
					</c:otherwise>
				</c:choose>
			</tr>
		</c:forEach>
	</table>
</c:if>

<wmsdialog:deletestreamfile page="${page}"/>
<wmsdialog:connectstreamfile page="${page}"/>
<script>

var deleteStreamFileName="";

function removeStreamFile(name)
{
	deleteStreamFileName=name;
	deleteStreamFileShow();
}

function showStreamFile(name)
{
	name=encodeURIComponent(name);
	if("${appType}" == "")
	{
		loadAjaxMainContent("server/vhost/streamfile/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&streamFile="+name); 	
	}
	else 
	{
		loadAjaxMainContent("applications/${appType}/streamfile/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&streamFile="+name); 			
	}
}

function showEditStreamFile(name)
{
	lastTab='Basic';
	name=encodeURIComponent(name);
	if("${appType}" == "")
	{
		loadAjaxMainContent("server/vhost/streamfile/edit.htm", "vhost=${wmsutil:urlEncode(vhost)}&streamFile="+name+"&action=quickEdit"); 	
	}
	else 
	{
		loadAjaxMainContent("applications/${appType}/streamfile/edit.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&streamFile="+name+"&action=quickEdit");
	}
}
var tblDataStreamFiles = new Array();

initTableDataStreamFiles();

function initTableDataStreamFiles()
{
	<c:set var="count" value="0"/>
	<c:forEach items="${requestScope.formData[obj]}" var="item">
		var newItem = new Object();
		newItem.name = "${item}";
		tblDataStreamFiles.push(newItem);
		<c:set var="count" value="${count + 1}"/>
	</c:forEach>
}
</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>