<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="false" rtexprvalue="true" %>
<%@ attribute name="appType" required="true" rtexprvalue="true" %>
<%@ attribute name="appSection" required="true" rtexprvalue="true" %>
<%@ attribute name="showTitle" required="false" rtexprvalue="true" %>
<%@ attribute name="showEdit" required="false" rtexprvalue="true" %>
<%@ attribute name="useFormDataAdv" required="false" rtexprvalue="true" %>
<%@ attribute name="idPostfix" required="false" rtexprvalue="true" %>

<re:mark>Display all advanced tables</re:mark>
<c:if test="${ empty obj}">
	<c:set var="obj" value="advancedTables"/>
</c:if>
<c:if test="${ empty showTitle}">
	<c:set var="showTitle" value="true"/>
</c:if>
<c:if test="${ empty showEdit}">
	<c:set var="showEdit" value="true"/>
</c:if>
<c:if test="${ empty useFormDataAdv}">
	<c:set var="useFormDataAdv" value="true"/>
</c:if>


<c:set var="a1" value="${fn:split(obj, '.')}" />
<c:choose>
	<c:when test='${fn:length(a1)==1}' >
		<c:set var="objs" value="${requestScope.formDataAdv[obj]}"/>
	</c:when>
	<c:when test='${fn:length(a1)==2}' >
		<c:set var="obj0">${a1[0]}</c:set>
		<c:set var="obj1">${a1[1]}</c:set>
		<c:set var="objs" value="${requestScope.formDataAdv[obj0][obj1]}"/>
	</c:when>
	<c:when test='${fn:length(a1)==3}' >
		<c:set var="obj0">${a1[0]}</c:set>
		<c:set var="obj1">${a1[1]}</c:set>
		<c:set var="obj2">${a1[2]}</c:set>
		<c:choose>
			<c:when test="${useFormDataAdv}">	
				<c:set var="objs" value="${requestScope.formDataAdv[obj0][obj1][obj2]}"/>
			</c:when>
			<c:otherwise>
				<c:set var="objs" value="${requestScope.formData[obj0][obj1][obj2]}"/>
			</c:otherwise>
		</c:choose>
	</c:when>
</c:choose>
<c:forEach items="${objs}" var="entry" varStatus="loopStatus">
	<div class="row advanced-table-title">
		<c:if test="${showTitle || showEdit}">
			<div class="col-md-10">
				<c:if test="${showTitle}">
					<h4 id="${entry.key}Anchor"><wmsform:getlocalestring page="${page}" obj="advancedTables.${entry.key}"/>
					<small><wmsform:getlocalestring page="${page}" obj="advancedTables.${entry.key}Help"/></small></h4>
				</c:if>
				<c:if test="${showEdit }">
					<c:choose>
						<c:when test="${appType=='vhost' }">
							<wmsform:buttonedit onClick="javascript:loadAjaxMainContent('server/vhostsetup/edit_adv.htm?','vhost=${wmsutil:urlEncode(vhost)}&advSection=${entry.key}')"/>
						</c:when>
						<c:when test="${appType=='server' }">
							<wmsform:buttonedit onClick="javascript:loadAjaxMainContent('server/serversetup/edit_adv.htm?','vhost=${wmsutil:urlEncode(vhost)}&advSection=${entry.key}')"/>
						</c:when>
						<c:when test="${appType=='mediacache' }">
							<wmsform:buttonedit onClick="javascript:loadAjaxMainContent('server/mediacache/edit_adv.htm?','vhost=${wmsutil:urlEncode(vhost)}&advSection=${entry.key}')"/>
						</c:when>
						<c:when test="${appType=='mediacachestore' }">
							<wmsform:buttonedit onClick="javascript:loadAjaxMainContent('server/mediacachestore/edit_adv.htm?','storeName=${storeName}&advSection=${entry.key}')"/>
						</c:when>
						<c:when test="${appType=='mediacachesource' }">
							<wmsform:buttonedit onClick="javascript:loadAjaxMainContent('server/mediacachesource/edit_adv.htm?','sourceName=${sourceName}&advSection=${entry.key}')"/>
						</c:when>
						<c:when test="${appSection=='smilfilestream' }">
							<wmsform:buttonedit onClick="javascript:loadAjaxMainContent('server/vhost/smilfile/stream/edit_adv.htm?','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&appType=${appType}&smilFile=${wmsutil:urlEncode(smilName)}&idx=${idx}')"/>
						</c:when>
						<c:when test="${appSection=='streamfile' }">
							<wmsform:buttonedit onClick="javascript:loadAjaxMainContent('server/vhost/streamfile/edit_adv.htm?','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&appType=${appType}&streamName=${wmsutil:urlEncode(streamName)}&advSection=${entry.key}')"/>
						</c:when>
						<c:otherwise>
							<wmsform:buttonedit onClick="javascript:loadAjaxMainContent('applications/${appType}/${appSection}/edit_adv.htm?','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&advSection=${entry.key}')"/>
						</c:otherwise>
					</c:choose>	
				</c:if>
			</div>
		</c:if>
		<c:if test="${loopStatus.index>0}">
			<div class="col-md-2">
				<a href="#apptop" class="return-to-top pull-right">Return to top <i class="fa fa-arrow-up"></i></a>
			</div>
		</c:if>
	</div>
	<table class="table table-striped">
		<tr>
			<th style="width:50px"><wmsform:getlocalestring page="${page}" obj="${obj}.enabled"/></th>
			<th><wmsform:getlocalestring page="${page}" obj="${obj}.name"/></th>
			<th><wmsform:getlocalestring page="${page}" obj="${obj}.value"/></th>
			<th style="width:15px">&nbsp;</th>
		</tr>
		<c:if test="${! empty obj}">
			<c:forEach var="item" items="${entry.value}">
			<c:set var="itemName">
				<wmsform:getlocalestring page="${page}.advancedTables.${entry.key}" obj="${item['name']}"/>
			</c:set>
			<tr>
				<c:choose>
					<c:when test="${item['enabled']=='true'}">
						<td><center><i class="fa fa-check-circle fa-fw text-success"></i></center></td>
						<td class="breakall">
							<c:if test="${item['documented']=='false'}">
								${item['section']}/
							</c:if>
							${itemName}
						</td>
						<td class="breakall">
							${item['value']}
							<div class="default-value-view">
								default: 
								<c:choose>
									<c:when test="${empty item['defaultValue']}">
										-empty-
									</c:when>
									<c:otherwise>
										${item['defaultValue']}
									</c:otherwise>
								</c:choose>	
							</div>
						</td>
					</c:when>
					<c:otherwise>
						<td><center><i class="fa fa-times-circle fa-fw text-danger"></i></center></td>
						<td class="breakall">
							${itemName}
						</td>
						<td class="breakall">
							<!--<c:if test="${! empty item['defaultValue']}">
								<div class="default-value-view">default: ${item['defaultValue']}</div>
							</c:if>-->
						</td>
					</c:otherwise>
				</c:choose>
				<c:choose>
					<c:when test="${item['documented']=='true'}">
						<td>
						<c:set var="advDesc">
							<wmsform:getlocalestring page="${page}.advancedTables.${entry.key}" obj="${item['name']}.description" defaultStr="TBD"/>
						</c:set>
						<i id="${item['name']}${idPostfix}" class="fa fa-question-circle fa-2x" rel="popover" data-html="true" data-content="${advDesc}" data-trigger="click" data-animation="true" data-placement="left" data-delay="150" data-original-title="${itemName}"></i>
						<script>
						WOWZA.Util.Popover("#${item['name']}${idPostfix}"); 
						</script>
					</c:when>
					<c:otherwise>
						<td></td>
					</c:otherwise>
				</c:choose>
			</tr>
			</c:forEach>
		</c:if>
	</table>
</c:forEach>

