<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="appType" required="true" rtexprvalue="true" %>
<%@ attribute name="appSection" required="true" rtexprvalue="true" %>
<%@ attribute name="showSectionName" required="false" rtexprvalue="true" %>
<%@ attribute name="tabView" required="false" rtexprvalue="true" %>
<%@ attribute name="showPath" required="false" rtexprvalue="true" %>

<c:set var="obj" >
	customList
</c:set>
<c:if test="${ empty showSectionName}">
	<c:set var="showSectionName" value="false"/>
</c:if>
<c:if test="${ empty tabView}">
	<c:set var="tabView" value="false"/>
</c:if>
<c:if test="${ empty showPath}">
	<c:set var="showPath" value="true"/>
</c:if>

<c:if test="${requestScope.formDataAdv['advSection'] == 'Custom'}">
	
	<c:choose>
		<c:when test="${appType=='vhost' }">
			<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/vhostsetup/edit_adv.htm','','mainContent','defaultFormAdv')"/>
			<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/vhostsetup/view.htm','vhost=${wmsutil:urlEncode(vhost)}')" />
		</c:when>
		<c:when test="${appType=='server' }">
			<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/serversetup/edit_adv.htm','','mainContent','defaultFormAdv')"/>
			<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/serversetup/view.htm','vhost=${wmsutil:urlEncode(vhost)}')" />
		</c:when>
		<c:when test="${appType=='mediacache' }">
			<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/mediacache/edit_adv.htm','','mainContent','defaultFormAdv')"/>
			<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/mediacache/view.htm','')" />
		</c:when>
		<c:when test="${appType=='mediacachestore' }">
			<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/mediacachestore/edit_adv.htm','','mainContent','defaultFormAdv')"/>
			<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/mediacachestore/view.htm','storeName=${storeName}')" />
		</c:when>
		<c:when test="${appType=='mediacachesource' }">
			<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/mediacachesource/edit_adv.htm','','mainContent','defaultFormAdv')"/>
			<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/mediacachesource/view.htm','sourceName=${sourceName}')" />
		</c:when>
		<c:when test="${appType=='streamtarget' }">
			<wmsform:buttonsave onClick="javascript:saveStreamTarget()" />
			<wmsform:buttoncancel onClick="javascript:showStreamTarget()" />
		</c:when>
		<c:otherwise>
			<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('applications/${appType}/${appSection}/edit_adv.htm','','mainContent','defaultFormAdv')"/>
			<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('applications/${appType}/${appSection}/view.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}')" />
		</c:otherwise>
	</c:choose>	
	<div class="advanced-table-title">
		<c:if test="${tabView=='false'}">
			<h4 id="customTable"><wmsform:getlocalestring page="${page}" obj="custom"/>
			<small><wmsform:getlocalestring page="${page}" obj="customHelp"/></small></h4>
		</c:if>
	</div>
	<div class="advanced-table-title">
		<wmsform:button page="${page}" obj="addProperty" onClick="javascript:addAdvancedShow()" icon="fa fa-plus" cssClass="btn btn-default"/>
	</div>
	<table class="table table-striped" id="customPropertyTable">
	</table>
	<c:choose>
		<c:when test="${appType=='vhost' }">
			<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/vhostsetup/edit_adv.htm','','mainContent','defaultFormAdv')"/>
			<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/vhostsetup/view.htm','vhost=${wmsutil:urlEncode(vhost)}')" />
		</c:when>
		<c:when test="${appType=='server' }">			
			<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/serversetup/edit_adv.htm','','mainContent','defaultFormAdv')"/>
			<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/serversetup/view.htm','vhost=${wmsutil:urlEncode(vhost)}')" />
		</c:when>
		<c:when test="${appType=='mediacache' }">
			<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/mediacache/edit_adv.htm','','mainContent','defaultFormAdv')"/>
			<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/mediacache/view.htm','')" />
		</c:when>
		<c:when test="${appType=='mediacachestore' }">
			<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/mediacachestore/edit_adv.htm','','mainContent','defaultFormAdv')"/>
			<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/mediacachestore/view.htm','storeName=${storeName}')" />
		</c:when>
		<c:when test="${appType=='mediacachesource' }">
			<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('server/mediacachesource/edit_adv.htm','','mainContent','defaultFormAdv')"/>
			<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('server/mediacachesource/view.htm','sourceName=${sourceName}')" />
		</c:when>
		<c:when test="${appType=='streamtarget' }">
			<wmsform:buttonsave onClick="javascript:saveStreamTarget()" />
			<wmsform:buttoncancel onClick="javascript:showStreamTarget()" />
		</c:when>
		<c:otherwise>
			<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('applications/${appType}/${appSection}/edit_adv.htm','','mainContent','defaultFormAdv')"/>
			<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('applications/${appType}/${appSection}/view.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}')" />
		</c:otherwise>
	</c:choose>
	
</c:if>
<wmsdialog:addadvanced page="appConfig" showPath="${showPath}"/>

<c:set var="pathLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.path"/>
</c:set>
<c:set var="nameLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.name"/>
</c:set>
<c:set var="typeLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.type"/>
</c:set>
<c:set var="valueLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.value"/>
</c:set>
<c:set var="actionLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.action"/>
</c:set>

<script>
var tblDataProperties = new Array();
var tblIdxProperties=0;

initTableDataProperties();
updateTableProperties();

function initTableDataProperties()
{
	<c:forEach items="${requestScope.formDataAdv[obj]}" var="item">
		if("${item['enabled']}") 
		{
			var newItem = new Object();
			newItem.orgIdx = tblIdxProperties++;
			newItem.added=false;
			newItem.removed="${item['removed']}"==="true";
			newItem.enabled="${item['enabled']}"==="true";
			newItem.name="${item['name']}";
			newItem.value="${item['value']}";
			newItem.type="${item['type']}";
			newItem.section="${item['section']}";
			newItem.sectionName="${item['sectionName']}";
			newItem.documented="${item['documented']}"==="true";
			newItem.uiBooleanValue="${item['uiBooleanValue']}"==="true";
			tblDataProperties.push(newItem);
		}
		
	</c:forEach>
}

function checkIfPropertyExists(name, path)
{
	retVal = false;
	for (tblItem in tblDataProperties) {
		if (tblDataProperties[tblItem].name == name) {
			if (path == "" || tblDataProperties[tblItem].section == path) {
				retVal = true;
				break;
			}
		}
	}
	return retVal
}

function updateTableProperties()
{
	var tbl = document.getElementById('customPropertyTable');
	if(tbl==null)
		return;
	while (tbl.firstChild) {
		tbl.removeChild(tbl.firstChild);
	}
	var tblString="";
	tblString+="<tr>";
	<c:if test="${showPath=='true'}">
		tblString+="<th>${pathLabel}</th>";
	</c:if>
	tblString+="<th>${nameLabel}</th>";
	tblString+="<th>${typeLabel}</th>";
	tblString+="<th>${valueLabel}</th>";
	tblString+="<th>${actionLabel}</th>";

	tblString+="</tr>";
	for (tblItem in tblDataProperties) {
		if(tblDataProperties[tblItem].removed)
		{
			tblString+="<tr style='display:none'><td>";
		}
		else {
			tblString+="<tr>";
			<c:if test="${showPath=='true'}">
				tblString+="<td>";
				<c:choose>
					<c:when test="${showSectionName}">
						tblString+=tblDataProperties[tblItem].sectionName;
					</c:when>
					<c:otherwise>
						tblString+=tblDataProperties[tblItem].section;
					</c:otherwise>
				</c:choose>
				tblString+="</td>";
			</c:if>
			tblString+="<td class=\"breakall\">";
			tblString+=tblDataProperties[tblItem].name;
			tblString+="</td>";
			tblString+="<td>";
			tblString+=tblDataProperties[tblItem].type;
			tblString+="</td>";
			tblString+="<td>";
		}
		
		tblString+="<input id='${obj}"+tblItem+".documented' name='${obj}["+tblItem+"].documented' type='hidden' value='"+tblDataProperties[tblItem].documented+"'>";
		tblString+="<input id='${obj}"+tblItem+".enabled' name='${obj}["+tblItem+"].enabled' type='hidden' value='"+tblDataProperties[tblItem].enabled+"'>";
		tblString+="<input id='${obj}"+tblItem+".type' name='${obj}["+tblItem+"].type' type='hidden' value='"+tblDataProperties[tblItem].type+"'>";
		tblString+="<input id='${obj}"+tblItem+".sectionName' name='${obj}["+tblItem+"].sectionName' type='hidden'";
		tblString+="value='";
		tblString+=tblDataProperties[tblItem].sectionName.replace(/'/g, "&#39;");
		tblString+="'>"
		tblString+="<input id='${obj}"+tblItem+".section' name='${obj}["+tblItem+"].section' type='hidden' value='"+tblDataProperties[tblItem].section+"'>";
		tblString+="<input id='${obj}"+tblItem+".name' name='${obj}["+tblItem+"].name' type='hidden' value='"+tblDataProperties[tblItem].name+"'>";
		tblString+="<input id='${obj}"+tblItem+".removed' name='${obj}["+tblItem+"].removed' type='hidden' value='"+tblDataProperties[tblItem].removed+"'>";			

		if(tblDataProperties[tblItem].removed)
		{
			tblString+="</td></tr>";
			tblString+="<tr style='display:none'></tr>";
		}
		else 
		{	
			if(tblDataProperties[tblItem].type=="Integer")
			{
				tblString+="<input id='${obj}"+tblItem+".value' name='${obj}["+tblItem+"].value' title='' type='text' value='"+tblDataProperties[tblItem].value+"' class='form-control'>";		
			}
			else if(tblDataProperties[tblItem].type=="Boolean")
			{
				tblString+="<label class='radio-inline'>";
				tblString+="<input id='${obj}"+tblItem+".uiBooleanValue1' name='${obj}["+tblItem+"].uiBooleanValue' type='radio' value='true'";
				if(tblDataProperties[tblItem].uiBooleanValue)
				{
					tblString+=" checked='checked'";
				}
				tblString+=">True";
				tblString+="</label>";
				tblString+="<label class='radio-inline'>";
				tblString+="<input id='${obj}"+tblItem+".uiBooleanValue2' name='${obj}["+tblItem+"].uiBooleanValue' type='radio' value='false'";
				if(!tblDataProperties[tblItem].uiBooleanValue)
				{
					tblString+=" checked='checked'";
				}
				tblString+=">False";
				tblString+="</label>";
			}
			else {
				tblString+="<input id='${obj}"+tblItem+".value' name='${obj}["+tblItem+"].value' title='' type='text' value='"+tblDataProperties[tblItem].value+"' class='form-control'>";						
			}
			tblString+="</td>";
			tblString+="<td>";
			tblString+="<a href='javascript:removeProperty("+tblItem+")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Delete this custom property'></i></a>";;
			tblString+="</td>";
			tblString+="</tr>";
		}
	}
	$('#customPropertyTable').html(tblString);
}

function removeProperty(orgIdx)
{
	tblDataProperties[orgIdx].removed=true;
	tblDataProperties[orgIdx].enabled=false;
	if(tblDataProperties[orgIdx].added) //value did not exsits before and was just added
	{
		tblDataProperties.splice(orgIdx,1); //remove it
	}
	updateTableProperties();
}

</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>


