<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="title" required="false" rtexprvalue="true" %>
<%@ attribute name="showTitle" required="false" rtexprvalue="true" %>
<%@ attribute name="showEmptyString" required="false" rtexprvalue="true" %>
<%@ attribute name="bulletList" required="false" rtexprvalue="true" %>
<%@ attribute name="commaList" required="false" rtexprvalue="true" %>
<%@ attribute name="bind" required="false" rtexprvalue="true" %>
<%@ attribute name="cssClassTitle" required="false" rtexprvalue="true" %>

<re:mark>Display a list of values</re:mark>

<c:set var="ctrlGroupClass">
	<wmsform:getctrlgroupclass obj="${obj}"/>
</c:set>
<c:if test="${ empty cssClassTitle}">
	<c:set var="cssClassTitle" value="control-label"/>
</c:if>
<c:if test="${ empty bulletList}">
	<c:set var="bulletList" value="false"/>
</c:if>
<c:if test="${ empty commaList}">
	<c:set var="commaList" value="false"/>
</c:if>

<div class="${ctrlGroupClass}" id="${obj}CtrlGroup">
	<c:if test="${ empty showTitle}">
		<label class="${cssClassTitle}" for="${obj}">
		<wmsform:getlocalestring page="${page}" obj="${obj}"/>	
		</label>
	</c:if>

	<ul class="list-unstyled" id="${obj}Value"> 
		<c:if test="${empty bind or bind=='true'}">
			<c:set var="objlist"> 
				<wmsform:objvaluearray page="${page}" obj="${obj}"/>
			</c:set>
		</c:if>

		<c:choose>
			<c:when test="${ empty objlist && !empty showEmptyString }">
				${showEmptyString}
			</c:when>
			<c:otherwise>
				<ul class="list-unstyled">
				<c:forEach items="${requestScope.formData[obj]}" var="item" varStatus="theCount">
					<c:choose>
						<c:when test="${bulletList}">
							<li>${item}</li>
						</c:when>
						<c:when test="${commaList}">
							<c:choose>
								<c:when test="${theCount.last}">
									${item}<br>
								</c:when>
								<c:otherwise>
									${item},
								</c:otherwise>
							</c:choose>
						</c:when>
						<c:otherwise>
							${item}<br>
						</c:otherwise>
					</c:choose>
				</c:forEach>
				</ul>
			</c:otherwise>
		</c:choose>
		<wmsform:warnings path="view.${obj}"/>
	</ul>
</div>