<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>

<div id="javaUpdateAvailable" class="alert alert-info well-small" style="display:none" >
<h4><span id="lastestJavaVersion"></span> Java Update Available</h4>
	<p>
		You are using <strong>version <span id="currentJavaVersion"></span></strong>. A new update for Java is available.</p>
	<p>
		<a id="redirectJavaURL" class="btn btn-info " href="#" target="_blank">More Info and Download</a>
	</p>
</div>

<script>
$(document).ready(function() {
	$("#currentJavaVersion").text("${requestScope.formData[obj]}");
	getRSSJavaVersion();
});

function getRSSJavaVersion()
{
//RSS feed must have this in the header:
rssurl = "https://www.wowza.com/rss/wowzastreamingenginejava-production.xml";
//rssurl = "rss_test.xml";
$.ajax({
		url : rssurl,
		data : null,
		cache : false,
		success : function(data) {
			var $xml = $(data);
			var $this = $xml.find("item"), item = {
				title : escape($this.find("title").text()),
				link : $this.find("link").text(),
				description : $this.find("description").text(),
				pubDate : $this.find("pubDate").text(),
				author : $this.find("author").text()
			}
			var splits = item.title.split("-");
			if (splits.length > 1) {
				updateJavaAvail(splits[1]);
			}
		},
		error : function(jqXHR, textStatus, thrownError) {
		}
	});
	return;
}

function updateJavaAvail(latestRSSJavaVersion) {
	currentJavaVersion = getCurrentJavaVersion();
	$('#redirectJavaURL').attr("href","http://www.wowza.com/docredirect.php?doc=javaUpdatesProductionBuild&version="+ latestRSSJavaVersion);
	//check numbers are greater
	var isUpdateAvail = false;
	var cvSplits = currentJavaVersion.split(".");
	var lvSplits = latestRSSJavaVersion.split(".");
	if (cvSplits.length > 2 && lvSplits.length > 2) {
		var cvVersion = parseInt(cvSplits[0]) * 1000000;
		cvVersion += parseInt(cvSplits[1]) * 1000;
		cvVersion += parseInt(cvSplits[2].split("_")[0]);
		var lvVersion = parseInt(lvSplits[0]) * 1000000;
		lvVersion += parseInt(lvSplits[1]) * 1000;
		lvVersion += parseInt(lvSplits[2].split("_")[0]);
		if (lvVersion > cvVersion) {
			isUpdateAvail = true;
		}
	}

	if (isUpdateAvail) {
		$('#lastestJavaVersion').text(latestRSSJavaVersion);
		$('#javaUpdateAvailable').show();
	}
}

function getCurrentJavaVersion()
{
	//only show the first 3 numbers
	var curVer = "${requestScope.formData[obj]}";
	var splits = curVer.split(".");
	if(splits.length >2)
	{
		curVer = splits[0]+"."+splits[1]+"."+splits[2];
	}
	return curVer;
}

</script>
