<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="appName" required="false" rtexprvalue="true" %>

<re:mark>Update the page title</re:mark>
<c:set var="titleSuffix">
	<wmsform:getlocalestring page="" obj="titleSuffix"/>
</c:set>
<c:set var="pageTitle">
	<wmsform:getlocalestring page="${page}" obj="pageTitle" defaultStr=" "/>
</c:set>
<c:choose>
	<c:when test='${empty appName}'>
		<c:choose>
			<c:when test='${fn:length(fn:trim(pageTitle))>0}'>
				<script>
					document.title="${pageTitle} | ${titleSuffix}";
				</script>
			</c:when>
			<c:otherwise>
				<script>
					document.title="${titleSuffix}";
				</script>
			</c:otherwise>
		</c:choose>
	</c:when>
	<c:otherwise>
		<c:choose>
			<c:when test='${fn:length(fn:trim(pageTitle))>0}'>
				<script>
					document.title="${appName}: ${pageTitle} | ${titleSuffix}";
				</script>
			</c:when>
			<c:otherwise>
				<script>
					document.title="${appName} | ${titleSuffix}";
				</script>
			</c:otherwise>
		</c:choose>
	</c:otherwise>
</c:choose>

