<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="cssClass" required="false" rtexprvalue="true" %>
<%@ attribute name="cssSize" required="false" rtexprvalue="true" %>
<%@ attribute name="title" required="false" rtexprvalue="true" %>
<%@ attribute name="required" required="false" rtexprvalue="true" %>
<%@ attribute name="tooltip" required="false" rtexprvalue="true" %>
<%@ attribute name="showTitle" required="false" rtexprvalue="true" %>

<re:mark>Display a listbox of current options allowing the user to select multiple items </re:mark>
<c:if test="${ empty cssSize}">
	<c:set var="cssSize" value="col-md-12"/>
</c:if>

<re:mark>Get the tooltip based on objName and objVar</re:mark>
<c:set var="tooltip_msg">
	<wmsform:getlocaletooltip page="${page}" obj="${obj}" tooltip="${tooltip}"/>
</c:set>

<c:set var="objOptions">
	${obj}Options
</c:set>

<c:set var="ctrlGroupClass">
	<wmsform:getctrlgroupclass obj="${obj}"/>
</c:set>

<div class="${ctrlGroupClass}" id="${obj}CtrlGroup">
	<re:mark>Title</re:mark>
	<c:if test="${ empty showTitle}">
		<label class="${cssClassTitle}" for="${obj}">
		<wmsform:getlocalestring page="${page}" obj="${obj}"/>	
		<c:if test="${! empty required}">
			*
		</c:if>
		</label>
	</c:if>
	<div class="row">
		<div class="${cssSize}">
			<form:select path="${obj}" cssClass="form-control">
				<form:options items="${requestScope.formData[objOptions]}" />
			</form:select>
		</div>
	</div>

	<re:mark>Errors and warnings</re:mark>
	<wmsform:errors path="${obj}"/>
	<wmsform:warnings path="${obj}"/>

	<c:set var="objhelp">
		<wmsform:getlocalestring page="${page}" obj="${obj}.help"/>
	</c:set>
	<c:choose>
		<c:when test='${ not (fn:endsWith(objhelp,"help"))}'>
			<span class="help-block">${fn:trim(objhelp)}</span>
		</c:when>
	</c:choose>
</div>