<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="overlayModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="overlayModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<fieldset>
				<div class="modal-header">
					<button type="button" class="close" onClick="javascript:overlayClose()">x</button>
					<h4 id="overlayModalLabel" class="modal-title"><wmsform:getlocalestring page="${page}" obj="header"/></h4>
				</div>
				<div class="modal-body">
					<span class="help-block" id="decodeInfo"><wmsform:getlocalestring page="${page}" obj="decodeInfo"/></span>
					<span class="help-block" id="encodeInfo"><wmsform:getlocalestring page="${page}" obj="encodeInfo"/></span>
			  
					<div class="row">
						<div class="col-md-12">
							<ul class="nav nav-tabs" >
								<li id="Image" >
									<a href="javascript:showImageTab()">Image</a>
								</li>
								<li id="ImagePlacement" >
									<a href="javascript:showImagePlacementTab()">Image Placement</a>
								</li>
							</ul>
						</div>
					</div>    
					<div class="row" id="tabContent">
						<div class="col-md-12">
							<div id="ViewMode">
								<div id="TabImage" style="display:none">
									<wmsform:viewproperty page="${page}" obj="overlayName" cssClassTitle="control-label" bind="false" />
									<wmsform:viewproperty page="${page}" obj="imagePath" cssClassTitle="control-label" bind="false"/>
									<h5 class="control-label"><wmsform:getlocalestring page="${page}" obj="imageOptions"/></h5>
									<wmsform:viewpropertycheckbox page="${page}" obj="checkForUpdates"  bind="false"/>
									<wmsform:viewpropertyint page="${page}" obj="overlayWidth" cssClassTitle="control-label" bind="false"/>
									<wmsform:viewpropertyint page="${page}" obj="overlayHeight" cssClassTitle="control-label" bind="false"/>
									<wmsform:viewpropertyint page="${page}" obj="opacity" cssClassTitle="control-label" bind="false"/>
		
								</div>
								<div  id="TabImagePlacement" style="display:none">
		
									<wmsform:viewproperty page="${page}" obj="align" cssClassTitle="control-label" bind="false"/>
									<wmsform:viewpropertyint page="${page}" obj="xLocation" cssClassTitle="control-label" bind="false"/>
									<wmsform:viewpropertyint page="${page}" obj="yLocation" cssClassTitle="control-label" bind="false"/>
		
								</div>
							</div>
						</div>
					</div>	  
				</div>
				<div class="modal-footer">
					<div class="modal-error"><span id="hostPortDialog.error" class="alert alert-danger" style="display:none"></span></div>
					<wmsform:buttoncancel  onClick="overlayClose()"/>
				</div>
			</fieldset>
		</div>
	</div>
</div>

<c:set var="sameWidth">
	<wmsform:getlocalestring page="${page}" obj="sameWidth"/>
</c:set>
<c:set var="sameHeight">
	<wmsform:getlocalestring page="${page}" obj="sameHeight"/>
</c:set>

<script>

$(document).ready(function() {
	showImageTab();
});

function showImageTab() {
	$('#TabImage').show();
	$('#TabImagePlacement').hide();
	$('#Image').addClass('active');
	$('#ImagePlacement').removeClass();
}

function showImagePlacementTab() {
	$('#TabImage').hide();
	$('#TabImagePlacement').show();
	$('#Image').removeClass();
	$('#ImagePlacement').addClass('active');	
}


function overlayShow(orgIdx,decodeOverlay) {
	$('#overlayEditModal').remove();	

	if(decodeOverlay)
	{
		$('#decodeInfo').show();		
		$('#encodeInfo').hide();
	}
	else 
	{
		$('#encodeInfo').show();
		$('#decodeInfo').hide();		
	}
	//test to see if we don't want these.  If so, remove the div/span tags
	$('#decodeInfo').hide();		
	$('#encodeInfo').hide();
	
	$('#overlayNameValue').text(tblDataOverlay[orgIdx].overlayName);
	$('#imagePathValue').text(tblDataOverlay[orgIdx].imagePath);
	$('#checkForUpdatesValue').prop('checked', tblDataOverlay[orgIdx].checkForUpdates);
	$('#opacityValue').text(tblDataOverlay[orgIdx].opacity);
	if(tblDataOverlay[orgIdx].width == "$"+"{ImageWidth}")
	{
		$('#overlayWidthValue').text("${sameWidth}");
		$('#overlayWidthUnits').hide();
	}
	else
	{
		$('#overlayWidthValue').text(tblDataOverlay[orgIdx].width);
		$('#overlayWidthUnits').show();
	}
	if(tblDataOverlay[orgIdx].height == "$"+"{ImageHeight}")
	{
		$('#overlayHeightValue').text("${sameHeight}");
		$('#overlayHeightUnits').hide();
	}
	else
	{
		$('#overlayHeightValue').text(tblDataOverlay[orgIdx].height);
		$('#overlayHeightUnits').show();
	}
	$('#alignValue').text(tblDataOverlay[orgIdx].align);
	$('#xLocationValue').text(tblDataOverlay[orgIdx].xLocation);
	$('#yLocationValue').text(tblDataOverlay[orgIdx].yLocation);
	$('#overlayModal').on("shown.bs.modal", function() {
	});
	$('#overlayModal').modal('show');	
}


function overlayClose() {
	$('#overlayModal').modal('hide');
}
</script>