<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="resetStreamModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="resetStreamModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:resetStreamClose()">x</button>
					<h4 id="resetStreamModalLabel" class="modal-title"><wmsform:getlocalestring page="resetStreamDialog" obj="title"/></h4>
				  </div>
				  <div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="resetStreamDialog" obj="message"/> <b><span id="resetStreamName"></span></b>?</p>
				  </div>
				  <div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:resetStreamClose()"/>
					<wmsform:buttonok  onClick="javascript:doResetStream()"/>
				  </div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>
var currentInstance;
var currentStream;
var currentApp;

function resetStreamShow(app, appInstance, streamName) {
	$('#resetStreamName').text(streamName);
	currentApp=app;
	currentInstance=appInstance;
	currentStream=streamName;
	$('#resetStreamModal').on("shown.bs.modal", function() {});
	$('#resetStreamModal').modal('show');	
}

function resetStreamClose() {
	$('#resetStreamModal').modal('hide');
}

function doResetStream() {
	$('#resetStreamModal').on('hidden.bs.modal', function() {
		postAJAXForm('streams/${page}/resetStream.htm','vhost=${wmsutil:urlEncode(vhost)}&appName='+encodeURIComponent(currentApp)+'&appType=${appType}&appSection=${appSection}&instanceName='+encodeURIComponent(currentInstance)+'&streamName='+encodeURIComponent(currentStream)+'&returnPage=${page}');
	});
	resetStreamClose();
}

</script>