<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="licenseInfoModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="licenseInfoModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="licenseInfoForm" class="form-modal"> 
				<fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:licenseInfoClose()">x</button>
					<h4 id="licenseInfoModalLabel" class="modal-title">Notice</h4>
				  </div>
				  <div class="modal-body">
						<div id="licenseText"></div>
				  </div>
				  <div class="modal-footer">
					<wmsform:button cssClass="btn btn-primary" page='about' obj='close'  onClick="javascript:licenseInfoClose()"/>
				  </div>
				</fieldset>
			</form>
		</div>
	</div>
</div>

<script>
function licenseInfoShow() {
	//$('#licenseText').load('NOTICE.txt');
	//$("#licenseText").html( $("#licenseText").html().replace("\r","<br />") );

	$("#licenseText").load("NOTICE.txt", function(response, status, xhr) {
        $("#licenseText").html(response.replace(/\n/g, "<p>"));
	});
	$('#licenseInfoModal').on("shown.bs.modal", function() {
	});
	$('#licenseInfoModal').modal('show');	
}

function licenseInfoClose() {
	$('#licenseInfoModal').modal('hide');
}

</script>