<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="hostPortModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="hostPortModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="hostPortForm" class="form-modal"> 
				<fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:hostPortClose()">x</button>
					<h4 id="addHostPortModalLabel" class="modal-title"><wmsform:getlocalestring page="hostPortDialog" obj="newHeader"/></h4>
					<h4 id="editHostPortModalLabel" class="modal-title"><wmsform:getlocalestring page="hostPortDialog" obj="editHeader"/></h4>
				  </div>
				  <div class="modal-body">
							<wmsform:viewproperty page="hostPortDialog" obj="hostportName" bind="false" cssClassTitle="control-label-first"/>
							<wmsform:editproperty page="hostPortDialog" obj="hostportNameEdit" cssClassTitle="control-label-first" required="yes" bind="false" cssClass="form-control" cssSize="col-md-6"/>
							<wmsform:viewproperty page="hostPortDialog" obj="type" bind="false"/>
							<wmsform:editpropertydropdown page="hostPortDialog" obj="typeEdit" cssClassTitle="control-label" required="yes" bind="false" options="Admin,Streaming" cssSize="col-md-6"/>
							<wmsform:editproperty page="hostPortDialog" obj="ipAddress" cssClass="form-control" cssClassTitle="control-label" required="yes" bind="false" cssSize="col-md-6"/>
							<wmsform:editproperty page="hostPortDialog" obj="port" cssClass="form-control" cssClassTitle="control-label" required="yes" bind="false" cssSize="col-md-6"/>
							<wmsform:editpropertycheckbox page="hostPortDialog" obj="sslEnable" bind="false"/>
							<wmsform:editproperty page="hostPortDialog" obj="sslKeyStorePath" cssClass="form-control" cssClassTitle="control-label"  bind="false" />
							<wmsform:editproperty page="hostPortDialog" obj="sslKeyStorePassword" cssClass="form-control" cssClassTitle="control-label"  bind="false" cssSize="col-md-6"/>
				  </div>
				  <div class="modal-footer">
					<div class="row">
						<div class="col-md-8">
							<div id="hostPortDialogError" class="alert alert-danger" style="display:none"></div>
						</div>
						<div class="col-md-4">
							<wmsform:buttoncancel  onClick="javascript:hostPortClose()"/>
							<wmsform:buttonadd onClick="javascript:hostPortSave()" />
							<wmsform:buttonprimary page="${page}" obj="apply" onClick="javascript:hostPortSave()" icon="icon-hdd icon-white"/>
						</div>
					</div>
				  </div>
				</fieldset>
			</form>
		</div>
	</div>
</div>

<c:set var="nameEmpty">
	<wmsform:getlocalestring page="hostPortDialog" obj="name.empty"/>
</c:set>
<c:set var="nameError">
	<wmsform:getlocalestring page="common" obj="invalidFileName"/>
</c:set>
<c:set var="dupNameError">
	<wmsform:getlocalestring page="hostPortDialog" obj="name.dup"/>
</c:set>
<c:set var="ipAddressEmpty">
	<wmsform:getlocalestring page="hostPortDialog" obj="ipAddress.empty"/>
</c:set>
<c:set var="ipAddressError">
	<wmsform:getlocalestring page="common" obj="invalidIP"/>
</c:set>
<c:set var="portEmpty">
	<wmsform:getlocalestring page="hostPortDialog" obj="port.empty"/>
</c:set>
<c:set var="portError">
	<wmsform:getlocalestring page="common" obj="port.error"/>
</c:set>
<c:set var="sslKeyStorePathEmpty">
	<wmsform:getlocalestring page="hostPortDialog" obj="sslKeyStorePath.empty"/>
</c:set>
<c:set var="sslKeyStorePathError">
	<wmsform:getlocalestring page="common" obj="invalidPathName"/>
</c:set>
<c:set var="sslKeyStorePasswordEmpty">
	<wmsform:getlocalestring page="hostPortDialog" obj="sslKeyStorePassword.empty"/>
</c:set>
<script>
var editIdx=-1;
$("#sslEnable").click(function() {
	enabledChecked();
});

function hostPortShow(orgIdx) {
	editIdx=orgIdx;
	if(orgIdx<0)
	{
		$('#apply').hide();
		$('#addbtn').show();
		$('#editHostPortModalLabel').hide();
		$('#addHostPortModalLabel').show();

		$('#hostportNameCtrlGroup').hide();
		$('#hostportNameEditCtrlGroup').show();
		$('#typeCtrlGroup').hide();
		$('#typeEditCtrlGroup').show();

		$('#hostportNameEdit').val("");
		$('#typeEdit').val("Streaming");

		$('#ipAddress').val("");
		$('#port').val("");
		$("#sslEnable").prop( "checked",false);
		$('#sslKeyStorePath').val("");
		$('#sslKeyStorePassword').val("");
	}
	else 
	{
		$('#apply').show();
		$('#addbtn').hide();
		$('#editHostPortModalLabel').show();
		$('#addHostPortModalLabel').hide();

		$('#hostportNameCtrlGroup').show();
		$('#hostportNameEditCtrlGroup').hide();
		$('#typeCtrlGroup').show();
		$('#typeEditCtrlGroup').hide();

		$('#hostportNameValue').text(tblDataHostPorts[orgIdx].name);
		$('#hostportNameEdit').val(tblDataHostPorts[orgIdx].name);
		$('#typeValue').text(tblDataHostPorts[orgIdx].type);
		$('#typeEdit').val(tblDataHostPorts[orgIdx].type);
		$('#ipAddress').val(tblDataHostPorts[orgIdx].ipAddress);
		$('#port').val(tblDataHostPorts[orgIdx].port);

		if(tblDataHostPorts[orgIdx].sslEnable)
		{
			$("#sslEnable").prop('checked', true);
		}
		else 
		{
			$("#sslEnable").prop('checked', false);;
		}
		$('#sslKeyStorePath').val(tblDataHostPorts[orgIdx].sslKeyStorePath);
		$('#sslKeyStorePassword').val(tblDataHostPorts[orgIdx].sslKeyStorePassword);

	}
	$("#hostPortDialogError").html(""); 
	$("#hostPortDialogError").hide();
	$("#hostportNameEditCtrlGroup").attr('class', 'form-group');
	$("#hostportNameEditErrorMsg").html("");
	$("#ipAddressCtrlGroup").attr('class', 'form-group');
	$("#ipAddressErrorMsg").html("");
	$("#portCtrlGroup").attr('class', 'form-group');
	$("#portErrorMsg").html("");
	$("#sslKeyStorePathCtrlGroup").attr('class', 'form-group');
	$("#sslKeyStorePathErrorMsg").html("");
	$("#sslKeyStorePasswordCtrlGroup").attr('class', 'form-group');
	$("#sslKeyStorePasswordErrorMsg").html("");

	enabledChecked();
	
	$('#hostPortModal').on("shown.bs.modal", function() {
	});
	$('#hostPortModal').modal('show');	
}

function enabledChecked()
{
	var checked = $("#sslEnable").prop('checked');;
	$("#sslKeyStorePath").prop('disabled', !checked);
	$("#sslKeyStorePassword").prop('disabled', !checked);
}

function hostPortClose() {
	$('#hostPortModal').modal('hide');
}

function hostPortSave() {
	//need to check values
	var ok=true;
	$("#hostportNameEditCtrlGroup").attr('class', 'form-group');
	$("#hostportNameEditErrorMsg").html("");
	$("#ipAddressCtrlGroup").attr('class', 'form-group');
	$("#ipAddressErrorMsg").html("");
	$("#portCtrlGroup").attr('class', 'form-group');
	$("#portErrorMsg").html("");
	
	if($("#hostportNameEdit").val() =="")
	{
		$("#hostportNameEditCtrlGroup").attr('class', 'form-group has-error');
		$("#hostportNameEditErrorMsg").html("${nameEmpty}");
		$("#hostportNameEditErrorMsg").show();
		ok=false;
	}
	else
	{
		var nApp=$("#hostportNameEdit").val().trim();
	 	if (!isValidFileName(nApp))
		{
			$('#hostportNameEditCtrlGroup').attr('class', 'form-group has-error');
			$('#hostportNameEditErrorMsg').html("${nameError}");
			$('#hostportNameEditErrorMsg').show();
			ok=false;
		}
	 	else
		{
			$('#hostportNameEditCtrlGroup').attr('class', 'form-group');
			$('#hostportNameEditErrorMsg').html("");
			$('#hostportNameEditErrorMsg').hide();
		}
	}
	if(editIdx<0)
	{
		for (tblItem in tblDataHostPorts) {
			if(!tblDataHostPorts[tblItem].removed)
			{
				if(tblDataHostPorts[tblItem].name==$("#hostportNameEdit").val())
				{
					$("#hostportNameEditCtrlGroup").attr('class', 'form-group has-error');
					$("#hostportNameEditErrorMsg").html("${dupNameError}");
					$('#hostportNameEditErrorMsg').show();
					ok=false;			
				}
			}
		}
	}
	if($("#ipAddress").val() =="")
	{
		$("#ipAddressCtrlGroup").attr('class', 'form-group has-error');
		$("#ipAddressErrorMsg").html("${ipAddressEmpty}");
		$('#ipAddressErrorMsg').show();
		ok=false;
	}
	else
	{
		$("#ipAddressCtrlGroup").attr('class', 'form-group');
		$("#ipAddressErrorMsg").html("");
		$("#ipAddressErrorMsg").hide();
	}
	if($("#port").val() =="")
	{
		$("#portCtrlGroup").attr('class', 'form-group has-error');
		$("#portErrorMsg").html("${portEmpty}");
		$('#portErrorMsg').show();
		ok=false;
	}
	else 
	{
		var nApp = $("#port").val().trim();
		if ((nApp < 1) || (nApp > 65535))
		{
			$("#portCtrlGroup").attr('class', 'form-group has-error');
			$("#portErrorMsg").html("${portError}");
			$('#portErrorMsg').show();
			ok=false;
		}
		else
		{
			$("#portCtrlGroup").attr('class', 'form-group');
			$("#portErrorMsg").html("");
			$('#portErrorMsg').hide();
		}
	}
	if($("#sslEnable").prop( "checked" ))
	{
		$("#sslKeyStorePath").val(fixFilePathSlashes($("#sslKeyStorePath").val()));
		var nPath = $("#sslKeyStorePath").val().trim();
		if (nPath =="")
		{
			$("#sslKeyStorePathCtrlGroup").attr('class', 'form-group has-error');
			$("#sslKeyStorePathErrorMsg").html("${sslKeyStorePathEmpty}");
			$("#sslKeyStorePathErrorMsg").show();
			ok=false;
		}
		else
		{
		 	if (!isValidPath(nPath))
		 	{
				$("#sslKeyStorePathCtrlGroup").attr('class', 'form-group has-error');
				$("#sslKeyStorePathErrorMsg").html("${sslKeyStorePathError}");
				$("#sslKeyStorePathErrorMsg").show();
				ok=false;		 		
		 	}
		 	else
		 	{
				$("#sslKeyStorePathCtrlGroup").attr('class', 'form-group');
				$("#sslKeyStorePathErrorMsg").html("");
				$("#sslKeyStorePathErrorMsg").hide();
		 	}
		}
		
		var nPwd = $("#sslKeyStorePassword").val().trim();
		if (nPwd =="")
		{
			$("#sslKeyStorePasswordCtrlGroup").attr('class', 'form-group has-error');
			$("#sslKeyStorePasswordErrorMsg").html("${sslKeyStorePasswordEmpty}");
			$("#sslKeyStorePasswordErrorMsg").show();
			ok=false;
		}
		else
		{
			$("#sslKeyStorePasswordCtrlGroup").attr('class', 'form-group');
			$("#sslKeyStorePasswordErrorMsg").html("");
			$("#sslKeyStorePasswordErrorMsg").hide();
		}
	}
	if(!ok)
	{
		return;	
	}
	if(editIdx<0)
	{
		var newItem = new Object();
		newItem.orgIdx = tblIdxHostPorts++;
		newItem.order = tblIdxHostPorts;
		newItem.removed=false;
		newItem.name=$("#hostportNameEdit").val();
		newItem.ipAddress=$("#ipAddress").val();
		newItem.port=$("#port").val();
		newItem.type=$("#typeEdit").val();
		newItem.sslEnable = $("#sslEnable").prop( "checked" );
		newItem.sslKeyStorePath = $("#sslKeyStorePath").val();
		newItem.sslKeyStorePassword = $("#sslKeyStorePassword").val();
		tblDataHostPorts.push(newItem);
	}
	else 
	{
		tblDataHostPorts[editIdx].name=$("#hostportNameEdit").val();
		tblDataHostPorts[editIdx].ipAddress=$("#ipAddress").val();
		tblDataHostPorts[editIdx].port=$("#port").val();
		tblDataHostPorts[editIdx].type=$("#typeEdit").val();		
		tblDataHostPorts[editIdx].sslEnable = $("#sslEnable").prop( "checked" );
		tblDataHostPorts[editIdx].sslKeyStorePath=$("#sslKeyStorePath").val();		
		tblDataHostPorts[editIdx].sslKeyStorePassword=$("#sslKeyStorePassword").val();		
	}
	hostPortClose();
	updateTableHostPorts();
}

</script>