<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="addSMILFileModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="addSMILFileModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form id="addForm" class="form-modal">
				<fieldset>
					<div class="modal-header">
						<button type="button" class="close" onClick="javascript:addSMILFileClose()">x</button>
						<h4 id="addSMILFileModalLabel" class="modal-title">
							<wmsform:getlocalestring page="${page}" obj="addSMILFileDialog.dialogTitle" />
						</h4>
					</div>
					<div class="modal-body">
						<p>
							<wmsform:getlocalestring page="${page}" obj="addSMILFileDialog.message" />
						</p>
						<wmsform:editproperty page="${page}.addSMILFileDialog" obj="smilFile" required="true" bind="false"/>
						<wmsform:editproperty page="${page}.addSMILFileDialog" obj="title" bind="false"/>
					</div>
					<div class="modal-footer">
						<div class="row">
							<div class="col-md-8">
								<div id="addSMILFileNameWarnings" class="alert alert-danger"></div>
							</div>
							<div class="col-md-4">
								<wmsform:buttoncancel onClick="javascript:addSMILFileClose()" />
								<wmsform:buttonadd onClick="javascript:doAdd()" />
							</div>
						</div>
					</div>
				</fieldset>
			</form>
		</div>
	</div>
</div>
<c:set var="dupSMILFileNameError">
	<wmsform:getlocalestring page="${page}" obj="SMILFileName.dup"/>
</c:set>
<c:set var="blankNameError">
	<wmsform:getlocalestring page="${page}" obj="SMILFileName.empty"/>
</c:set>

<c:set var="invalidNameError">
	<wmsform:getlocalestring page="common" obj="invalidFileName"/>
</c:set>
<c:set var="invalidNameLengthError">
	<wmsform:getlocalestring page="$common" obj="invalidFileNameLength"/>
</c:set>

<script>
$(document).ready(function() {
	$("#addForm").bind("keypress", function(e) {
         if (e.keyCode == 13) {   
        	 doAdd();
             return false;
        }
     });
});

function addSMILFileShow() {
	//$("#addSMILFileName").text(addSMILFileDisplayName);
	$('#addSMILFileNameWarnings').hide();

	$('#smilFile').val("");
	$('#addSMILFileModal').on("shown.bs.modal", function() {
		$('#smilFile').focus();
	});
	$('#addSMILFileModal').modal('show');
}

function addSMILFileClose() {
	$('#addSMILFileModal').modal('hide');
}

function doAdd()
{
	var ok=true;
	var fname = $("#smilFile").val().trim();
	var title = $("#title").val().trim();
	if(fname.indexOf(".smil", fname.length - 5) != -1)
	{
		fname = fname.substr(0,fname.length-5);
	}
	
	if(fname=="")
	{
		$('#addSMILFileNameWarnings').html("${blankNameError}");
		$('#addSMILFileNameWarnings').show();
		ok=false;					
	}
	for (tblItem in tblDataSMILFiles) {
		if(tblDataSMILFiles[tblItem].name==fname)
		{
			$('#addSMILFileNameWarnings').html("${dupSMILFileNameError}");
			$('#addSMILFileNameWarnings').show();
			ok=false;			
		}
	}
	if(ok && !isValidFileName(fname))
	{
		$('#addSMILFileNameWarnings').html("SMIL File Name: ${invalidNameError}");
		$('#addSMILFileNameWarnings').show();
		ok=false;
	}
	if(ok && !isValidFileNameLength(fname))
	{
		$('#addSMILFileNameWarnings').html("SMIL File Name: ${invalidNameLengthError}");
		$('#addSMILFileNameWarnings').show();
		ok=false;
	}
	if(ok)
	{
		createSMILFile(fname,title);		
	}
	
}

function createSMILFile(smilName, title) {
	smilName=encodeURIComponent(smilName);
	title=encodeURIComponent(title);
	
	$('#addSMILFileModal').on('hidden.bs.modal', function() {
		postAJAXForm('server/vhost/smilfile/new.htm','vhost=${wmsutil:urlEncode(vhost)}&appType=${appType}&appName=${wmsutil:urlEncode(appName)}&smilName='+ smilName+"&title="+title);
	});
	addSMILFileClose();
}

</script>