<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<wmsform:setpagetitle page="mediacache.source" appName="${sourceName}"/>

<c:set var="gEncMethod" value="${googleEncMethod}"/>

<div class="col-md-8 main-content">
	<wmsform:rightrailhideshow/>
	<p><wmsform:getlocalestring page="mediaCache.source" obj="header"/></p>
	<p><wmsform:buttonedit onClick="javascript:loadAjaxMainContent('server/mediacachesource/edit.htm','sourceName=${sourceName}&action=')"/></p>
	<wmsform:viewproperty page="mediaCache.source" obj="description" showEmptyString="-Not Set-"/>
	<wmsform:viewproperty page="mediaCache.source" obj="prefix"/>
	<c:choose>
		<c:when test="${sourceType=='AmazonS3'}">
			<wmsform:viewproperty page="mediaCache.source" obj="basePath"/>
		</c:when>
		<c:otherwise>
		</c:otherwise>
	</c:choose>
	<c:choose>
		<c:when test="${sourceType=='HTTP'}">
			<wmsform:viewproperty page="mediaCache.source" obj="basePath"/>
		</c:when>
		<c:otherwise>
		</c:otherwise>
	</c:choose>
	<c:choose>
		<c:when test="${sourceType=='File'}">
			<wmsform:viewproperty page="mediaCache.source" obj="basePath"/>
		</c:when>
		<c:otherwise>
		</c:otherwise>
	</c:choose>
	<c:choose>
		<c:when test="${sourceType=='AmazonS3'}">
			<wmsform:viewproperty page="mediaCache.source" obj="awsAccessKeyID" showEmptyString="-Not Set-"/>
			<wmsform:viewproperty page="mediaCache.source" obj="awsSecretAccessKey" showEmptyString="-Not Set-"/>
			<wmsform:viewpropertycheckbox page="mediaCache.source" obj="useS3BucketName"/>
		</c:when>
		<c:when test="${sourceType=='Azure'}">
			<wmsform:viewproperty page="mediaCache.source" obj="azureAccountName" showEmptyString="-Not Set-"/>
			<wmsform:viewproperty page="mediaCache.source" obj="azureContainerName" showEmptyString="-Not Set-"/>
			<wmsform:viewproperty page="mediaCache.source" obj="azureAccountKey" showEmptyString="-Not Set-"/>
		</c:when>
		<c:when test="${sourceType=='GoogleCloudStorage'}">
			<wmsform:viewproperty page="mediaCache.source" obj="googleServiceID" showEmptyString="-Not Set-"/>
			<wmsform:viewproperty page="mediaCache.source" obj="googleEncMethod" showEmptyString="-Not Set-"/>
		</c:when>
		<c:otherwise>
		</c:otherwise>
	</c:choose>

	<div id="googleViewCSFileOptions" style="display:none" >
		<wmsform:viewproperty page="mediaCache.source" obj="googleServicePrivateKeyFile" showEmptyString="-Not Set-"/>
		<wmsform:viewproperty page="mediaCache.source" obj="googleServicePrivateKeyPassword" showEmptyString="-Not Set-"/>
	</div>

	<div id="googleViewCSJSONOptions" style="display:none" >
		<wmsform:viewproperty page="mediaCache.source" obj="googleServiceKey" showEmptyString="-Not Set-"/>
	</div>


	<wmsform:viewproperty page="mediaCache.source" obj="minTTLstr"/>
	<wmsform:viewproperty page="mediaCache.source" obj="maxTTLstr"/>

</div>
<div id="HelpBasic" class="col-md-4 right-rail well-help pull-right">
    <jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
</div>

<script>

viewGoogleEncOptions();

function viewGoogleEncOptions()
{
    googleEncType = $('#googleEncMethod').val();
    srcType = $('#sourceType').val();

    if(srcType=='GoogleCloudStorage')
    {
        if ( googleEncType=='JSON' )
        {
        $('#googleViewCSFileOptions').hide();
    	$('#googleViewCSJSONOptions').show();
        }
        else if ( googleEncType=='P12' )
        {
        $('#googleViewCSFileOptions').show();
    	$('#googleViewCSJSONOptions').hide();

        }
        else
        {
  		$('#googleViewCSFileOptions').hide();
    	$('#googleViewCSJSONOptions').hide();
    	}
    }
    else
    {
   	$('#googleViewCSFileOptions').hide();
    $('#googleViewCSJSONOptions').hide();
    }

}

</script>

