<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<p>Use the following settings to configure file-based and chunk-based media content sources.</p>

<h5>Source Name and Description</h5>
<p>Information about this source to help you identify it from other Media Cache Sources. The source name must be unique and can't contain less-than (&lt;), greater-than (&gt;), colon (&#58;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), asterisk (&#42;), double-dot (..), and tilde (&#126;) characters.</p>

<h5>Source Type</h5>
<p>Identifies the Media Cache Source type. You can add Media Cache Sources for the following additional source types:
<ul>
	<li><strong>File</strong>. For re-streaming files from network-attached storage.</li>
	<li><strong>HTTP</strong>. For re-streaming files from HTTP-based servers. The HTTP connection can be encrypted using Secure Sockets Layer (SSL) certificates from a certificate authority. Wowza provides free 256-bit SSL certificates to users with Subscription and Perpetual licenses via the <a href="https://www.wowza.com/docs/how-to-get-ssl-certificates-from-the-streamlock-service" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Wowza StreamLock&#8482; AddOn</a>.</li>
	<li><strong>AmazonS3</strong>. For re-streaming files from an Amazon&nbsp;S3 bucket.</li>
	<li><strong>Azure</strong>. For re-streaming files from a Microsoft&nbsp;Azure&nbsp;Blob storage account.</li>
	<li><strong>GoogleCloudStorage</strong>. For re-streaming content from a Google Cloud Storage bucket connected to a Google Cloud Platform service account. 
</ul>


<!------------------->
<!--   File Info   -->
<!------------------->

<div id="sourceTypeFileTitle" file-title-help style="display:none">
	<h4>File Source Settings</h4>
	<p>Configure the following settings for re-streaming files from network-attached storage.</p>
</div>

<!------------------->
<!--HTTP Title Info-->
<!------------------->

<div id="sourceTypeHTTPTitle" http-title-help style="display:none">
	<h4>HTTP Source Settings</h4>
	<p>Configure the following settings for re-streaming files from HTTP-based servers. (Supports http:// and https:// (SSL) requests.)</p>
</div>

<!------------------->
<!--Amazon Title Info-->
<!------------------->

<div id="sourceTypeAmazonTitle" aws-title-help style="display:none">
	<h4>AmazonS3 Source Settings</h4>
	<p>Configure the following settings for re-streaming files from an Amazon&nbsp;S3 bucket.</p>
</div>

<!------------------->
<!--  Azure Title Info   -->
<!------------------->

<div id="sourceTypeAzureTitle" azure-title-help style="display:none">
	<h4>Azure Source Settings</h4>
	<p>Configure the following settings for re-streaming files from a Microsoft Azure Blob storage account.</p>
</div>

<!------------------->
<!--  Google Cloud Storage Info   -->
<!------------------->

<div id="sourceTypeGoogleCSTitle" googlecs-title-help style="display:none">
	<h4>GoogleCloudStorage Source Settings</h4>
	<p>Configure the following settings for re-streaming files from a Google Cloud Storage account.</p>
</div>

<!------------------------>
<!--Prefix and Base Path-->
<!------------------------>
<div id="prefixBasePath" prefixbasepath-options-help style="display:none">
<h5>Prefix and Base Path</h5>
<p>Settings that work together to control how content is retrieved from Media Cache Sources when re-streaming. The <strong>Prefix</strong> must be a unique value that maps a stream name requested by clients to the source. It's replaced by the <strong>Base Path</strong> value when re-streaming content. The path value can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), backslash (&#92;), pipe (&#124;), question mark (&#63;), and asterisk (&#42;) characters. For more information about how to use these values in specific configurations, see <a href="https://www.wowza.com/docs/how-to-scale-video-on-demand-streaming-with-media-cache" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Scale video-on-demand streaming with Wowza Streaming Engine Media Cache</a>.</p>
</div>

<!------------------->
<!--Amazon Main Info-->
<!------------------->

<div id="sourceTypeAmazonMain" aws-main-help style="display:none">
	<h5>Amazon Web Services (AWS) Settings</h5>
	<ul>
		<li><strong>AWS Access Key ID</strong> and <strong>AWS Secret Access Key</strong>. Enables re-streaming from an Amazon&nbsp;S3 bucket that's not publicly available. Enter your Amazon&nbsp;S3 key ID and secret access key to enable the media cache to sign HTTP requests so that they're authenticated for access to protected content. These values can't contain spaces.</li>
		<li><strong>Use Amazon&nbsp;S3 bucket name in domain</strong>. Controls how the HTTP request URLs used by the media cache to address content on Amazon&nbsp;S3 are formatted. Select this option to include the bucket name in the domain name. Otherwise, the bucket name is included in the URL path.</li>
	</ul>
</div>

<!------------------->
<!--  Azure Main Info   -->
<!------------------->

<div id="sourceTypeAzureMain" azure-main-help style="display:none">
	<h5>Prefix</h5>
	<p>Enter a unique value for mapping a stream name requested by clients to the source.</p>
	<h5>Azure Blob Storage Settings</h5>
	<ul>
		<li><strong>Blob Storage Account Name</strong>. Enter the name of your Azure Blob storage account.</li>
		<li><strong>Blob Storage Container Name</strong>. Enter the name of a container in your Azure Blob storage. A Media Cache Source can point to only one container in Azure Blob storage.</li>
		<li><strong>Blob Storage Account Access Key</strong>. Enter either the primary or secondary access key for the account.</li>
	</ul>
</div>

<!------------------->
<!--  Google Cloud Storage Main Info   -->
<!------------------->

<div id="sourceTypeGoogleCSMain" googlecs-main-help style="display:none">
	<h5>Prefix</h5>
	<p>Enter a unique value for mapping a stream name requested by clients to the source.</p>
	<h5>GoogleCloudStorage Source Settings</h5>
	<ul>
		<li><strong>Google Service Account Email Address</strong>. Enter the email address (account ID) that belongs to this service account.</li>
		<li><strong>Google Private Key Type</strong>. The type of key file certificate that you selected and downloaded when creating your service account (<strong>JSON</strong> or <strong>P12</strong>). JSON is recommended.</li>
	</ul>
</div>

<div id="sourceTypeGoogleCSP12" googlecs-p12-help style="display:none">
	<h5>P12 Options</h5>
	<p>If you're using a P12 private key file for certification, copy the downloaded P12 private key file to your Wowza Streaming Engine <strong>[install-dir]/conf</strong> directory. Then enter the name of the P12 private key file (including the file extension) in the <strong>Google P12 Private Key File Name</strong> box and enter the password to access the private key in the <strong>Google P12 Private Key Password</strong> box.</p>
</div>

<div id="sourceTypeGoogleCSJSON" googlecs-json-help style="display:none">
	<h5>JSON Options</h5>
	<p>If you're using a JSON private key file for certification, open the downloaded JSON private key file in a text editor and then copy the file contents into the <strong>Google JSON Private Key</strong> box.</p>
</div>


<!------------------->
<!--Validation Box -->
<!------------------->

<div id="validationBox" validation-options-help style="display:none">
<blockquote><strong>Note:</strong> The <strong>Validate Configuration</strong> box shows the HTTP request URL that the media cache uses to address the Media Cache Source using the specified values.</blockquote>
</div>

<h5>Minimum and Maximum Time To Live</h5>
<p>Options that control how long unused source content can be cached. The time-to-live counter starts when the last client playing the content stops. If the cache is full and other source items are requested, content that isn't viewed within the specified <strong>Minimum Time To Live</strong> is purged from the cache. If the cache isn't full, content that isn't viewed can remain in the cache until the specified <strong>Maximum Time To Live</strong> is reached, after which it's purged from the cache. The specified <strong>Minimum Time To Live</strong> value must be less than or equal to the specified <strong>Maximum Time To Live</strong> value.</p>