<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>


<%----------------------%>
<%-- All profiles --%>
<%----------------------%>

<div id="streamTargetIntroHelp" basicWizardOnlyEdit style="display:none">
	<h4>Configuring Stream Targets</h4>
	<p>Use the following settings to map the incoming live source stream to the stream target destination.</p>
	<blockquote><strong>Note:</strong> If you change the settings for a stream target that has an active stream, the stream target will be restarted.</blockquote>
</div>


<%----------------------%>
<%-- Akamai only --%>
<%----------------------%>
<div id="destination-options-help-dest-protocol" basicAkamaiProtocolView basicAkamaiProtocolEdit style="display:none">
	<h5>Destination Protocol</h5>
	<p>The Akamai stream target can send a source stream to Akamai over multiple protocols, select the protocol that you want to use. If you configured an entry point at the destination to use a specific protocol, be sure to select the matching protocol.</p>
</div>

<%----------------------%>
<%-- Facebook only --%>
<%----------------------%>
<div id="facebookIntroHelp" basicFacebookView basicFacebookEdit style="display:none">
		<blockquote><strong>Note:</strong> Facebook prohibits you from simultaneously streaming to Facebook Live and other online services. You can, however, broadcast to your Facebook page and your own website. For more information, see "Can I Simulcast?" in the <a href="https://developers.facebook.com/docs/videos/live-video/faq#advanced">Facebook Live API FAQ</a>.
</div>

<%----------------------%>
<%-- SRT only --%>
<%----------------------%>
<div id="srtIntroHelp" basicSRTView basicSRTEdit basicSRTSecureView basicSRTSecureEdit style="display:none">
</div>


<%----------------------%>
<%-- Shoutcast profiles --%>
<%----------------------%>

<div id="destination-options-help-shoutcast" basicShoutcastProtocolView basicShoutcastProtocolEdit style="display:none">
	<h5>SHOUTcast Protocol</h5>
	<p>Your selected stream target can send a source stream to a destination over multiple protocols. Select the protocol that you want to use. If you configured an entry point at the destination to use a specific protocol, be sure to select the matching protocol.</p>
</div>


<%----------------------%>
<%-- All profiles --%>
<%----------------------%>

<div id="streamTargetNameHelp" basicWizardOnlyEdit style="display:none">
	<h5>Stream Target Name</h5>
	<p>The name of the stream target. Use a name to help you identify it from other stream targets. For example, name a stream target to indicate its destination, protocol, and rendition (<strong>myDestination-RTMP-720p</strong>). The name must be unique and can't contain less-than (&lt;), greater-than (&gt;), colon (&#58;), quotation (&#39; and &quot;), forward slash (&#47;), backslash (&#92;), pipe (&#124;), question mark (&#63;), asterisk (&#42;), double-dot (..), and tilde (&#126;) characters.</p>
</div>

<div id="WowzaStreamingCloudConnectionCodeHelp" basicWowzaStreamingCloudView basicWowzaStreamingCloudEdit style="display:none">
	<h5>Connection Code</h5>
	<p>The connection code provided by Wowza Streaming Cloud. To get the connection code, you must set up a live stream in Wowza Streaming Cloud and specify that Wowza Streaming Engine provides the source stream. For details, see <a href="https://www.wowza.com/docs/push-from-wowza-streaming-engine-to-wowza-streaming-cloud-transcoder" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Send a live stream from Wowza Streaming Engine to Wowza Streaming Cloud for transcoding</a>.</p>

	<div id="WowzaStreamingCloudConnectionCodeAlreadyUsedHelp">
		<blockquote><strong>Note:</strong> The <strong>already used</strong> value means that a valid connection code was used to connect this stream target to the Wowza Streaming Cloud destination. If you regenerate the connection code in Wowza Streaming Cloud for this connection, be sure to enter this new value.</blockquote>
	</div>
</div>

<%----------------------%>
<%---- Cloud and CDN profiles ----%>
<%----------------------%>
<div id="WowzaCloudAdaptiveStreamingHelp" basicWowzaCloudAdaptiveStreamingView basicWowzaCloudAdaptiveStreamingEdit style="display:none">
	<h5>Streaming Bitrates</h5>
	<p>The number of bitrate renditions of the source stream that will be sent to the destination. Select <strong>Multiple adaptive-bitrate streams</strong> to send a group of renditions for adaptive-bitrate playback or <strong>Single bitrate stream</strong> to send a single version of the stream.</p>
</div>

<div id="sourceStreamNameHelp" basicSourceStreamNameView basicSourceStreamNameEdit style="display:none">
	<h5>Source Stream Name</h5>
	<p>The name of the incoming source stream that will be sent to the destination.</p>
</div>

<div id="sourceStreamNamePrefixHelp" basicSourceStreamNamePrefixView basicSourceStreamNamePrefixEdit style="display:none">
	<h5>Source Stream Name Prefix</h5>
	<p>The string to match against incoming source streams to determine which should be sent to the destination, allowing all bitrate stream renditions beginning with the stream name prefix to be sent to the destination as a group. Exact matches are excluded to avoid unintentionally sending the original source stream when the renditions are created with the Wowza Streaming Engine transcoder.</p>
</div>


<%----------------------%>
<%-- Shoutcast profiles --%>
<%----------------------%>

<div id="shoutcastHostHelp" basicShoutcastGenericView basicShoutcastGenericEdit style="display:none">
	<h5>Destination Host</h5>
	<p>The hostname or IP address of the destination server that the source stream will be sent to.</p>
</div>

<div id="destPortRTMPHelp" basicShoutcastGenericView basicShoutcastGenericEdit style="display:none">
	<h5>Destination Port</h5>
	<p>The port on the destination server that the source stream will be sent to.</p>
</div>

<div id="shoutcastUsernameHelp" basicShoutcastUserView basicShoutcastUserEdit style="display:none">
	<h5>User Name/Auth Hash</h5>
	<p>The user name or auth hash to access the destination. For Icecast 2 this is commonly source for SHOUTcast 2
	this is an authhash.</p>
</div>

<div id="shoutcastPasswordHelp" basicShoutcastGenericView basicShoutcastGenericEdit style="display:none">
	<h5>Password</h5>
	<p>The password to access the destination server, if the destination server authenticates the connection.</p>
</div>

<div id="shoutcastDestinationHelp" basicShoutcastDestinationView basicShoutcastDestinationEdit style="display:none">
	<h5>Destination Mount Point/ID</h5>
	<p>The destination stream name. This is the mount point name for Icecast 2 or the Stream ID for SHOUTcast 2.</p>
</div>

<div id="shoutcastDescriptionHelp" basicShoutcastDescriptionView basicShoutcastDescriptionEdit style="display:none">
	<h5>Description</h5>
	<p>The short description sent to the server when the connection is established.</p>
</div>

<div id="shoutcastNameHelp" basicShoutcastGenericView basicShoutcastGenericEdit style="display:none">
	<h5>Server Name</h5>
	<p>The name sent to the server when the connection is established.</p>
</div>

<div id="shoutcastGenreHelp" basicShoutcastGenericView basicShoutcastGenericEdit style="display:none">
	<h5>Genre</h5>
	<p>The genre of the audio style being sent to the server. For SHOUTcast, this should be one of the <a href="http://wiki.shoutcast.com/wiki/SHOUTcast_Radio_Authhash_API#Supported_Genres">supported genres</a>. Icecast 2 servers allow user defined genres.</p>
</div>

<div id="shoutcastMetaFormatHelp" basicShoutcastGenericView basicShoutcastGenericEdit style="display:none">
	<h5>Track Update Meta Data Format</h5>
	<p>This defines the format of the updates for track title information. It allows you to define how meta data in the source stream is used.</p>
</div>

<div id="shoutcastURLHelp" basicShoutcastGenericView basicShoutcastGenericEdit style="display:none">
	<h5>Website URL</h5>
	<p>The URL sent to the server when the connection is established. It should be a fully qualitied URL and begin http://.</p>
</div>

<div id="shoutcastAIMHelp" basicShoutcastGenericView basicShoutcastGenericEdit style="display:none">
	<h5>AIM</h5>
	<p>The AIM number sent to the server when the connection is established.</p>
</div>

<div id="shoutcastICQHelp" basicShoutcastGenericView basicShoutcastGenericEdit style="display:none">
	<h5>ICQ</h5>
	<p>The ICQ number sent to the server when the connection is established.</p>
</div>

<div id="shoutcastIRCHelp" basicShoutcastGenericView basicShoutcastGenericEdit style="display:none">
	<h5>IRC</h5>
	<p>The IRC number sent to the server when the connection is established.</p>
</div>

<div id="shoutcastPublicHelp" basicShoutcastGenericView basicShoutcastGenericEdit style="display:none">
	<h5>Directory Listing</h5>
	<p>This flag is sent to the destination to inform it that the stream information may/may not be sent to a
	configured directory service. The destination server may be configured to ignore this flag.</p>
</div>


<%----------------------%>
<%-- RTMP profiles --%>
<%----------------------%>

<%--RTMP Alibaba --%>
<div id="destApplicationAlibabaHelp" basicRTMPAlibabaView basicRTMPAlibabaEdit style="display:none">
	<h5>Destination Application Name</h5>
	<p>The name of the application that is automatically created on the destination server to receive the stream. We recommend using the Wowza Streaming Engine live application name.</p>
</div>

<%-- RTMP Generic - Includes all RTMP destinations/profiles except rtmp-akamai
             Note - This includes 'rtmp-limelight' and the other destinations that use the 'rtmp' profile (Alibaba, Tata, Limelight, MirrorImage, YouTube)
--%>
<div id="destApplicationRTMPHelp" basicRTMPAppNameView basicRTMPAppNameEdit style="display:none">
	<h5>Destination Application Name</h5>
	<p>The name of the application that you provisioned at this stream target's destination. The stream target will send the stream to this application.</p>
</div>
<div id="destAppInstanceRTMPHelp" basicRTMPGenericView basicRTMPGenericEdit style="display:none">
	<h5>Destination Application Instance</h5>
	<p>The name of the application instance that you provisioned at this stream target's destination. The stream target will send the stream to this application instance, or if none is specified, to the default application instance.</p>
</div>
<div id="destHostRTMPHelp" basicRTMPGenericView basicRTMPGenericEdit style="display:none">
	<h5>Destination Host</h5>
	<p>The hostname or IP address of the destination server that the source stream will be sent to.</p>
</div>


<%-- RTMP Common - Includes all RTMP destinations (including Akamai), except for Alibaba --%>

<div id="destPortRTMPHelp" basicRTMPCommonView basicRTMPCommonEdit basicRTMPAkamaiView style="display:none">
	<h5>Destination Port</h5>
	<p>The port on the destination server that the source stream will be sent to.</p>
</div>
<div id="destStreamNameRTMPHelp" basicRTMPCommonView basicRTMPCommonEdit basicRTMPAkamaiView style="display:none">
	<h5>Destination Stream Name</h5>
	<p>The name of the stream that the stream target will send to the destination. Some destinations will require that you use a specific stream name, which you must enter here.</p>
</div>
<div id="usernameHelp" basicRTMPCommonView basicRTMPCommonEdit basicRTMPAkamaiView style="display:none">
	<h5>User Name</h5>
	<p>The user name to access the destination, if the destination server authenticates the connection.</p>
</div>
<div id="passwordHelp" basicRTMPCommonView basicRTMPCommonEdit basicRTMPAkamaiView style="display:none">
	<h5>Password</h5>
	<p>The password to access the destination server, if the destination server authenticates the connection.</p>
</div>

<%-- RTMP Alibaba --%>
<div id="alibabaDestPortRTMPHelp" basicRTMPAlibabaView basicRTMPAlibabaEdit style="display:none">
	<h5>Destination Port</h5>
	<p>The source stream must be sent to port 1935 on the destination server.</p>
</div>
<div id="alibabaDestStreamNameRTMPHelp" basicRTMPAlibabaView basicRTMPAlibabaEdit style="display:none">
	<h5>Destination Stream Name</h5>
	<p>The name of the stream followed by the vhost query parameter and, if you're using authentication, the auth-key query parameters. You must use the following format: <strong>video-name?vhost=[your-domain-name]&auth_key=[your-key]</strong>.</p>
</div>

<%-- RTMP Akamai - Includes only the RTMP Akamai destination-profile --%>

<div id="akamaiStreamIdRTMPHelp" basicRTMPAkamaiView basicRTMPAkamaiEdit style="display:none">
	<h5>Akamai Stream ID</h5>
	<p>The identifier assigned to the live stream that you provisioned in Akamai Luna Control Center.</p>
</div>
<div id="akamaiSendToBackupServerHelp" basicRTMPAkamaiView basicRTMPAkamaiEdit style="display:none">
	<h5>Send To Backup Server</h5>
	<p>If this Wowza Streaming Engine instance will send a redundant stream for failover purposes if the primary Streaming Engine instance fails, select the check box to send the stream to the backup entry point at the destination. If this Wowza Streaming Engine instance will send the stream to the primary entry point at the destination, clear the check box.</p>
</div>


<%-- RTP - Includes only the RTP destination/profile --%>

<div id="destStreamNameRTPHelp" basicRTPView basicRTPEdit style="display:none">
	<h5>Destination Stream Name</h5>
	<p>The name of the Session Description Protocol (SDP) file to create in the <strong>&#91;install-dir&#93;&#47;applications&#47;&#91;application-name&#93;&#47;sdp</strong> folder. Media players that support RTP playback use this file to play the stream.</p>
</div>
<div id="destHostRTPHelp" basicRTPView basicRTPEdit style="display:none">
	<h5>Destination Host</h5>
	<p>The destination hostname or IP address that the source stream will be sent to.</p>
</div>
<div id="videoPortHelp" basicRTPView basicRTPEdit style="display:none">
	<h5>Destination Video Port</h5>
	<p>An even-numbered UDP port that the video portion of the source stream will be sent to. The video is sent to the specified port number (for example, <strong>10002</strong>) and the adjacent (higher) port (<strong>10003</strong>).</p>
	<blockquote><strong>Note:</strong> The port number you specify and the adjacent port are used only for video. The audio portion of the stream must use different ports.</blockquote>
</div>
<div id="audioPortHelp" basicRTPView basicRTPEdit style="display:none">
	<h5>Destination Audio Port</h5>
	<p>An even-numbered UDP port that the audio portion of the source stream will be sent to. The audio is sent to the specified port number (for example, <strong>10004</strong>) and the adjacent (higher) port (<strong>10005</strong>).</p>
<blockquote><strong>Note:</strong> The port number you specify and the adjacent port are used only for audio. The video portion of the stream must use different ports.</blockquote>
</div>
<div id="streamWaitTimeoutHelp" basicRTPView basicRTPEdit style="display:none">
	<h5>Stream Wait Timeout</h5>
	<p>The time, in milliseconds, that the stream target waits for the streams defined in the Session Description Protocol (SDP) file to arrive from the native RTP encoder.</p>
</div>
<div id="timeToLiveRTPHelp" basicRTPView basicRTPEdit style="display:none">
	<h5>Time To Live</h5>
	<p>For multicast streaming, the time to live (TTL) value for the multicast UDP packets. This indicates the number of routers that the packets can pass through before they expire on the network.</p>
</div>


<%-- MPEGTS - Includes only the RTP destination/profile --%>

<div id="destStreamNameMPEGTSHelp" basicMPEGTSView basicMPEGTSEdit style="display:none">
	<h5>Destination Stream Name</h5>
	<p>The name of the Session Description Protocol (SDP) file to create in the <strong>&#91;install-dir&#93;&#47;applications&#47;&#91;application-name&#93;&#47;sdp</strong> folder. Media players that support RTP playback use this file to play the stream.</p>
</div>
<div id="destHostMPEGTSHelp" basicMPEGTSView basicMPEGTSEdit style="display:none">
	<h5>Destination Host</h5>
	<p>The destination hostname or (unicast or multicast) IP address that the source stream will be sent to.</p>
</div>
<div id="destPortMPEGTSHelp" basicMPEGTSView basicMPEGTSEdit style="display:none">
	<h5>Destination Port</h5>
	<p>The destination port that the source stream will be sent to.</p>
</div>
<div id="timeToLiveMPEGTSHelp" basicMPEGTSView basicMPEGTSEdit style="display:none">
	<h5>Time To Live</h5>
	<p>For multicast streaming, the time to live (TTL) value for the multicast UDP packets. This indicates the number of routers that the packets can pass through before they expire on the network.</p>
</div>
<div id="rtpWrapHelp" basicMPEGTSView basicMPEGTSEdit style="display:none">
	<h5>RTP Wrap</h5>
	<p>Select this option to "wrap" the MPEG-TS stream data in RTP and send a native RTP stream to the destination. Clear this option to send raw MPEG-TS data to the destination.</p>
</div>

<%-- SRT - Includes only the SRT destination/profile --%>

<div id="destHostSRTHelp" basicSRTView basicSRTEdit style="display:none">
	<h5>Destination Host</h5>
	<p>The destination hostname or IP address that the source stream will be sent to.</p>
</div>
<div id="destPortSRTHelp" basicSRTView basicSRTEdit style="display:none">
	<h5>Destination Port</h5>
	<p>The destination port that the source stream will be sent to.</p>
</div>
<div id="recoveryBufferSRTHelp" basicSRTView basicSRTEdit style="display:none">
	<h5>Recovery Buffer</h5>
	<p>The size of the SRT recovery buffer, in milliseconds. If not specified, the default value, <strong>400</strong>, is used.</p>
</div>
<div id="secureSRTHelp" basicSRTEdit style="display:none">
	<h5>Secure SRT</h5>
	<p>Select <strong>Use secure SRT</strong> to configure AES encryption to secure your SRT stream. If selected, you must specify a key length and passphrase.</p>
</div>
<div id="srtKeyLengthHelp" basicSRTSecureView basicSRTSecureEdit style="display:none">
	<h5>Key Length</h5>
	<p>Select the type of AES encryption that you're using to secure SRT. AES-128 uses a 16-character passphrase and AES-256 uses a 32-character passphrase.</p>
</div>
<div id="passphraseSRTHelp" basicSRTSecureView basicSRTSecureEdit style="display:none">
	<h5>Passphrase</h5>
	<p>The passphrase used to encrypt SRT traffic. The required length of the passphrase is determined by the specified <strong>Key Length</strong>. For AES-128, your passphrase must be 16-characters in length; for AES-256, your passphrase must be 32-characters in length.</p>
</div>

<%-- Akamai HTTP - Includes all of the Akamai HTTP destinations/profiles --%>

<div id="destStreamNameHTTPHelp" basicAkamaiHttpCommonView basicAkamaiHttpCommonEdit style="display:none">
	<h5>Destination Stream Name</h5>
	<p>The name of the stream that you provisioned at this stream target's destination. The stream target will send the stream with this stream name.</p>
</div>
<div id="destHostHTTPAkamaiHelp" basicAkamaiHttpCommonView basicAkamaiHttpCommonEdit style="display:none">
	<h5>Destination Host</h5>
	<p>The hostname or IP address of the destination server that the source stream will be sent to. For Akamai HLS/HDS/DASH targets that use the Akamai MSL 3 network, you must provide either a <strong>Destination Host</strong> or an <strong>Akamai Host ID</strong>.  If the target uses the Akamai MSL 4 network, the <strong>Destination Host</strong> is optional.</p>
</div>
<div id="playbackHostHelp" basicAkamaiHttpCommonView basicAkamaiHttpCommonEdit style="display:none">
	<h5>Playback Host</h5>
	<p>The hostname or IP address of the server that the stream will be played-back from.  For Akamai HLS, HDS, and DASH targets, the playback host is provided when your account is on the Akamai MSL 4 network and you've disabled relative playlists because you require absolute URLs in the playlists or manifests pushed to Akamai.</p>
</div>
<div id="akamaiStreamIdHTTPHelp" basicAkamaiHttpCommonView basicAkamaiHttpCommonEdit style="display:none">
	<h5>Akamai Stream ID</h5>
	<p>The identifier assigned to the live stream that you provisioned in Akamai Luna Control Center.</p>
</div>
<div id="akamaiHostIdHelp" basicAkamaiHttpCommonView basicAkamaiHttpCommonEdit style="display:none">
	<h5>Akamai Host ID</h5>
	<p>The host ID of the Akamai configuration containing the stream that you provisioned in the Akamai Luna Control Center (MSL 3 network only), which appears in the configuration's <strong>Host Name</strong> column. The host ID portion of the Akamai host name is the content to the left of the first period in the name. For Akamai HLS, HDS, and DASH targets that use the Akamai MSL 3 network, you must provide either a <strong>Destination Host</strong> or an <strong>Akamai Host ID</strong>. If the target uses the Akamai MSL 4 network, the <strong>Akamai Host ID</strong> isn't required.</p>
</div>
<div id="httpCupertinoPlaylistCountHelp" basicAkamaiHttpHLSView basicAkamaiHttpHLSEdit style="display:none">
	<h5>Playlist Count</h5>
	<p>The number of time-based Apple HLS chunks to maintain in the destination stream's playlist. The default value (<strong>0</strong>) means this application's associated live stream packetizer property (<strong>cupertinoPlaylistChunkCount</strong>) specifies the value.</p>
	<blockquote><strong>Note:</strong> For details on how to configure the live stream packetizer properties, see <a href="https://www.wowza.com/docs/how-to-configure-apple-hls-packetization-cupertinostreaming" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Configure Apple HLS packetization in Wowza Streaming Engine</a>.</blockquote>
</div>
<div id="httpSanJosePlaylistCountHelp" basicAkamaiHttpHDSView basicAkamaiHttpHDSEdit style="display:none">
	<h5>Playlist Count</h5>
	<p>The number of time-based Adobe HDS chunks to maintain in the destination stream's playlist. The default value (<strong>0</strong>) means this application's associated live stream packetizer property (<strong>sanjosePlaylistChunkCount</strong>) specifies the value.</p>
	<blockquote><strong>Note:</strong> For details on how to configure the live stream packetizer properties, see <a href="https://www.wowza.com/docs/how-to-configure-adobe-hds-packetization-sanjosestreaming" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Configure Adobe HDS packetization in Wowza Streaming Engine</a>.</blockquote>
</div>
<div id="httpDASHPlaylistCountHelp" basicAkamaiHttpDASHView basicAkamaiHttpDASHEdit style="display:none">
	<h5>Playlist Count</h5>
	<p>The number of time-based MPEG DASH chunks to maintain in the destination stream's playlist. The default value (<strong>0</strong>) means this application's associated live stream packetizer property (<strong>mpegdashPlaylistChunkCount</strong>) specifies the value.</p>
	<blockquote><strong>Note:</strong> For details on how to configure the live stream packetizer properties, see <a href="https://www.wowza.com/docs/how-to-configure-mpeg-dash-packetization-mpegdashstreaming" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Configure MPEG-DASH packetization in Wowza Streaming Engine</a>.</blockquote>
</div>
<div id="akamaiEventNameHelp" basicAkamaiHttpCommonView basicAkamaiHttpCommonEdit style="display:none">
	<h5>Akamai Event Name</h5>
	<p>The name of the live streaming event that you scheduled in the Event Scheduler in Luna Control Center for this stream.</p>
</div>
<div id="adaptiveGroupHelp" basicAkamaiHttpCommonView basicAkamaiHttpCommonEdit style="display:none">
	<h5>Adaptive Group</h5>
	<p>The name of an adaptive group to which this stream target belongs.</p>
</div>
<div id="akamaiDestinationServerHelp" basicAkamaiHttpCommonView basicAkamaiHttpCommonEdit style="display:none">
	<h5>Destination Server</h5>
	<p>The Akamai entry point that the source stream will be sent to. You can send the stream to the <strong>primary</strong> entry point, the <strong>backup</strong> entry point, or to both the primary and backup (<strong>redundant</strong>) entry points. If you select redundant entry points, a manifest or playlist is generated that has playback URLs for the primary and backup streams.</p>
</div>

<%-- Akamai HTTP HLS - Includes the Akamai HTTP HLS destination-profile --%>

<div id="cupertinoRenditionsHelp" basicAkamaiHttpHLSView basicAkamaiHttpHLSEdit style="display:none">
	<h5>Apple HLS Stream Renditions</h5>
	<p>The rendition types in the stream. <strong>Audio and video</strong> is selected by default because most streams will have a rendition that has audio and video. If your source stream only has audio or if the audio is in a rendition that's separate from the video, select <strong>Audio only</strong>.</p>
</div>


<%-- Akamai HTTP HDS - Includes the Akamai HTTP HDS destinations-profile --%>

<div id="sanjoseRepresentationIdHelp" basicAkamaiHttpHDSView basicAkamaiHttpHDSEdit style="display:none">
	<h5>Adobe HDS Representation ID</h5>
	<p>A unique alphanumeric identifier for the stream representation, which can be used to customize the name of the HDS stream-level manifest and bootstrap files and the <strong>bootstrapInfo</strong> ID and media URL values in the stream-level manifest. If not provided, the identifier is calculated from the bitrate of the stream (such as <strong>752kbps</strong>).</p>
</div>

<%-- Akamai HTTP MPEG DASH - Includes the Akamai HTTP MPEG DASH destinations-profile --%>

<div id="mpegdashVideoRepresentationIdHelp" basicAkamaiHttpDASHView basicAkamaiHttpDASHEdit style="display:none">
	<h5>MPEG-DASH Video Representation ID</h5>
	<p>A unique alphanumeric identifier for the stream's video component, which can be used to customize the <strong>id</strong> attribute of the <strong>Representation</strong> element in the MPEG-DASH MPD manifest. If not provided, the identifier is constructed using the bitrate, in kilobits per second, of the video bitstream (such as <strong>video_752kbps</strong>).</p>
</div>
<div id="mpegdashAudioRepresentationIdHelp" basicAkamaiHttpDASHView basicAkamaiHttpDASHEdit style="display:none">
	<h5>MPEG-DASH Audio Representation ID</h5>
	<p>A unique alphanumeric identifier for the stream's audio component, which can be used to customize the <strong>id</strong> attribute of the <strong>Representation</strong> element in the MPEG-DASH MPD manifest. If not provided, the identifier is constructed using the bitrate, in kilobits per second, of the audio bitstream (such as <strong>audio_752kbps</strong>).</p>
</div>

<%-- Wowza Streaming Cloud - Includes the Wowza Streaming Cloud destinations-profile --%>

<div id="wowzaStreamingCloudDestinationHelp" basicWowzaCloudDestinationServerView basicWowzaCloudDestinationServerEdit style="display:none">
	<h5>Destination Server</h5>
	<p>The destination entry point that the source stream will be sent to. You can send the stream to the <strong>primary</strong> entry point, the <strong>backup</strong> entry point, or to both the primary and backup (<strong>redundant</strong>) entry points.</p>
</div>

<div id="wowzaStreamingCloudAutoStartHelp" basicWowzaStreamingCloudViewtranscoder basicWowzaStreamingCloudEdittranscoder style="display:none">
	<h5>Auto Start</h5>
	<p>If the <Strong>Start Wowza Streaming Cloud service automatically</strong> check box is selected, Wowza Streaming Engine tries to start the transcoder in Wowza Streaming Cloud immediately and publish the source stream.  If it isn't selected, you must start the transcoder manually in the web-based Wowza Streaming Cloud manager before the source stream is published.</p>
</div>

<%-- Facebook - Includes only the Facebook destination/profile --%>

<div id="facebookTitleHelp" basicFacebookView basicFacebookEdit style="display:none">
	<h5>Title</h5>
	<p>The title of the live video post.</p>
</div>
<div id="facebookDescriptionHelp" basicFacebookView basicFacebookEdit style="display:none">
	<h5>Description</h5>
	<p>The description of the live video post.</p>
</div>
<div id="facebookContinuousLiveHelp" basicFacebookView basicFacebookEdit style="display:none">
    <h5>Continuous Live</h5>
    <p>If the <strong>Send a continuous live stream</strong> check box is selected, a stream of unlimited length is published to Facebook Live.</p>
	<blockquote><strong>Note:</strong> When a continuous live stream ends, the video post is unpublished from Facebook. Facebook doesn't convert continuous live streams to VOD assets.</blockquote>
</div>
<div id="facebook360ProjectionHelp" basicFacebookView basicFacebookEdit style="display:none">
    <h5>360 Video Projection</h5>
    <p>If your stream contains 360 (spherical) video, select the projection type. We recommend <strong>Equirectangular</strong>. If your stream isn't 360 video, select <strong>None</strong>.</p>
</div>
<div id="facebookUserNameConfigHelp" basicFacebookView style="display:none">
    <h5>Account Name</h5>
    <p>The name of the Facebook account associated with the stream target.</p>
</div>
<div id="facebookCurrentConfigHelp" basicFacebookView style="display:none">
	<h5>Current Video Destination</h5>
	<p>The Facebook destination that is currently configured.</p>
</div>
<div id="facebookEditConfigHelp" style="display:none">
	<h5>Video Destination</h5>
	<p>The type of Facebook location where you want to post the video.</p>
	<ul>
		<li><strong>My Timeline</strong>. Post directly to your Timeline.

		<li><strong>Page</strong>. Post to a Page you manage. In <strong>My Pages</strong>, select the Page you are posting to<!-- or that the event you're posting to is associated with-->.

		<li><strong>Group</strong>. Post to a group you manage. In <strong>My Groups</strong>, select the group you are posting to<!-- or that the event you're posting to is associated with.

		<li><strong>Event</strong>. Post to an event you are hosting. Select the <strong>Event Source</strong> that the event is associated with, and select the Page or Group when applicable. Then select the event in <strong>My Events</strong>.-->
	</ul>
	<blockquote><strong>Note:</strong> If you want to share on a Page or group<!--, or event--> that doesn't appear in the menus, you may not have permission to post to it. Check your Facebook account settings.</blockquote>
</div>
<div id="facebookPrivacyConfigHelp" style="display:none">
	<h5>Privacy</h5>
	<p>The privacy setting for the live video post to the user's timeline.</p>
</div>

