<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<c:set var="fileNameEmpty">
	<wmsform:getlocalestring page="startRecordingDialog" obj="baseName.empty"/>
</c:set>
<c:set var="fileNameError">
	<wmsform:getlocalestring page="common" obj="invalidFileName"/>
</c:set>
<c:set var="invalidEntry">
	<wmsform:getlocalestring page="startRecordingDialog" obj="baseName.invalid"/>
</c:set>
<c:set var="outputPathEmpty">
	<wmsform:getlocalestring page="startRecordingDialog" obj="outputPath.empty"/>
</c:set>
<c:set var="outputPathError">
	<wmsform:getlocalestring page="common" obj="invalidPathName"/>
</c:set>
<c:set var="fileVersionDelegateNameError">
	<wmsform:getlocalestring page="startRecordingDialog" obj="fileVersionDelegateName.empty"/>
</c:set>
<c:set var="fileTemplateEmpty">
	<wmsform:getlocalestring page="startRecordingDialog" obj="fileTemplate.empty"/>
</c:set>
<c:set var="segmentDurationSecondsMinimum">
	<wmsform:getlocalestring page="startRecordingDialog" obj="segmentDurationSeconds.minimum"/>
</c:set>
<c:set var="segmentDurationSecondsInvalid">
	<wmsform:getlocalestring page="startRecordingDialog" obj="segmentDurationSeconds.invalid"/>
</c:set>
<c:set var="segmentDurationMinutesInvalid">
	<wmsform:getlocalestring page="startRecordingDialog" obj="segmentDurationMinutes.invalid"/>
</c:set>
<c:set var="segmentDurationHoursInvalid">
	<wmsform:getlocalestring page="startRecordingDialog" obj="segmentDurationHours.invalid"/>
</c:set>
<c:set var="scheduleOptionEveryHour">
	<wmsform:getlocalestring page="startRecordingDialog" obj="scheduleOption.everyhour"/>
</c:set>
<c:set var="scheduleStringInvalid">
	<wmsform:getlocalestring page="startRecordingDialog" obj="segmentSchedule.invalid"/>
</c:set>
<c:set var="typeMismatch">
	<wmsform:getlocalestring page="typeMismatch" obj="int"/>
</c:set>
<c:set var="segmentSizeMinimum">
	<wmsform:getlocalestring page="startRecordingDialog" obj="segmentSize.minimum"/>
</c:set>
<c:set var="dialogErrors">
	<wmsform:getlocalestring page="startRecordingDialog" obj="dialogErrors"/>
</c:set>

<div id="startRecordingModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="startRecordingModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
		    <form:form method="post" commandName="formData" id="startRecordingForm"><fieldset>
	            <form:hidden path="vhost"/>
	            <form:hidden path="appType"/>
	            <form:hidden path="uiAppName"/>
	            <form:hidden path="instanceName"/>
	            <form:hidden path="streamName"/>
	            <form:hidden path="recorderName"/>
				<form:hidden path="segmentationType"/>
				<form:hidden path="moveFirstVideoFrameToZero"/>
				<div class="modal-header">
					<button type="button" class="close" onClick="javascript:startRecordingClose()">x</button>
					<h4><b><wmsform:getlocalestring page="startRecordingDialog" obj="titleRecord"/> <span id="startRecorderName"></span></b></h4>
				</div>
				<div class="modal-body" style="padding-top:5px">
					<div id="dialogError" class="col-md-12">
						<div class="alert alert-danger">
							<strong>${dialogErrors}</strong>
						</div>
					</div>
				    <div class="row" id="tabContent">
						<div class="col-md-12">
							<p id="pageText"></p>
							<ul class="nav nav-tabs" >
								<li id="recordTab" >
									<a href="javascript:showRecordTab()"><wmsform:getlocalestring page="startRecordingDialog" obj="titleRecord"/></a>
								</li>
								<li id="segmentationTab" >
									<a href="javascript:showSegmentationTab()"><wmsform:getlocalestring page="startRecordingDialog" obj="titleSegmentation"/></a>
								</li>
							</ul>
						</div>
					</div>
					<div id="recordingTabFields">
						<wmsform:editproperty page="startRecordingDialog" obj="baseFile" cssClass="form-control"/>
						<wmsform:editproperty page="startRecordingDialog" obj="outputPath" cssClass="form-control"/>
						<wmsform:editpropertyradiolist page="startRecordingDialog" obj="fileFormat"/>
						<b><wmsform:getlocalestring page="startRecordingDialog" obj="recordingOptionsTitle"/></b>
						<wmsform:editpropertycheckbox page="startRecordingDialog" obj="recordData"/>
						<wmsform:editpropertycheckbox page="startRecordingDialog" obj="startOnKeyFrame"/>
					</div>
					<div id="segmentationTabFields">
						<div id="segmentationTypeDiv">
							<wmsform:editpropertydropdown page="startRecordingDialog" obj="segmentationOption"/>
						</div>
						<div id="segmentByDuration">
							<label><wmsform:getlocalestring page="startRecordingDialog" obj="durationLabel"/></label>
							<table style="width:50%">
								<tr>
									<td align="center">
										<wmsform:editproperty page="startRecordingDialog" obj="durationHours"  cssClass="form-control" showTitle="no" inputFilter='integer'/>
									</td>
									<td style="vertical-align:top;padding-top:7px">:</td>
									<td align="center">
										<wmsform:editproperty page="startRecordingDialog" obj="durationMinutes"  cssClass="form-control" showTitle="no" inputFilter='integer'/>
									</td>
									<td style="vertical-align:top;padding-top:7px">:</td>
									<td align="center">
										<wmsform:editproperty page="startRecordingDialog" obj="durationSeconds"  cssClass="form-control" showTitle="no" inputFilter='integer'/>
									</td>
								</tr>
							</table>
							<div id="segmentDurationError" class='text-danger'></div>
						</div>

						<div id="segmentBySize">
							<wmsform:editproperty page="startRecordingDialog" obj="segmentSize"  cssClass="input-mini" inputFilter="^[0-9]{1,6}(\\\\.[0-9]{0,3})?$"/>
						</div>
						<div id="segmentBySchedule">
							<wmsform:editpropertyradiolist page="startRecordingDialog" obj="scheduleOption"/>
							<div class="indent1" style="margin-top:-10px">
								<wmsform:editproperty page="startRecordingDialog" obj="scheduleString" cssClass="form-control" showTitle="no"/>
							</div>
						</div>
						<div id="versioningOptionDropDown">
							<wmsform:editpropertydropdown page="startRecordingDialog" obj="option"/>
						</div>
						<div id="template">
							<wmsform:editproperty page="startRecordingDialog" obj="fileTemplate" cssClass="form-control"/>
						</div>
						<div id="delegate">
							<wmsform:editproperty page="startRecordingDialog" obj="fileVersionDelegateName" cssClass="form-control"/>
						</div>
					</div>
				</div>

				<div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:startRecordingClose()"/>
					<wmsform:buttonrecord  onClick="javascript:doRecord()"/>
				</div>
			</fieldset></form:form>
		</div>
	</div>
</div>
<script type="text/javascript">
var option;
var outputPath;
var baseFile;
var fileFormat;
var recordData;
var startOnKeyframe;
var fileTemplate;
var fileVersionDelegateName;
var segmentSize;
var scheduleType;
var recorderName;

loadData();
startRecordingLoad();

$(document).ready(function() {
	$('#segmentationOption').change(function() {
		segmentationOptionChanged();
	});

	$('#option').change(function() {
		optionChanged();
	});

	$('input[name="fileFormat"]').click(function() {
		fileFormatChanged();
	});

	$('input[name="scheduleOption"]').click(function() {
		scheduleOptionChanged();
	});
});

function loadData()
{
	segmentationType = "${requestScope.formData['segmentationType']}";
	segmentationOption = "${requestScope.formData['segmentationOption']}";
	recorderName = "${requestScope.formData['recorderName']}";
	option = "${requestScope.formData['option']}";
	fileFormat = "${requestScope.formData['fileFormat']}";
	recordData = "${requestScope.formData['recordData']}";
	startOnKeyFrame = "${requestScope.formData['startOnKeyFrame']}";
	outputPath = "${requestScope.formData['outputPath']}";
	baseFile = "${requestScope.formData['baseFile']}";
	fileTemplate = "${requestScope.formData['fileTemplate']}";
	fileVersionDelegateName = "${requestScope.formData['fileVersionDelegateName']}";

	durationHours = "${requestScope.formData['durationHours']}";
	durationMinutes = "${requestScope.formData['durationMinutes']}";
	durationSeconds = "${requestScope.formData['durationSeconds']}";
	segmentSize = ("${requestScope.formData['segmentSize']}")/1048576;
	scheduleType = "${scheduleOptionEveryHour}";
	scheduleString = "${requestScope.formData['scheduleString']}";
}

function startRecordingLoad()
{
	$('#startRecorderName').text(recorderName);
	$('#segmentationOption').val(segmentationOption);
	$('#segmentationType').val(segmentationType);
	loadRecordingFields();
	loadSegmentationFields();
	var recMode = $('#segmentationType').val();
	showRecordingTypeFields(recMode);
	showRecordTab();
	$('#dialogError').hide();

	// show Page
	$('#startRecordingModal').on("shown.bs.modal", function() {});
	$('#startRecordingModal').modal('show');
}

function startRecordingClose() {
	$('#startRecordingModal').modal('hide');
}

function doRecord() {
	if(validData())
	{
		var elem=$('input[name="scheduleOption"]:checked');
		var selected = elem.val();
		if (selected == "${scheduleOptionEveryHour}")
		{
			$('#scheduleString').val("0 * * * * *");
			$('#scheduleString').removeAttr('disabled');
		}

		$('#startRecordingModal').on('hidden.bs.modal', function() {
			postAJAXFormDstFormName('streamrecorder/startRecording.htm','returnPage=${returnPage}', 'mainContent','startRecordingForm');
		});
		startRecordingClose();
	}
}

function loadRecordingFields()
{
	var $radios = $('input:radio[name="fileFormat"]');
	$radios.filter('[value='+fileFormat+']').prop('checked', true);

	$('#recordData').val(recordData);
	$('#startOnKeyFrame').val(startOnKeyFrame);
	$('#outputPath').val(outputPath);
	$('#baseFile').val(baseFile);

	// clear warning messages
	$('#outputPathCtrlGroup').attr('class', 'form-group');
	$('#outputPathErrorMsg').html("");
	$('#outputPathErrorMsg').hide();

	$('#baseFileCtrlGroup').attr('class', 'form-group');
	$('#baseFileErrorMsg').html("");
	$('#baseFileErrorMsg').hide();
}

function showRecordingTypeFields(segmentationType)
{
	$('#segmentationType').val(segmentationType);

	if (segmentationType=='SegmentByDuration')
	{
		$('#segmentBySize').hide();
		$('#segmentBySchedule').hide();
		$('#segmentByDuration').show();
		$('#versioningOptionDropDown').hide();
		$('#segmentSizeErrorMsg').hide();
		$('#segmentDurationError').show();
		$('#scheduleStringErrorMsg').hide();
		$('#template').show();
		$('#delegate').show();
		$('#fileTemplate').prop("disabled", false);
	}
	else if (segmentationType=='SegmentBySize')
	{
		$('#segmentBySchedule').hide();
		$('#segmentBySize').show();
		$('#segmentByDuration').hide();
		$('#versioningOptionDropDown').hide();
		$('#segmentSizeErrorMsg').show();
		$('#segmentDurationError').hide();
		$('#scheduleStringErrorMsg').hide();
		$('#template').show();
		$('#delegate').show();
		$('#fileTemplate').prop("disabled", false);
	}
	else if (segmentationType=='SegmentBySchedule')
	{
		$('#segmentBySchedule').show();
		$('#segmentBySize').hide();
		$('#segmentByDuration').hide();
		$('#versioningOptionDropDown').hide();
		$('#segmentSizeErrorMsg').hide();
		$('#segmentDurationError').hide();
		$('#scheduleStringErrorMsg').show();
		$('#template').show();
		$('#delegate').show();
		// run this to grey out the advanced editproperty on tab switch
		scheduleOptionChanged();
		$('#fileTemplate').prop("disabled", false);
	}
	else
	{
		$('#fileTemplate').prop("disabled", true);
		$('#segmentBySchedule').hide();
		$('#segmentBySize').hide();
		$('#segmentByDuration').hide();
		$('#versioningOptionDropDown').show();
		$('#segmentSizeErrorMsg').hide();
		$('#segmentDurationError').hide();
		$('#scheduleStringErrorMsg').hide();
		if($("#option option:selected").val()=="Version existing file")
		{
			$('#template').show();
			$('#delegate').show();
		}
		else
		{
			$('#template').hide();
			$('#delegate').hide();
		}
	}
}

function showRecordTab()
{
	$('#segmentationTabFields').hide();
	$('#recordTab').addClass('active');
	$('#segmentationTab').removeClass();
	$('#recordingTabFields').show();
}

function loadSegmentationFields()
{
	$('#durationHours').val(durationHours);
	$('#durationMinutes').val(durationMinutes);
	$('#durationSeconds').val(durationSeconds);
	$('#segmentSize').val(segmentSize);
	$('#scheduleOption').val(scheduleType);

	segmentationOptionChanged();

	$('#option').val("Version existing file");
	$('#option').val(option);
	$('#fileTemplate').val(fileTemplate);
	$('#fileVersionDelegateName').val(fileVersionDelegateName);

	// clear warning messages
	$('#segmentSizeCtrlGroup').attr('class', 'form-group');
	$('#segmentSizeErrorMsg').html("");
	$('#segmentSizeErrorMsg').hide();
	$('#durationHoursCtrlGroup').attr('class', 'form-group');
	$('#durationMinutesCtrlGroup').attr('class', 'form-group');
	$('#durationSecondsCtrlGroup').attr('class', 'form-group');
	$('#segmentDurationError').html("");
	$('#segmentDurationError').hide;
	$('#scheduleStringCtrlGroup').attr('class', 'form-group');
	$('#scheduleStringErrorMsg').html("");
	$('#scheduleStringErrorMsg').hide;
	$('#fileTemplateCtrlGroup').attr('class', 'form-group');
	$('#fileTemplateErrorMsg').html("");
	$('#baseFileErrorMsg').hide();
	$('#fileVersionDelegateNameCtrlGroup').attr('class', 'form-group');
	$('#fileVersionDelegateNameErrorMsg').html("");
	$('#fileVersionDelegateNameErrorMsg').hide();
}

function showSegmentationTab()
{
	$('#recordingTabFields').hide();
	$('#segmentationTab').addClass('active');
	$('#recordTab').removeClass();
	$('#segmentationTabFields').show();
}

function optionChanged()
{
	var fmode = $("#option option:selected").val();

	if(fmode=="Version existing file")
	{
		$('#template').show();
		$('#delegate').show();
	} else  // "Append to existing file" || "Overwrite existing file"
	{
		$('#template').hide();
		$('#delegate').hide();
	}
}

function segmentationOptionChanged()
{
	var fmode = $("#segmentationOption option:selected").val();
	var recOption='None';
	if (fmode==<wmsform:getlocalestring page="startRecordingDialog" obj="segmentationTypeDuration" quotes="true"/>)
	{
		recOption='SegmentByDuration';
	}
	else if (fmode==<wmsform:getlocalestring page="startRecordingDialog" obj="segmentationTypeSize" quotes="true"/>)
	{
		recOption='SegmentBySize';
	}
	else if (fmode==<wmsform:getlocalestring page="startRecordingDialog" obj="segmentationTypeSchedule" quotes="true"/>)
	{
		recOption='SegmentBySchedule';
	}
	showRecordingTypeFields(recOption);
}

function fileFormatChanged()
{
	var filename = $("#baseFile").val();
	var elem=$('input[name="fileFormat"]:checked');
	var ext = elem.val();
	var file = filename;
	var pos = 0;

	pos = filename.lastIndexOf('.');

	if (pos == -1 )
	{
	    file = filename + "." + ext.toLowerCase();
	}
	else
	{
		file = filename.substr(0, pos+1) + ext.toLowerCase();
	}

	$('#baseFile').val(file);
}

function scheduleOptionChanged()
{
	var elem=$('input[name="scheduleOption"]:checked');
	var selected = elem.val();

	$('#scheduleStringCtrlGroup').attr('class', 'form-group');
	$('#scheduleStringErrorMsg').html("");
	$('#scheduleStringErrorMsg').hide();

	if (selected == "${scheduleOptionEveryHour}")
	{
		$('#scheduleString').val('0 * * * * *');
		$('#scheduleString').attr('disabled', 'disabled');
	}
	else
	{
		$('#scheduleString').removeAttr('disabled');
		$('#scheduleString').val(scheduleString);
	}
}

// We can not use include or contains for web browser compatibility
function shimContains(main,match) {
	var result = main.lastIndexOf(match);
	return result;
}

function validData()
{
	var segmentationType = $('#segmentationType').val();
	var ok=true;

	$("#outputPath").val(fixFilePathSlashes($("#outputPath").val()));
	var file = $("#baseFile").val();
	var path = $("#outputPath").val();

	// clear warning messages
	$('#outputPathCtrlGroup').attr('class', 'form-group');
	$('#outputPathErrorMsg').html("");
	$('#outputPathErrorMsg').hide();

	$('#baseFileCtrlGroup').attr('class', 'form-group');
	$('#baseFileErrorMsg').html("");
	$('#baseFileErrorMsg').hide();

	$('#segmentSizeCtrlGroup').attr('class', 'form-group');
	$('#segmentSizeErrorMsg').html("");
	$('#segmentSizeErrorMsg').hide();

	$('#durationHoursCtrlGroup').attr('class', 'form-group');
	$('#durationMinutesCtrlGroup').attr('class', 'form-group');
	$('#durationSecondsCtrlGroup').attr('class', 'form-group');
	$('#segmentDurationError').html("");
	$('#segmentDurationError').hide;

	$('#scheduleStringCtrlGroup').attr('class', 'form-group');
	$('#scheduleStringErrorMsg').html("");
	$('#scheduleStringErrorMsg').hide;

	$('#fileTemplateCtrlGroup').attr('class', 'form-group');
	$('#fileTemplateErrorMsg').html("");
	$('#fileTemplateErrorMsg').hide;

	$('#fileVersionDelegateNameCtrlGroup').attr('class', 'form-group');
	$('#fileVersionDelegateNameErrorMsg').html("");
	$('#fileVersionDelegateNameErrorMsg').hide();




	if(file =="")
	{
		$('#baseFileCtrlGroup').attr('class', 'form-group has-error');
		$('#baseFileErrorMsg').html("${fileNameEmpty}");
		$('#baseFileErrorMsg').show();
		ok=false;
	}
	if ( shimContains(file,"\${BaseFileName}") >=0 )
	{
		$('#baseFileCtrlGroup').attr('class', 'form-group has-error');
		$('#baseFileErrorMsg').html("${invalidEntry}");
		$('#baseFileErrorMsg').show();
		ok=false;
	}
	if(path =="")
	{
		$('#outputPathCtrlGroup').attr('class', 'form-group has-error');
		$('#outputPathErrorMsg').html("${outputPathEmpty}");
		$('#outputPathErrorMsg').show();
		ok=false;
	}
 	if(!isValidFileName(file.trim()))
	{
		$('#baseFileCtrlGroup').attr('class', 'form-group has-error');
		$('#baseFileErrorMsg').html("${fileNameError}");
		$('#baseFileErrorMsg').show();
		ok=false;
	}

	if(!isValidPath(path.trim()))
	{
		$('#outputPathCtrlGroup').attr('class', 'form-group has-error');
		$('#outputPathErrorMsg').html("${outputPathError}");
		$('#outputPathErrorMsg').show();
		ok=false;
	}
	if (segmentationType=='SegmentByDuration')
	{
		var hrs = parseInt($('#durationHours').val());
		var min = parseInt($('#durationMinutes').val());
		var sec = parseInt($('#durationSeconds').val());

		$('#durationHoursCtrlGroup').attr('class', 'form-group');
		$('#durationMinutesCtrlGroup').attr('class', 'form-group');
		$('#durationSecondsCtrlGroup').attr('class', 'form-group');

		if(isNaN(hrs))
		{
			$('#durationHoursCtrlGroup').attr('class', 'form-group has-error');
			$('#segmentDurationError').html("${typeMismatch}");
			$('#segmentDurationError').show();
			ok=false;
		}
		else if(isNaN(min))
		{
			$('#durationMinutesCtrlGroup').attr('class', 'form-group has-error');
			$('#segmentDurationError').html("${typeMismatch}");
			$('#segmentDurationError').show();
			ok=false;
		}
		else if(isNaN(sec))
		{
			$('#durationSecondsCtrlGroup').attr('class', 'form-group has-error');
			$('#segmentDurationError').html("${typeMismatch}");
			$('#segmentDurationError').show();
			ok=false;
		}
		else if((hrs < 0) || (hrs > 8760))
		{
			$('#durationHoursCtrlGroup').attr('class', 'form-group has-error');
			$('#segmentDurationError').html("${segmentDurationHoursInvalid}");
			$('#segmentDurationError').show();
			ok=false;
		}
		else if((min < 0) || (min > 59))
		{
			$('#durationMinutesCtrlGroup').attr('class', 'form-group has-error');
			$('#segmentDurationError').html("${segmentDurationMinutesInvalid}");
			$('#segmentDurationError').show();
			ok=false;
		}
		else if(((hrs > 0) && (min > 0) && (sec < 0)) || (sec > 59))
		{
			$('#durationSecondsCtrlGroup').attr('class', 'form-group has-error');
			$('#segmentDurationError').html("${segmentDurationSecondsInvalid}");
			$('#segmentDurationError').show();
			ok=false;
		}
		else if ((hrs == 0) && (min == 0) && (sec < 10))
		{
			$('#durationSecondsCtrlGroup').attr('class', 'form-group has-error');
			$('#segmentDurationError').html("${segmentDurationSecondsMinimum}");
			$('#segmentDurationError').show();
			ok=false;
		}
	}
	else if (segmentationType=='SegmentBySize')
	{
		var size=$('#segmentSize').val();
		if (($('#segmentSize').val()).charAt(0)==".")
		{
			size = parseInt("0"+($('#segmentSize').val()), 10);
		}
		else
		{
			size = parseInt($('#segmentSize').val(), 10);
		}
		$('#segmentSizeCtrlGroup').attr('class', 'form-group');
		$('#segmentSizeErrorMsg').html("");
		$('#segmentSizeErrorMsg').show();
		if(isNaN(size))
		{
			$('#segmentSizeCtrlGroup').attr('class', 'form-group has-error');
			$('#segmentSizeErrorMsg').html("${typeMismatch}");
			$('#segmentSizeErrorMsg').show();
			ok=false;
		}
		else if(size < 1)
		{
			$('#segmentSizeCtrlGroup').attr('class', 'form-group has-error');
			$('#segmentSizeErrorMsg').html("${segmentSizeMinimum}");
			$('#segmentSizeErrorMsg').show();
			ok=false;
		}
	}
	else if (segmentationType=='SegmentBySchedule')
	{
		var elem=$('input[name="scheduleOption"]:checked');
		var selected = elem.val();
		var crontab = $('#scheduleString').val().trim();

		if (selected=="${scheduleOptionEveryHour}")
		{
			$('#scheduleString').removeAttr('disabled');
			$('#scheduleString').val("0 0 * * * *");
		}
		else
		{
			if (crontab=="")
			{
				$('#scheduleStringCtrlGroup').attr('class', 'form-group has-error');
				$('#scheduleStringErrorMsg').html("${scheduleStringInvalid}");
				$('#scheduleStringErrorMsg').show();
				ok=false;
			}
			else
			{
				var checkCronRegex = new RegExp("^[0-9,*/]{1,36}\\\s[0-9,*/]{1,36}\\\s[0-9,*/]{1,36}\\\s[0-9,*/]{1,36}\\\s[0-9,*/]{1,36}\\\s[0-9,*/]{1,36}$");
				if (!checkCronRegex.test(crontab) )
				{
					$('#scheduleStringCtrlGroup').attr('class', 'form-group has-error');
					$('#scheduleStringErrorMsg').html("${scheduleStringInvalid}");
					$('#scheduleStringErrorMsg').show();
					ok=false;
				}
			}
		}
	}

	// validate file template and delegate
	var option = $('#option option:selected').val();
	if (option=='Version existing file')
 	{
		$("#fileTemplate").val(fixFilePathSlashes($("#fileTemplate").val()));
 		var template = $('#fileTemplate').val();
 		var delegate = $('#fileVersionDelegateName').val();

 		if ($('#fileVersionDelegateName').val()=="")
 		{
 			$('#fileVersionDelegateNameCtrlGroup').attr('class', 'form-group has-error');
			$('#fileVersionDelegateNameErrorMsg').html("${fileVersionDelegateNameError}");
			$('#fileVersionDelegateNameErrorMsg').show();
			ok=false;
 		}
 		if (template=="")
 		{
 			$('#fileTemplateCtrlGroup').attr('class', 'form-group has-error');
			$('#fileTemplateErrorMsg').html("${fileTemplateEmpty}");
			$('#fileTemplateErrorMsg').show();
			ok=false;
 		}
 		if (!isValidPath(template.trim()))
 		{
 			$('#fileTemplateCtrlGroup').attr('class', 'form-group has-error');
			$('#fileTemplateErrorMsg').html("${fileNameError}");
			$('#fileTemplateErrorMsg').show();
			ok=false;
 		}
 	}

	if (!ok)
	{
		$('#dialogError').show();
	}
	else
	{
		$('#dialogError').hide();
	}

	return ok;
}

</script>