<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<c:choose>
	<c:when test="${appType=='liveedge'}">
	<h5>Origin SecureToken Shared Secret</h5>
	<p>Secure the connection between the origin server(s) and this edge server by entering the SecureToken shared secret that's configured for the origin server(s). The shared secret must be the same on the primary origin server and on the secondary (backup) origin server.</p>
	</c:when>
	<c:otherwise>
	<h5>RTMP Sources</h5>
	<p>Use these options to manage source connections to this application over the RTMP protocol (for example, from RTMP-based encoders). To help secure the connection, the <strong>Require password authentication</strong> option is selected by default. (You can specify user names and passwords for RTMP-based sources on the <a href="javascript:lastServerMC='serverpublishers';loadAjaxSideBar('SB_Server.html','')">Source Authentication page</a>.)</p>

	<p>Select <strong>Open</strong> to enable RTMP-based sources to connect without requiring authentication or select <strong>RTMP publishing not allowed</strong> to block all connections from RTMP-based sources.</p>

	<h5>RTSP Sources</h5>
	<p>Use these options to manage source connections to this application over the RTSP/RTP protocol. These options apply to encoders that initiate connections to the application using the RTSP Announce method. To help secure the connection, the <strong>Require password authentication</strong> option is selected by default. (You can specify user names and passwords for RTSP-based sources on the <a href="javascript:lastServerMC='serverpublishers';loadAjaxSideBar('SB_Server.html','')">Source Authentication page</a>.)</p>

	<p>Select <strong>Open</strong> to enable RTSP-based sources to connect without requiring authentication or select <strong>RTSP publishing not allowed</strong> to block all connections from RTSP-based sources.</p>
		
	<c:if test="${appType=='live' or appType=='liveedge' or appType=='livehttporigin'}">
	<h5>Client Restrictions</h5>
	<p>To manage source connections from live sources at specific IP addresses, select one of the following options:</p>
		<ul>
			<li>To allow connections from specific IP addresses to bypass authentication, select <strong>Only allow publishing from the following IP addresses</strong> and then enter the allowed IP addresses as a comma-separated list in the box. Connections from all other IP addresses must pass authentication.
			<li>To prevent connections from specific IP addresses, select <strong>Do NOT allow publishing from the following IP addresses</strong> and then enter the restricted IP addresses as a comma-separated list in the box. Connections from all other IP addresses must pass authentication.
		</ul>
	<blockquote><strong>Note:</strong> Live sources at specific IP addresses that are allowed to connect must provide a user name and password if the <strong>Require password authentication</strong> option is selected.</blockquote>
	</c:if>
		
	<c:if test="${appType=='live' or appType=='liveedge' or appType=='livehttporigin'}">
	<h5>Duplicate Stream Names</h5>
	<p>If a stream is published to this application and a connection is made to publish a new stream with the same stream name, you can select this option to prevent the new stream from being published. Otherwise, clients that were playing the initial stream will play the new stream after it's published.</p>
	</c:if>
		
	<h5>Flash Version String</h5>
	<p>When connecting to live applications, RTMP-based sources provide a Flash version string value (sometimes called a <em>user agent</em>) in the connection header. This value is preset by the encoder or camera manufacturer. Wowza Streaming Engine uses this value to determine that the connection is from a live source and then applies any configured source security settings for live sources to the connection.</p>

	<p>Wowza Streaming Engine automatically supports many Flash version string values and no further configuration is required. If your live source uses a different value, append it to the pipe-separated list of values in the <strong>Flash Version String</strong> box.</p>

	<blockquote><strong>Note:</strong> This setting doesn't apply to client players that connect to Wowza Streaming Engine to play RTMP-based streams.</blockquote>
	</c:otherwise>
</c:choose>