<%@ include file="/WEB-INF/jsp/taglibs.jsp"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<c:set var="encoderName">teradek</c:set>

<fieldset>
	<form:hidden path="version"/>
	<form:hidden path="vhost"/>
	<form:hidden path="uiAppName" />
	<form:hidden path="uiAppType"/>
	<form:hidden path="section" />
	<form:hidden path="action" />
	<form:hidden path="publishUserOptions" />
</fieldset>

<p><a href="javascript:loadApplication('${wmsutil:escapeHtml(appName)}','${appType}','publishers')"><i class="fa fa-arrow-left"></i><wmsform:getlocalestring page="appconfig.publishers" obj="incoming.returnlink" /></a></p>

<div class="row">
	<div class="col-md-12">
		<div class="media">
			<img src="img/teradek-logo.png" />
			<div class="media-body">
				<p class="lead">
					<wmsform:getlocalestring page="appconfig.publishers" obj="encoders.teradek.description" />
				</p>
			</div>
		</div>
	</div>
</div>
<div class="row">
	<ol>
		<li><h5><b><wmsform:getlocalestring page="appconfig.publishers" obj="encoders.teradek.step1" /></b></h5>
			<div class="row">
				<div class="col-md-12">
					<wmsform:editproperty page="appconfig.publishers.encoders" obj="hostServer" cssSize="col-md-4" />
					<wmsform:editproperty page="appconfig.publishers.encoders" obj="hostPort" cssSize="col-md-4" />
					<wmsform:editproperty page="appconfig.publishers.encoders" obj="streamName" cssSize="col-md-4" />
					<wmsform:editpropertydropdown obj="publishUser" page="appconfig.publishers.encoders" cssSize="col-md-4" />
				</div>
			</div></li>
		<li><h5><b><wmsform:getlocalestring page="appconfig.publishers" obj="encoders.teradek.step2" /></b></h5>
			<div class="row">
				<div class="col-md-12">
					<wmsform:button page="appconfig.publishers.encoders.teradek" obj="generateLink" icon="fa fa-cog"
						onClick="javascript:validateFormData()" />
				</div>
			</div>
			<div id="shortUrlError" style="display: none;"><wmsform:getlocalestring page="appconfig.publishers" obj="encoders.teradek.errorGeneratingUrl" /></div>
		</li>
		<li class="shortResponse" style="display: none;"><h5><b><wmsform:getlocalestring page="appconfig.publishers"
				obj="encoders.teradek.step3" /></b></h5>
			<div class="row">
				<div class="col-md-12">
					<div class="row">
						<div class="input-group col-md-7"><wmsform:getlocalestring page="appconfig.publishers" obj="encoders.teradek.step3a" /><br/>
							<input class="form-control" name="shortUrl" id="shortUrl" type="text" placeholder="short url">
						</div>
					</div>
					<div class="row">
						<div class="col-md-7" style="padding-top: 20px; padding-bottom: 20px;">
							<center><wmsform:getlocalestring page="appconfig.publishers" obj="encoders.teradek.step3b" /></center>
						</div>
					</div>
					<div class="row">
						<div class="col-md-7">
							<wmsform:getlocalestring page="appconfig.publishers" obj="encoders.teradek.emailForm" />
						</div>
					</div>
					<div class="row">
						<div class="input-group col-md-7">
							<textarea class="form-control" name="emailAddress" id="shortemailAddress" placeholder="Email Addresses"></textarea>
						</div>
					</div>
					<div class="row" style="padding-top: 5px;">
						<div class="input-group col-md-7">
							<span class="input-group-btn"><button class="btn btn-default" name="emailLink" id="emailLink"
									onClick="javascript:sendTeradekEmail(event);">
									<i class="fa fa-envelope"></i>
									<fmt:message key='common.emailGroup' />
								</button></span>
						</div>
					</div>
				</div>
			</div></li>
		<li class="shortResponse" style="display: none;"><h5><b><wmsform:getlocalestring page="appconfig.publishers"
				obj="encoders.teradek.step4" /></b></h5>
			<div class="row">
				<div class="col-md-12">
					<wmsform:getlocalestring page="appconfig.publishers" obj="encoders.teradek.step4a" />
				</div>
			</div></li>
	</ol>
</div>
<script>
	$(document).ready(function() {
		if ( $("#action").val() == "jspAction" )
		{
			$('#action').val("false");
			getTeradekUrl();
		}
	});
	function validateFormData() {
		postAJAXForm('applications/${appType}/publishers/encoder/validateEncoder.htm','appName=${wmsutil:urlEncode(appName)}');

		//we are in a form:form where method is post (MainAppView.jsp). prevent that.
		//event.preventDefault ? event.preventDefault() : event.returnValue = false;
	}
	function getTeradekUrl() {
		var page = "applications/${appType}/${appSection}/teradek.json";
		var params = { "streamName" : encodeURIComponent($('#streamName').val()), //IE doesn't like streamName.value
			"vhost" : "${vhost}",
			"appName" : "${appName}",
			"publishUser" : encodeURIComponent($("select[id='publishUser'] option:selected").val()),
			"hostServer" : encodeURIComponent($('#hostServer').val()),
			"hostPort" : encodeURIComponent($('#hostPort').val())
		};
		document.body.style.cursor = "wait";
		$.ajax({ type : "POST",
		url : page,
		data : params,
		contentType : "application/x-www-form-urlencoded;charset=UTF-8",
		success : function(data) {
			$("#shortUrlError").hide();
			if (data instanceof String && data.substring(0, redirectLoginString.length) == redirectLoginString) {
				document.location = "login.htm" + location.hash;
			} else {
				if (data.statusCode && data.statusCode >= 200 && data.statusCode < 300) {
					$("#shortUrl").val(data.url);
					$("#shortUrl").focus(function() {
						this.select();
					});
					$(".shortResponse").show();
					setTimeout(function() {
						$("#shortUrl").focus();
					}, 0);
				} else {
					$("#shortUrlError").show();
				}
			}
		},
		error : function(jqXHR, textStatus, thrownError) {
			document.body.style.cursor = "default";
			displayError(jqXHR, textStatus, thrownError, page, dst);
		},
		complete : function(jqXHR, textStatus) {
			document.body.style.cursor = "default";
		}
		});
		return false;
	}
	<c:set var="emailBody"><wmsform:getlocalestring page="appconfig.publishers" obj="encoders.teradek.emailBody" /></c:set>
	<c:set var="emailSubject"><wmsform:getlocalestring page="appconfig.publishers" obj="encoders.teradek.emailSubject" /></c:set>
	function sendTeradekEmail(event) {
		//if (!event) var event = window.event;// for IE
		event.preventDefault ? event.preventDefault() : event.returnValue = false;
		var emailAddress = encodeURIComponent($("#shortemailAddress").val().replace(/\n/g, ','));
		var emailBody = "${emailBody} \r\n";
		emailBody += $("#shortUrl").val();
		emailBody += "\r\n\r\n";
		location.href = "mailto:" + emailAddress + "?subject=" + encodeURIComponent("${emailSubject}") + "&body="
				+ encodeURIComponent(emailBody);
	}
</script>
