<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<wmsform:setpagetitle page="publishersSony"/>
<wmsdialog:pantiltzoom page="publishersSony"/>

<c:set var="queryParam">
	appName=${wmsutil:urlEncode(appName)}&vhost=${wmsutil:urlEncode(vhost)}
</c:set>

<p><a href="javascript:returnStreamFile()"><i class="fa fa-arrow-left"></i><wmsform:getlocalestring page="appconfig.publishers" obj="incoming.returnlink" /></a></p>
<p><wmsform:getlocalestring page="common" obj="requiredField"/></p>

<re:mark>hidden attributes are added to query params so don't include them on AJAX calls</re:mark>
<fieldset>
	<form:hidden path="vhost" />
	<form:hidden path="uiAppName" />
	<form:hidden path="uiAppType" />
	<form:hidden path="instanceName"/>
	<form:hidden path="section" />
	<form:hidden path="version"/>
	<form:hidden path="driverName" value="Sony"/>
	<form:hidden path="ptzEnabled" value="true"/>
</fieldset>

<div class="row">
	<div class="col-md-12">
		<%-- <div class="row">
			<wmsform:pageerror/>
			<wmsform:pagewarning/>
			<wmsform:pageinformation/>
		</div>
		<wmsform:errors path="errorMessage" cssClass="alert alert-danger"/>
		<div id="encoder.warnings" class="alert alert-warning" style="display:none"><button type="button" class="close" data-dismiss="alert">&times;</button></div> --%>
		<div class="media">
			<!-- removed. Sony's requirement. <img src="img/sony-logo.png" /> -->
			<div class="media-body">
				<p class="h2 cite">
					Sony<br />
				</p>
				<p class="lead">
					<wmsform:getlocalestring page="appconfig.publishers.encoders.sony" obj="description" />
				</p>
			</div>
		</div>
	</div>
</div>


<div class="row">
	<div class="col-md-12">
		<wmsform:editproperty page="appconfig.publishers.encoders.sony" obj="publishersStreamFileName" required="true" />
		<div id="publishersStreamFileNameWarnings" class="alert alert-danger"></div>

		<wmsform:editproperty page="appconfig.publishers.encoders.sony" obj="cameraIpAddress" required="true" />
		<wmsform:editproperty page="appconfig.publishers.encoders.sony" obj="cameraUsername" required="true"/>
		<wmsform:editproperty page="appconfig.publishers.encoders.sony" obj="cameraPassword" inputType="password" required="true"/>
		<wmsform:editproperty page="appconfig.publishers.encoders.sony" obj="cameraPassword2" inputType="password" required="true"/>
		<br/>
		<wmsform:buttonprimary page="appconfig.publishers.encoders.sony" obj="CreateConnectionRTSP" onClick="javascript:createConnection()" icon="fa fa-video-camera" />
		<br />
		<br />
		<b><wmsform:getlocalestring page="appconfig.publishers.encoders.sony" obj="configureEncoder" /></b>
		<br />
		<div class="container">
			<wmsform:getlocalestring page="appconfig.publishers.encoders.sony" obj="configureEncoder2" />
		</div>
	</div>
</div>

<c:set var="dupStreamFileNameError">
	<wmsform:getlocalestring page="common" obj="StreamFileName.dup"/>
</c:set>
<c:set var="blankNameError">
	<wmsform:getlocalestring page="common" obj="emptyField"/>
</c:set>
<c:set var="invalidNameError">
	<wmsform:getlocalestring page="common" obj="invalidFileName"/>
</c:set>
<c:set var="invalidNameLengthError">
	<wmsform:getlocalestring page="common" obj="invalidFileNameLength"/>
</c:set>
<c:set var="notANumberError">
	<wmsform:getlocalestring page="common" obj="invalidNumber"/>
</c:set>
<c:set var="passwordMisMatch">
	<wmsform:getlocalestring page="common" obj="passwordMisMatch"/>
</c:set>

<script>
//default page layout
$(document).ready(function() {
	$('#publishersStreamFileNameWarnings').hide();
	$('#cameraIpAddress').removeAttr('readonly');
	$('#CreateConnectionRTSP').removeClass('disabled');
});

function returnStreamFile() 
{
	loadApplication('${wmsutil:escapeHtml(appName)}','${appType}','publishers');
}

function createConnection() 
{
	$('#publishersStreamFileNameErrorMsg').hide();
	$('#cameraIpAddressErrorMsg').hide();
	$('#cameraUsernameErrorMsg').hide();
	$('#cameraPasswordErrorMsg').hide();
	$('#cameraPassword2ErrorMsg').hide();

	postAJAXForm("applications/${appType}/publishers/encoder/Sony.htm",'appType=${appType}&appName=${wmsutil:urlEncode(appName)}');
}
</script>
