<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>

<h4>About Wowza nDVR</h4>
<p>DVR playback support in Wowza Streaming Engine is enabled by Wowza nDVR. This feature enables you to record a live stream while simultaneously enabling viewers that join the live stream in-progress to rewind to the beginning of the live stream (or rewind within the part of the stream that you specify) and then use DVR playback controls in their player to watch the stream from that point forward. For more information, see the our articles on <a href="https://www.wowza.com/docs/wowza-ndvr" target="_blank"><i class="fa fa-external-link"></i>&nbsp;nDVR</a>.

<blockquote><strong>Notes:</strong><br />Wowza nDVR supports HTTP playback of recorded streams using the Apple HLS, Adobe HDS, and Microsoft Smooth Streaming streaming protocols. To use nDVR, you must enable at least one of these <strong>Playback Types</strong> on the application's <strong>Setup</strong> tab.<br /><br />If you purchased a license for Wowza Streaming Engine before January&nbsp;1,&nbsp;2015, contact <a href="mailto:sales@wowza.com">sales@wowza.com</a> to learn more about how to license Wowza nDVR.</blockquote>

<c:if test="${appType=='live' or appType=='livehttporigin'}">
<h5>DVR Store Directory</h5>
<p>Defines where recordings for live streams are stored on the server for DVR playback. The directory path value can't contain less-than (&lt;), greater-than (&gt;), quotation (&#39; and &quot;), backslash (&#92;), pipe (&#124;), question mark (&#63;), and asterisk (&#42;) characters. For more information, see <a href="https://www.wowza.com/docs/wowza-ndvr-quick-start-guide#contentStorage" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Content storage</a>.</p>
</c:if>

<c:if test="${appType=='live' or appType=='livehttporigin'}">
<h5>Streaming Options</h5>
<p>Specifies how an incoming live stream can be played back by indicating whether the <strong>?DVR</strong> query parameter must be appended to playback URLs.</p>

<p>To specify that a live stream can be played with or without the DVR playback controls in a player, select <strong>Live and DVR streaming</strong>. This option means that the live stream is available for playback with or without the <strong>?DVR</strong> query parameter appended to playback URLs. If <strong>?DVR</strong> isn't appended to the playback URL, the live stream can still be played but DVR playback isn't supported.</p>

<p>To specify that a live stream can only be played using the DVR playback controls in a player, select <strong>DVR streaming only</strong>. This option means that the <strong>?DVR</strong> query parameter must be appended to playback URLs.</p>
</c:if>

<c:if test="${appType=='live' or appType=='livehttporigin'}">
<h5>Start Recording on Startup</h5>
<p>Enables you to automatically start recording a live stream that's published to the server for DVR.</p>
</c:if>

<c:if test="${appType=='live' or appType=='livehttporigin'}">
<h5>Archive Method</h5>
<p>Defines what to do with a recording if a new stream with the same stream name is published to this application. The default option (<strong>append</strong>) appends the new stream to the existing recording and is best to use as a failsafe mechanism to account for disruptions in the current live stream (such as encoders restarting). The <strong>delete</strong> option deletes the previous recording and starts a new one. The <strong>version</strong> option starts recording the new stream to a new folder in the DVR store.</p>
</c:if>

<c:if test="${appType=='live' or appType=='livehttporigin'}">
<h5>DVR Window Duration</h5>
<p>Specifies the amount of recorded material in the DVR store that's available for DVR playback.</p>
<ul>
	<li>To make the entire recording available for playback, select <strong>All material available</strong>. This option enables viewers who join the live stream in-progress to rewind and watch the stream from the beginning. This option also preserves the live stream recording after the stream ends.
	<li>To make only part of the live stream available for playback, select <strong>Use window duration</strong> and then specify the duration in <em>Hours</em>:<em>Minutes</em>:<em>Seconds</em>. The minimum supported duration value is <strong>60</strong>&nbsp;seconds. This option enables viewers who join the live stream in-progress to rewind the stream for the duration that you specify and watch from that point forward. The duration window is a "floating window" that always ends at the current live point. Recorded data that falls outside this window is purged from the DVR store.
</ul>

<p>You can record up to 30&nbsp;hours of material for DVR playback; however, you may encounter performance and playback issues if you make longer durations of material available for playback. For best practices guidance, see <a href="https://www.wowza.com/docs/wowza-ndvr-quick-start-guide#recordingLength" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Recording length</a>.</p>
</c:if>

<c:if test="${appType=='liveedge'}">
<h5>Media Cache</h5>
<p>Click the <strong>Configure Media Cache</strong> button to set up the Media Cache read-through caching mechanism to cache DVR chunks on this edge server in a multiple-server configuration. Then click <strong>Edit</strong> and select <strong>Use Media Cache</strong> to turn on Media Cache read-through caching. For more information, see <a href="https://www.wowza.com/docs/how-to-configure-mediacache-for-wowza-ndvr" target="_blank"><i class="fa fa-external-link"></i>&nbsp;Configure Wowza Streaming Engine Media Cache for Wowza nDVR</a>.</p>

<blockquote><strong>Note:</strong> You must set up an origin server that delivers the required playlist and audio/video chunks to this edge server. You can do this by configuring nDVR for a live origin application on the origin server. To connect this edge server to the origin server, specify the <strong>Primary Origin URL</strong> of the live origin application on the live edge application page settings.</blockquote>
</c:if>
