<%@ include file="/WEB-INF/jsp/taglibs.jsp" %>
<c:set var="queryParam">
	appName=${wmsutil:urlEncode(appName)}&vhost=${wmsutil:urlEncode(vhost)}
</c:set>
<wmsform:setpagetitle page="appconfig" appName="${appName}"/>
<c:choose>
	<c:when test="${appType=='unknown'}">
		<div class="col-md-12">
			<div class="alert alert-warning">
				<wmsform:getlocalestring page="appconfig" obj="unknown.header"/>
			</div>
		</div>
	</c:when>
	<c:otherwise>
		<div id="mainContent1" class="col-md-8 main-content">
        	<wmsform:rightrailhideshow/>
		    <div id="view.main.generic.warnings" class="alert alert-warning with-right-rail" style="display:none"></div>
   			<p>
   				<wmsform:getlocalestring page="appconfig" obj="${appType}.header" defaultStr=" "/>
				<a onclick="javascript:loadApplication('${appName}','${appType}','publishers')">
					<wmsform:getlocalestring page="appconfig" obj="${appType}.link" defaultStr=" "/>
				</a>
   			</p>
			<sec:authorize access="hasAnyRole('admin')">
				<p><wmsform:buttonedit onClick="javascript:loadAjaxMainContent('applications/${appType}/main/edit.htm','${queryParam}')"/></p>
            </sec:authorize>
			<wmsform:viewproperty page="appconfig" obj="description" showEmptyString="-Not Set-"/>
			<label class="control-label"><wmsform:getlocalestring page="appconfig" obj="playbackTypes"/></label>
			<c:if test="${appType=='live' or appType=='vod' or appType=='liveedge' or appType=='vodedge' or appType=='livehttporigin' or appType=='vodhttporigin'}">
				<c:choose>
					<c:when test="${dvrEnabled && dvrOnlyMode}">
						<div class="checkbox">
							<label style="cursor:default">
								<i class="fa fa-times-circle fa-fw text-danger"  style="margin-left:-22px"></i><wmsform:getlocalestring page="appconfig" obj="mpegDashNotSupported"/></p>
							</label>
						</div>
					</c:when>
					<c:otherwise>
						<wmsform:viewpropertycheckbox page="appconfig" obj="mpegDash" />
					</c:otherwise>
				</c:choose>
		    </c:if>
			<wmsform:viewpropertycheckbox page="appconfig" obj="appleHLS" />
			<c:if test="${appType=='live' or appType=='vod' or appType=='liveedge' or appType=='vodedge'}">
				<wmsform:viewpropertycheckbox page="appconfig" obj="adobeRTMP" />
		    </c:if>
			<wmsform:viewpropertycheckbox page="appconfig" obj="adobeHDS"/>
			<wmsform:viewpropertycheckbox page="appconfig" obj="msSmooth" />

            <c:if test="${appType=='live' or appType=='vod' or appType=='liveedge' or appType=='vodedge'}">
				<wmsform:viewpropertycheckbox page="appconfig" obj="rtspRTP" />
		    </c:if>
	    	<c:if test="${appType=='live' or appType=='liveedge' or appType=='livehttporigin'}">
				<label class="control-label"><wmsform:getlocalestring page="appconfig" obj="options"/></label>
			</c:if>
	    	<c:if test="${appType=='live' or appType=='liveedge'}">
				<wmsform:viewpropertycheckbox page="appconfig" obj="lowLatency"/>
			</c:if>
	    	<c:if test="${appType=='live' or appType=='livehttporigin'}">
				<wmsform:viewpropertycheckbox page="appconfig" obj="recordAllStreams"/>
			</c:if>
			<c:if test="${appType=='vod' or appType=='vodhttporigin' or appType=='vodedge'}">
				<label class="control-label"><wmsform:getlocalestring page="appconfig" obj="options"/></label>
			</c:if>
			<wmsform:viewpropertycheckbox page="appconfig" obj="httpCORSHeadersEnabled" />
      	    <c:if test="${appType=='liveedge'}">
			    <wmsform:viewproperty page="appconfig" obj="primaryOriginURL" showEmptyString="-None-"/>
				<wmsform:viewproperty page="appconfig" obj="secondaryOriginURL" showEmptyString="-None-"/>
			</c:if>
		    <c:if test="${appType=='live' or appType=='vod' or appType=='livehttporigin' or appType=='vodhttporigin'}">
			    <label class="control-label">
				    <c:if test="${appType=='live' or appType=='livehttporigin'}">
				        <wmsform:getlocalestring page="appconfig" obj="streamingDir"/>
				    </c:if>
				    <c:if test="${appType=='vod' or appType=='vodhttporigin'}">
						<wmsform:getlocalestring page="appconfig" obj="contentDir"/>
					</c:if>
				</label>
				<wmsform:viewproperty page="appconfig" obj="storageDir" showTitle="no" />
			</c:if>
            <c:if test="${appType=='vodedge'}">
				<wmsform:viewproperty page="appconfig" obj="mediaCacheSources"/>
				<wmsform:viewpropertylist page="appconfig" obj="mediaCacheSourcesList" showTitle='false' bulletList='true'/>
		    </c:if>
		    <c:if test="${appType=='vod' or appType=='vodedge' or appType=='vodhttporigin'}">
		    	<label class="control-label"><wmsform:getlocalestring page="appconfig" obj="closedcaptions"/></label>
				<wmsform:viewpropertycheckbox page="appconfig" obj="cc_TXH3G" />
				<wmsform:viewpropertycheckbox page="appconfig" obj="cc_TimedText" />
				<wmsform:viewpropertycheckbox page="appconfig" obj="cc_SubRip" />
				<wmsform:viewpropertycheckbox page="appconfig" obj="cc_WebVTT" />
				<wmsform:viewpropertycheckbox page="appconfig" obj="cc_Scenarist" />
		    </c:if>
		    <c:if test="${appType=='live' or appType=='liveedge' or appType=='livehttporigin'}">
		    	<label class="control-label"><wmsform:getlocalestring page="appconfig" obj="closedcaptions"/></label>
				<wmsform:viewpropertylist page="appconfig" obj="cc_live" showTitle="false"/>
		    </c:if>
			 <c:if test="${appType=='live' or appType=='vod'}">
				<wmsform:viewproperty page="appconfig" obj="numberOfConnections" showEmptyString="-Not Set-" />
		    </c:if>
		</div>
		<p><wmsform:button page="appconfig" onClick="javascript:toggleHelp()" obj="toggle"/></p>
		<div id="HelpBasic1" class="col-md-4 right-rail well-help pull-right">
		    <jsp:include page="HelpBasic_${formData.currentLocale}.jsp" flush="true" />
		</div>
	</c:otherwise>
</c:choose>
<script>
var helpDisplayed=true;

$(document).ready(function() {
	$('#toggle').text("hide");
	$('#toggle').hide();
});

function toggleHelp()
{
	if(helpDisplayed)
	{
		helpDisplayed=false;
		$('#HelpBasic1').hide();
		$('#mainContent1').removeClass("col-md-8");
		$('#mainContent1').addClass("col-md-11");
		$('#toggle').text("show");
	}
	else
	{
		helpDisplayed=true;
		$('#HelpBasic1').show();
		$('#mainContent1').removeClass("col-md-11");
		$('#mainContent1').addClass("col-md-8");
		$('#toggle').text("hide");
	}
}
</script>
