<?php
require_once("inc/protecao-admin.php");

if($dados_config["idioma_painel"] == "pt-br") {
$lang_sortable = "Portuguese-Brasil";
} elseif($dados_config["idioma_painel"] == "en-us") {
$lang_sortable = "English";
} else {
$lang_sortable = "Spanish";
}

?>
<!doctype html>
<html lang="es" dir="ltr">
	<head>
		<meta charset="UTF-8">
		<meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
		<title>Administraci&oacute;n</title>
		<link rel="icon" href="/img/favicon.png" type="image/x-icon"/>
		<link href="/inc/css/icons.css" rel="stylesheet">
		<link id="style" href="/inc/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" />
		<link href="/inc/css/theme.css" rel="stylesheet">
		<link href="/inc/css/theme-dark.css" rel="stylesheet">
		<link href="/inc/css/style-transparent.css" rel="stylesheet">
		<link href="/inc/css/skin-modes.css" rel="stylesheet" />
		<link href="/inc/css/animate.css" rel="stylesheet">
		<script type="text/javascript" src="/admin/inc/ajax.js"></script>
		<script type="text/javascript" src="/admin/inc/javascript.js"></script>
	</head>
	<body class="ltr main-body app sidebar-mini <?php if($dados_config["tema_painel"] == "light-theme") { ?>light-theme<?php } else { ?>dark-theme<?php } ?>">
		<!-- Loader -->
		<div id="global-loader">
			<img src="/inc/img/loader.svg" class="loader-img" alt="Loader">
		</div>
		<!-- /Loader -->
		<!-- Page -->
		<div class="page">
			<div class="open">
				<!-- main-header -->
				<?php require_once("header-admin.php");?>				
				<!-- /main-header -->
				<!-- main-sidebar -->
				<div class="sticky">
					<aside class="app-sidebar">
						<div class="main-sidebar-header active">
							<a class="header-logo active" href="/dashboard">
								<img src="/img/logo.png" class="main-logo  desktop-logo" alt="Painel Streaming">
								<img src="/img/logo.png" class="main-logo  desktop-dark" alt="Painel Streaming">
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-logo" alt="logo">
								<img src="/img/logo-pequeno.png" class="main-logo  mobile-dark" alt="logo">
							</a>
						</div>
						<?php require_once("menu-admin.php");?>
					</aside>
				</div>
				<!-- main-sidebar -->
			</div>

			<!-- main-content -->
			<div class="main-content app-content">

				<!-- container -->
				<div class="main-container container-fluid">

					<!-- breadcrumb -->
					<div class="breadcrumb-header justify-content-between" style="padding-top:60px">
						<div class="left-content">
						  <span class="main-content-title mg-b-0 mg-b-lg-1"><?php echo lang_pagina_apps_titulo; ?></span>
						</div>
						<div class="justify-content-center mt-2">
							<ol class="breadcrumb">
								<li class="breadcrumb-item tx-15"><a href="/admin/admin-configuracoes">Dashboard</a></li>
								<li class="breadcrumb-item active" aria-current="page"><?php echo lang_pagina_apps_titulo; ?></li>
							</ol>
						</div>
					</div>
					<!-- /breadcrumb -->

					<!-- row -->
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header d-flex custom-card-header border-bottom-0 ">
                    <header><?php echo lang_pagina_streamings_titulo; ?></header>
                                        <div class="card-options">
                                            <button type="button" class="btn btn-success" onClick="ligar_streamings();" data-toggle="tooltip" data-placement="bottom" title="<?php echo lang_pagina_streamings_acao_ligar_streamings; ?>"><i class="fa fa-play"></i>Streamings</button>
                                            <button type="button" class="btn btn-info" onClick="window.location = '/admin/admin-cadastrar-streaming';"><i class="fa fa-file-plus"></i><?php echo lang_botao_titulo_cadastrar; ?></button>
                                        </div>
                  </div>
                <div class="card-body">
                    <table id="data_table" class="table dataTable no-footer table-hover" role="grid" aria-describedby="data_table_info">
                                                <thead>
                                                    <tr role="row">
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_streamings_login; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_streamings_servidor; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_streamings_plano; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_streamings_uso_ftp; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_streamings_status; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_streamings_responsavel; ?></th>
                                                        <th><?php echo lang_pagina_streamings_acoes; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
if(query_string('2') == 'resultado') {
    $query = "SELECT * FROM streamings WHERE login LIKE '%".query_string('3')."%'";
} elseif(query_string('2') == 'resultado-revenda') {
    $query = "SELECT * FROM streamings WHERE codigo_cliente = '".code_decode(query_string('3'),"D")."'";
} elseif(query_string('2') == 'resultado-servidor') {
    $query = "SELECT * FROM streamings WHERE codigo_servidor = '".code_decode(query_string('3'),"D")."'";
} else {
    $query = "SELECT * FROM streamings";
}

$sql = mysqli_query($conexao,"".$query." ORDER by login ASC");
while ($dados_stm = mysqli_fetch_array($sql)) {

$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
$dados_servidor_aacplus = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor_aacplus"]."'"));
$dados_revenda = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM revendas WHERE codigo = '".$dados_stm["codigo_cliente"]."'"));
$total_playlists = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM playlists where codigo_stm = '".$dados_stm["codigo"]."'"));

if($dados_stm["codigo_cliente"] == 0) {
$responsavel = (strlen($dados_stm["identificacao"]) > 45) ? substr($dados_stm["identificacao"], 0, 43)."..." : $dados_stm["identificacao"];
} else {
$responsavel = (strlen($dados_revenda["nome"]) > 45) ? substr($dados_revenda["nome"], 0, 43)."..." : $dados_revenda["nome"];
}

$porcentagem_uso_espaco_ftp = ($dados_stm["espaco_usado"] == 0 || $dados_stm["espaco"] == 0) ? "0" : $dados_stm["espaco_usado"]*100/$dados_stm["espaco"];

$status_streaming = status_streaming($dados_servidor["ip"],$dados_servidor["senha"],$dados_stm["login"]);

if($status_streaming["status"] == "loaded") {
$status = "<i class='fa fa-check-circle text-green'>&nbsp;".lang_info_status_ligado."</i>";
} else {
$status = "<i class='fa fa-info'>&nbsp;".lang_info_status_desligado."</i>";
}

if($status_streaming["status_transmissao"] == "aovivo") {
$status = "<i class='fa fa-check-circle text-red'>&nbsp;".lang_info_status_aovivo."</i>";
}

list($ano,$mes,$dia) = explode("-",$dados_stm["data_cadastro"]);
$data_cadastro = $dia."/".$mes."/".$ano;

$servidor = ($dados_revenda["dominio_padrao"]) ? strtolower($dados_servidor["nome"]).".".$dados_revenda["dominio_padrao"] : strtolower($dados_servidor["nome"]).".".$dados_config["dominio_padrao"];

if($dados_stm["status"] > 1) {
$cor_status = "class='table-danger'";
}

$login_code = code_decode($dados_stm["login"],"E");

echo "<tr id='".$login_code."' ".$cor_status.">
<td height='25' align='left' scope='col' data-toggle='tooltip' data-placement='bottom' title='Identificação: ".$dados_stm["identificacao"]." | Data Cadastro: ".$data_cadastro."'>&nbsp;".$dados_stm["login"]."</td>
<td height='25' align='left' scope='col' data-toggle='tooltip' data-placement='bottom' title='Servidor ".$dados_servidor["nome"]." - ".$dados_servidor["ip"]."'>&nbsp;".$servidor." <small>(".$dados_servidor["ip"].")</small></td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_stm["espectadores"]." espect | ".$dados_stm["bitrate"]." Kbps | ".tamanho($dados_stm["espaco"])."</td>
<td height='25' align='center' scope='col'><div class='progress progress-sm'><div class='progress-bar bg-info' role='progressbar' aria-valuenow='".$porcentagem_uso_espaco_ftp."' aria-valuemin='0' aria-valuemax='100' style='width: ".$porcentagem_uso_espaco_ftp."%;'></div></div></td>
<td height='25' align='center' scope='col'>".$status."</td>
<td height='25' align='left' scope='col'>&nbsp;".$responsavel."</td>
<td height='25' align='left' scope='col'><a href='javascript:acessar_painel_streaming(\"".$login_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_streamings_acao_acessar_painel."'><i class='fa fa-home f-16 text-pink'></i></a>&nbsp;
<a href='/admin/admin-configurar-streaming/".$login_code."' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_streamings_acao_alterar_configuracao."'><i class='fa fa-edit f-16 text-blue'></i></a>&nbsp;
<a href='javascript:reiniciar_streaming(\"".$login_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_streamings_acao_reiniciar."'><i class='fa fa-refresh f-16 text-purple'></i></a>&nbsp;
<a href='javascript:alterar_senha_streaming(\"".$login_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_streamings_acao_alterar_senha."'><i class='fa fa-lock f-16 text-yellow'></i></a>&nbsp;
<a href='javascript:bloquear_streaming(\"".$login_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_streamings_acao_bloquear."'><i class='fa fa-ban f-16 text-red'></i></a>&nbsp;
<a href='javascript:desbloquear_streaming(\"".$login_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_streamings_acao_desbloquear."'><i class='fa fa-check-circle f-16 text-green'></i></a>&nbsp;
<a href='javascript:remover_streaming(\"".$login_code."\");' data-toggle='tooltip' data-placement='bottom' title='".lang_pagina_streamings_acao_remover."'><i class='fa fa-trash f-16 text-red'></i></a>&nbsp;</td>
</tr>";

unset($status);
unset($cor_status);
}

?>
                                                </tbody>
                                            </table>
                </div>
              </div>
            </div>

          <!-- cards closed -->
					</div>
					<!-- row closed -->
				</div>
				<!-- Container closed -->
			</div>
			<!-- main-content closed -->

			<!-- Country-selector modal-->
			<div class="modal fade" id="country-selector">
				<div class="modal-dialog modal-dialog-centered" role="document">
					<div class="modal-content">
						<div class="modal-header border-bottom">
							<h6 class="modal-title"><?php echo lang_pagina_configuracoes_idioma_painel; ?></h6><button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"><span aria-hidden="true"><i class="fa fa-times"></i></span></button>
						</div>
						<div class="modal-body">
							<ul class="row p-3">
								<li class="col-lg-6 mb-2">
									<a href="/admin/admin-mudar-idioma/es" class="btn btn-country btn-lg btn-block <?php if($dados_config["idioma_painel"] == "es") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/py.svg" class="me-3 language"></span>Espa&ntilde;ol
									</a>
								</li>
								<li class="col-lg-6 mb-2 mb-2">
									<a href="/admin/admin-mudar-idioma/pt-br" class="btn btn-country btn-lg btn-block <?php if($dados_config["idioma_painel"] == "pt-br") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/br.svg" class="me-3 language"></span>Portugu&ecirc;s(Brasil)
									</a>
								</li>
								<!--
								<li class="col-lg-6 mb-2">
									<a href="/admin/admin-mudar-idioma/en" class="btn btn-country btn-lg btn-block <?php if($dados_config["idioma_painel"] == "en") { ?>active<?php } ?>">
										<span class="country-selector"><img alt="" src="/inc/img/flags/us.svg" class="me-3 language"></span>English(USA)
									</a>
								</li>-->
							</ul>
						</div>
					</div>
				</div>
			</div>
			<!-- Modal -->
			<?php require_once("modal-admin.php");?>
		</div>
		<!-- End Page -->
		<a href="#top" id="back-to-top"><i class="las la-arrow-up"></i></a>
  
		<script src="/inc/plugins/jquery/jquery.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/popper.min.js"></script>
		<script src="/inc/plugins/bootstrap/js/bootstrap.min.js"></script>
		<script src="/inc/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
		<script src="/inc/plugins/side-menu/sidemenu.js"></script>
		<!-- Internal Data tables -->
		<script src="/inc/plugins/datatable/js/jquery.dataTables.min.js"></script>
		<script src="/inc/plugins/datatable/js/dataTables.bootstrap5.js"></script>
		<script src="/inc/plugins/datatable/js/dataTables.buttons.min.js"></script>
		<script src="/inc/plugins/datatable/js/buttons.bootstrap5.min.js"></script>
		<script src="/inc/plugins/datatable/js/jszip.min.js"></script>
		<script src="/inc/plugins/datatable/pdfmake/pdfmake.min.js"></script>
		<script src="/inc/plugins/datatable/pdfmake/vfs_fonts.js"></script>
		<script src="/inc/plugins/datatable/js/buttons.html5.min.js"></script>
		<script src="/inc/plugins/datatable/js/buttons.print.min.js"></script>
		<script src="/inc/plugins/datatable/js/buttons.colVis.min.js"></script>
		<script src="/inc/plugins/datatable/dataTables.responsive.min.js"></script>
		<script src="/inc/plugins/datatable/responsive.bootstrap5.min.js"></script>
		<script src="/inc/js/table-data.js"></script>
		<!-- End Internal Data tables -->
		<script src="/inc/js/theme.js"></script>
  <script>
  $('#busca_chave').keypress(function (e) {
    if (e.which == 13) {
       window.location = "/admin/admin-streamings/resultado/"+document.getElementById("busca_chave").value;
    }
  });  
        $(document).ready(function() {

            var table = $('#data_table').DataTable({
                responsive: true,
                "aaSorting": [],
                "order": [],
                "lengthMenu": [[25, 50, 100, 200, -1], [25, 50, 100, 200, "Todos/All"]],
                language: {
                    "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo $lang_sortable; ?>.json"
                },
                select: true,
                'aoColumnDefs': [{
                    'bSortable': false,
                    'aTargets': ['nosort']
                }]
            });
            $('#data_table tbody').on( 'click', 'tr', function() {
                if ( $(this).hasClass('selected') ) {
                    $(this).removeClass('selected');
                }
                else {
                    table.$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });

        });
  </script>
</body>
</html>