#!/bin/bash

# validate passed license key
#required input is the license string from the user in $1. It should be a single word (no spaces) and without quotes
# it is mandatory

# Return values are 0 for success and non-zero for failure.


# get the parameters 
LICENSEKEY=$1
strindex() { 
  x="${1%%$2*}"
  [[ $x = $1 ]] && echo -1 || echo ${#x}
}

    BIGINTCHARS=346789abcdefhjkmnprtuvwxyzABCDEFGHJKMNPQRTUVWXYZ

LICENSEKEYLEN=${#LICENSEKEY}
BIGINTLEN=${#BIGINTCHARS}

#echo $LICENSEKEY

if [ $LICENSEKEYLEN -ge 35 ]; then

	CHECKSUMTOTAL=0
	CHECKSUMVALUE=-1

	for ((i=6;i<35;i++))
	do

		THECHAR=${LICENSEKEY:$i:1}

		THECHARINDEX=$(strindex $BIGINTCHARS $THECHAR)

		if [ $i -lt 34 ]; then

			if [ $THECHARINDEX -ge 0 ]; then
			
				CHECKSUMTOTAL=$(($CHECKSUMTOTAL + $THECHARINDEX))
#				echo "checksum[" $THECHAR "]: " $CHECKSUMTOTAL
				
			fi

		else
			CHECKSUMVALUE=$THECHARINDEX
		fi

	done
	
	CHECKSUMCALC=$(($CHECKSUMTOTAL % $BIGINTLEN))

#	echo $CHECKSUMVALUE '=' $CHECKSUMCALC
	if [ "$CHECKSUMVALUE" == "$CHECKSUMCALC" ] ; then
		VERCHAR=${LICENSEKEY:4:1}
		if [ "$VERCHAR" == "4" ] ; then
			CONFFOLDER=/Library/WowzaStreamingEngine/conf
			LICENSEFILE=${CONFFOLDER}/Server.license
			echo "$LICENSEKEY" > $LICENSEFILE
			
			# start the services
				
			exit 0
		else
			exit 1
		fi
		# valid key, write the license file and then return success
	else
	# invalid key, return fail
		exit 1
	fi			

else
	# The key was too short, return fail
	exit 1
fi

