<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<re:mark>Display all verimatrix stream maps tables</re:mark>

<c:set var="obj" >
	verimatrixStreamMapList
</c:set>
<div class="row">
	<div class="col-md-6">
		<label id="verimatrixStreamMaps" class="control-label"><wmsform:getlocalestring page="${page}" obj="verimatrixStreamMaps"/></label>
	</div>
	<div class="col-md-2">
		<div class="pull-right">
		</div>
	</div>
</div>
<table class="table table-striped">
	<tr>
		<th><wmsform:getlocalestring page="${page}" obj="${obj}.streamName"/></th>
		<th><wmsform:getlocalestring page="${page}" obj="${obj}.resID"/></th>
		<th><wmsform:getlocalestring page="${page}" obj="${obj}.posCount"/></th>
		<th><wmsform:getlocalestring page="${page}" obj="${obj}.keyInterval"/></th>
	</tr>
	<c:forEach items="${requestScope.formData[obj]}" var="item">
		<tr>
			<td class="breakall">${item['streamName']}</td>
			<td>${item['resID']}</td>
			<td>${item['posCount']}</td>
			<td>${item['keyInterval']}</td>
		</tr>
	</c:forEach>
</table>
