<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="readonly" required="true" rtexprvalue="true" %>

<re:mark>Display all transcoder templates table</re:mark>

<c:set var="obj" >
	templates
</c:set>
<!--<div class="row">
	<div class="col-md-6">
		<h4 id="sources"><wmsform:getlocalestring page="${page}" obj="tableTitle"/> 
		<small></small></h4>
	</div>
	<div class="col-md-2">
		<div class="pull-right">
		</div>
	</div>
</div>
-->
<table class="table table-striped">
	<tr>
		<th><wmsform:getlocalestring page="${page}" obj="${obj}.name"/></th>
		<th style="width:15px"><wmsform:getlocalestring page="${page}" obj="${obj}.action"/></th>
	</tr>
	<c:forEach items="${requestScope.formData[obj]}" var="item">
		<c:set var="item" value="${wmsutil:escapeHtml(item)}"/>
		<tr>
			<c:choose>
				<c:when test="${fn:toLowerCase(item)=='transcode'}">
					<c:set var="templateDisplayName">
						Transcode (Default)
					</c:set>
				</c:when>
				<c:when test="${fn:toLowerCase(item)=='transrate'}">
					<c:set var="templateDisplayName">
						Transrate (Default)
					</c:set>
				</c:when>
				<c:when test="${fn:toLowerCase(item)=='audioonly'}">
					<c:set var="templateDisplayName">
						Audio Only (Default)
					</c:set>
				</c:when>
				<c:when test="${fn:toLowerCase(item)=='transcode-h265'}">
					<c:set var="templateDisplayName">
						Transcode H.265 (Default)
					</c:set>
				</c:when>
				<c:otherwise>
					<c:set var="templateDisplayName">
						${item}
					</c:set>
				</c:otherwise>
			</c:choose>
			<c:choose>
				<c:when test="${readonly}">
					<td class="breakall">${templateDisplayName}</td>
					<td></td>
				</c:when>
				<c:otherwise>
					<td class="breakall"><a onclick='javascript:showTemplate("${item}")' title='View'>${templateDisplayName}</a></td>
					<td>
						<sec:authorize access="hasAnyRole('admin')">		
							<c:if test="${!fn:contains(templateDisplayName,'(Default)')}" >
								<center><a onclick='javascript:removeTemplate("${item}","${templateDisplayName}")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Delete this transcoder template'></i></a></center>
							</c:if>
						</sec:authorize>
					</td>
				</c:otherwise>
			</c:choose>
		</tr>
	</c:forEach>
</table>
<wmsdialog:deletetranscodertemplate page="transcoder"/>

<script>

function removeTemplate(name,displayName)
{
	deleteTemplateName=name;
	deleteTemplateDisplayName=displayName;
	deleteTranscoderTemplateShow();
}

function showTemplate(name)
{
	name=encodeURIComponent(name);
	if("${appType}" == "")
	{
		loadAjaxMainContent("server/transcodertemplate/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&templateName="+name); 	
	}
	else 
	{
		loadAjaxMainContent("applications/${appType}/transcodertemplate/view.htm", "vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&templateName="+name); 			
	}
}

var tblDataTemplate = new Array();
var tblIdxTemplate=0;

initTableDataTemplate();

function initTableDataTemplate()
{
	<c:set var="count" value="0"/>
	<c:forEach items="${requestScope.formData[obj]}" var="item">
		var newItem = new Object();
		newItem.orgIdx = tblIdxTemplate++;
		newItem.enable=true;
		newItem.removed=false;
		newItem.templateName = "${item}";
		tblDataTemplate.push(newItem);
		<c:set var="count" value="${count + 1}"/>
	</c:forEach>
}
</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>