<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<re:mark>Display all modules tables</re:mark>

<c:set var="obj" >
	modulesList
</c:set>
<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('applications/${appType}/${appSection}/edit_mod.htm','','mainContent','defaultFormMod')"/>
<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('applications/${appType}/${appSection}/view.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}')" />

<div class="advanced-table-title">
	<h4 id="modules"><wmsform:getlocalestring page="${page}" obj="modules"/>
	<small><wmsform:getlocalestring page="${page}" obj="modulesHelp"/></small></h4>
	<wmsform:button page="${page}" obj="addModule" onClick="javascript:addModuleShow()" icon="fa fa-plus" cssClass="btn btn-default"/>
</div>
<table class="table table-striped" id="modulesTable">
</table>

<wmsform:buttonsave  onClick="javascript:postAJAXFormDstFormName('applications/${appType}/${appSection}/edit_mod.htm','','mainContent','defaultFormMod')"/>
<wmsform:buttoncancel onClick="javascript:loadAjaxMainContent('applications/${appType}/${appSection}/view.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}')" />
<wmsdialog:addmodule page="${page}"/>


<c:set var="nameLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.name"/>
</c:set>
<c:set var="descriptionLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.description"/>
</c:set>
<c:set var="classNameLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.className"/>
</c:set>
<c:set var="actionLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.action"/>
</c:set>

<script>
var tblDataModules = new Array();
var tblIdxModules=0;

initTableDataModules();
updateTableModules();

function initTableDataModules()
{
	<c:forEach items="${requestScope.formDataMod[obj]}" var="item">
		var newItem = new Object();
		newItem.orgIdx = tblIdxModules++;
		newItem.removed = "${item['removed']}"==="true";
		newItem.order = "${item['order']}";
		newItem.name = "${item['name']}";
		newItem.description = "${item['description']}";
		newItem.className = "${item['className']}";
		tblDataModules.push(newItem);
	</c:forEach>
}

function updateTableModules()
{
	var tbl = document.getElementById('modulesTable');
	if(tbl==null)
		return;
	while (tbl.firstChild) {
		tbl.removeChild(tbl.firstChild);
	}
	var tblString="";
	tblString+="<tr>";
	tblString+="<th>${nameLabel}</th>";
	tblString+="<th>${descriptionLabel}</th>";
	tblString+="<th>${classNameLabel}</th>";
	tblString+="<th style='width:60px'>${actionLabel}</th>";

	tblString+="</tr>";
	
	var goodItems=0;
	for (tblItem in tblDataModules) {
		if(!tblDataModules[tblItem].removed)
		{
			goodItems++;
		}
	}
	var displayed=0;
	for (tblItem in tblDataModules) {
		if(tblDataModules[tblItem].removed)
		{
			tblString+="<tr style='display:none'><td>";
		}
		else {
			tblString+="<tr>";
			tblString+="<td class=\"breakall\">";
			tblString+=tblDataModules[tblItem].name;
			tblString+="</td>";
			tblString+="<td>";
			tblString+=tblDataModules[tblItem].description;
			tblString+="</td>";
			tblString+="<td>";
		}
		
		tblString+="<input id='${obj}"+tblItem+".order' name='${obj}["+tblItem+"].order' type='hidden' value='"+tblDataModules[tblItem].order+"'>";			
		tblString+="<input id='${obj}"+tblItem+".removed' name='${obj}["+tblItem+"].removed' type='hidden' value='"+tblDataModules[tblItem].removed+"'>";			
		tblString+="<input id='${obj}"+tblItem+".name' name='${obj}["+tblItem+"].name' type='hidden' value='"+tblDataModules[tblItem].name+"'>";
		tblString+="<input id='${obj}"+tblItem+".description' name='${obj}["+tblItem+"].description' type='hidden' value='"+tblDataModules[tblItem].description+"'>";

		if(tblDataModules[tblItem].removed)
		{
			tblString+="</td></tr>";
			tblString+="<tr style='display:none'></tr>";
		}
		else 
		{	
			tblString+="<input id='${obj}"+tblItem+".className' name='${obj}["+tblItem+"].className' title='' type='text' value='"+tblDataModules[tblItem].className+"' class='form-control'>";						
			tblString+="</td>";
			
			if(displayed==0 && goodItems>1) 
			{
				tblString+="<td class='action-icons'><div class='row'>";
				tblString+="<div class='col-md-6 sort-down'><a href='javascript:moveModuleDown("+ tblItem + ")'><i class='fa fa-chevron-down fa-lg icon-standalone-link' title='' data-placement='bottom' data-toggle='tooltip' data-delay='250' data-original-title='Move module down'></i></a></div>";
				if(tblDataModules[tblItem].className.indexOf("ModuleCore")<0)
				{
					tblString+="<div class='col-md-6 trash-icon'><a href='javascript:removeModule("+tblItem+")'><i class='fa fa-trash-o fa-lg icon-standalone-link' title='' data-placement='top' data-toggle='tooltip' data-delay='250' data-original-title='Delete this module'></i></a></div>";
				}
				tblString+="</div></td>";
			}
			if(displayed!=0 && displayed==goodItems-1) 
			{
				tblString+="<td class='action-icons'><div class='row'>";
				tblString+="<div class='col-md-6'><a href='javascript:moveModuleUp("+ tblItem + ")'><i class='fa fa-chevron-up fa-lg icon-standalone-link' title='' data-placement='top' data-toggle='tooltip' data-delay='250' data-original-title='Move module up'></i></a></div>";
				if(tblDataModules[tblItem].className.indexOf("ModuleCore")<0)
				{
					tblString+="<div class='col-md-6 trash-icon'><a href='javascript:removeModule("+tblItem+")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='top' data-toggle='tooltip' data-delay='250' data-original-title='Delete this module'></i></a></div>";
				}
				tblString+="</div></td>";
			}
			if(displayed!=goodItems-1 && displayed!=0 && goodItems!=1)
			{
				tblString+="<td class='action-icons'><div class='row'>";
				tblString+="<div class='col-md-6'><a href='javascript:moveModuleUp("+ tblItem + ")'><i class='fa fa-chevron-up fa-lg icon-standalone-link' title='' data-placement='top' data-toggle='tooltip' data-delay='250' data-original-title='Move module up'></i></a>";
				tblString+="<a href='javascript:moveModuleDown("+ tblItem + ")'><i class='fa fa-chevron-down fa-lg icon-standalone-link' title='' data-placement='bottom' data-toggle='tooltip' data-delay='250' data-original-title='Move module down'></i></a></div>";
				if(tblDataModules[tblItem].className.indexOf("ModuleCore")<0)
				{
					tblString+="<div class='col-md-6 trash-icon'><a href='javascript:removeModule("+tblItem+")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='top' data-toggle='tooltip' data-delay='250' data-original-title='Delete this module'></i></a></div>";
				}
				tblString+="</div></td>";
			}
			if(goodItems==1)
			{
				tblString+="<td><div class='row'>";
				if(tblDataModules[tblItem].className.indexOf("ModuleCore")<0)
				{
					tblString+="<a href='javascript:removeModule("+tblItem+")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='left' data-toggle='tooltip' data-delay='250' data-original-title='Delete this module'></i></a>";				
				}
				tblString+="</div></td>";	
			}
			tblString+="</tr>";
			displayed++;
		}
	}
	$('#modulesTable').html(tblString);
}

function removeModule(orgIdx)
{
	tblDataModules[orgIdx].removed=true;
	tblDataModules[orgIdx].enabled=false;
	if(tblDataModules[orgIdx].added) //value did not exsits before and was just added
	{
		tblDataModules.splice(orgIdx,1); //remove it
	}
	updateTableModules();
}
function moveModuleDown(idx)
{
	if(idx >= tblDataModules.length-1) {
		return;
	}
	//move swap the .order of local var tablData
	var a = tblDataModules[idx];
	var b= tblDataModules[idx+1];
	tblDataModules[idx]=b;
	tblDataModules[idx+1]=a;
	a.order=idx+1;
	b.order=idx;
	updateTableModules();
	//swap the data in the hidden form inputs
	/*
	var i1=tblDataModules[idx].orgIdx;
	var i2=tblDataModules[idx+1].orgIdx;
	obj1 = document.getElementById('${obj}'+i1+'.order'); 
	obj2 = document.getElementById('${obj}'+i2+'.order'); 
	tmp = obj1.value;
	obj1.value=obj2.value;
	obj2.value=tmp;
	*/
}
function moveModuleUp(idx)
{
	if(idx <=0) {
		return;
	}
	var a = tblDataModules[idx];
	var b= tblDataModules[idx-1];
	tblDataModules[idx]=b;
	tblDataModules[idx-1]=a;
	a.order=idx-1;
	b.order=idx;
	updateTableModules();
	//swap the data in the hidden form inputs
	/*
	var i1=tblDataModules[idx].orgIdx;
	var i2=tblDataModules[idx-1].orgIdx;
	obj1 = document.getElementById('${obj}'+i1+'.order'); 
	obj2 = document.getElementById('${obj}'+i2+'.order'); 
	tmp = obj1.value;
	obj1.value=obj2.value;
	obj2.value=tmp;
	*/
}
</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>