<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="wmsdialog" tagdir="/WEB-INF/tags/wmsdialog" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<re:mark>edit host port tables</re:mark>

<c:set var="obj" >
	hostPorts
</c:set>

<div class="advanced-table-title">
	<h4 id="hostPorts"><wmsform:getlocalestring page="${page}" obj="hostPorts"/>
	<small></small></h4>
	<wmsform:button page="${page}" obj="addHostPort" onClick="javascript:hostPortShow(-1)" icon="fa fa-plus" cssClass="btn btn-default"/>
</div>

<table class="table table-striped" id="hostPortTable">
</table>
<form:errors path="hostPorts">
	<c:forEach items="${messages}" var="message">
		<div class="help-block-has-error">${message}</div>
	</c:forEach>
</form:errors>

<wmsdialog:hostport page="${page}"/>

<c:set var="nameLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.name"/>
</c:set>
<c:set var="ipAddressLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.ipAddress"/>
</c:set>
<c:set var="portLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.port"/>
</c:set>
<c:set var="typeLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.type"/>
</c:set>
<c:set var="sslEnableLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.sslEnable"/>
</c:set>
<c:set var="actionLabel">
	<wmsform:getlocalestring page="${page}" obj="${obj}.action"/>
</c:set>

<script>
var tblDataHostPorts = new Array();
var tblIdxHostPorts=0;

initTableDataHostPorts();
updateTableHostPorts();

function initTableDataHostPorts()
{
	var idx=0;
	<c:set var="count" value="0"/>
	<c:forEach items="${requestScope.formData[obj]}" var="item">
		var newItem = new Object();
		newItem.orgIdx = tblIdxHostPorts++;
		newItem.removed = "${item['removed']}"==="true";
		newItem.order = idx++;
		newItem.name = "${item['name']}";
		<spring:bind path="${obj}[${count}].name">
		  <c:forEach items='${status.errorMessages}' var='error'>
			newItem.nameError= "${error}";
		  </c:forEach>
		</spring:bind>
		newItem.ipAddress = "${item['ipAddress']}";
		<spring:bind path="${obj}[${count}].ipAddress">
		  <c:forEach items='${status.errorMessages}' var='error'>
			newItem.ipAddressError= "${error}";
		  </c:forEach>
		</spring:bind>
		newItem.port = "${item['port']}";
		<spring:bind path="${obj}[${count}].port">
		  <c:forEach items='${status.errorMessages}' var='error'>
			newItem.portError= "${error}";
		  </c:forEach>
		</spring:bind>
		newItem.type = "${item['type']}";
		<spring:bind path="${obj}[${count}].type">
		  <c:forEach items='${status.errorMessages}' var='error'>
			newItem.typeError= "${error}";
		  </c:forEach>
		</spring:bind>
		newItem.sslEnable = "${item['sslEnable']}"=="true";
		<spring:bind path="${obj}[${count}].sslEnable">
		  <c:forEach items='${status.errorMessages}' var='error'>
			newItem.sslEnableError= "${error}";
		  </c:forEach>
		</spring:bind>
		newItem.sslKeyStorePath = "${item['sslKeyStorePath']}";
		newItem.sslKeyStorePassword = "${item['sslKeyStorePassword']}";
		tblDataHostPorts.push(newItem);
		<c:set var="count" value="${count + 1}"/>
	</c:forEach>
}

function updateTableHostPorts()
{
	var tbl = document.getElementById('hostPortTable');
	if(tbl==null)
		return;
	while (tbl.firstChild) {
		tbl.removeChild(tbl.firstChild);
	}
	var tblString="";
	tblString+="<tr>";
	tblString+="<th>${nameLabel}</th>";
	tblString+="<th>${typeLabel}</th>";
	tblString+="<th>${ipAddressLabel}</th>";
	tblString+="<th>${portLabel}</th>";
	tblString+="<th>${sslEnableLabel}</th>";
	tblString+="<th>${actionLabel}</th>";

	tblString+="</tr>";

	var goodItems=0;
	for (tblItem in tblDataHostPorts) {
		if(!tblDataHostPorts[tblItem].removed)
		{
			goodItems++;
		}
	}
	var displayed=0;
	for (tblItem in tblDataHostPorts) {
		if(tblDataHostPorts[tblItem].removed)
		{
			tblString+="<tr style='display:none'><td>";
		}
		else {
			tblString+="<tr>";
		}
		
		tblString+="<input id='${obj}"+tblItem+".removed' name='${obj}["+tblItem+"].removed' type='hidden' value='"+tblDataHostPorts[tblItem].removed+"'>";			
		tblString+="<input id='${obj}"+tblItem+".sslKeyStorePath' name='${obj}["+tblItem+"].sslKeyStorePath' type='hidden' value='"+tblDataHostPorts[tblItem].sslKeyStorePath+"'>";			
		tblString+="<input id='${obj}"+tblItem+".sslKeyStorePassword' name='${obj}["+tblItem+"].sslKeyStorePassword' type='hidden' value='"+tblDataHostPorts[tblItem].sslKeyStorePassword+"'>";			

		if(tblDataHostPorts[tblItem].removed)
		{
			tblString+="</td></tr>";
			tblString+="<tr style='display:none'></tr>";
		}
		else 
		{	
			tblString+="<td class=\"breakall\">";
			tblString+=showInput(tblItem,"name",tblDataHostPorts[tblItem].name,tblDataHostPorts[tblItem].nameError);
			tblString+="</td>";
			tblString+="<td>";
			tblString+=showInput(tblItem,"type",tblDataHostPorts[tblItem].type,tblDataHostPorts[tblItem].typeError);
			tblString+="</td>";
			tblString+="<td>";
			tblString+=showInput(tblItem,"ipAddress",tblDataHostPorts[tblItem].ipAddress,tblDataHostPorts[tblItem].ipAddressError);
			tblString+="</td>";
			tblString+="<td>";
			tblString+=showInput(tblItem,"port",tblDataHostPorts[tblItem].port,tblDataHostPorts[tblItem].portError);
			tblString+="</td>";
			tblString+="<td>";
			tblString+=showInput(tblItem,"sslEnable",tblDataHostPorts[tblItem].sslEnable,tblDataHostPorts[tblItem].sslEnableError);
			tblString+="</td>";
			tblString+="<td class='action-icons'>";
			
			tblString+="<a href='javascript:hostPortShow("+tblItem+")'><i class='fa fa-pencil fa-2x icon-standalone-link' title='' data-placement='top' data-toggle='tooltip' data-delay='250' data-original-title='Edit this host port'></i></a>&nbsp;";				
			tblString+="<a href='javascript:removeHostPort("+tblItem+")'><i class='fa fa-trash-o fa-2x icon-standalone-link' title='' data-placement='right' data-toggle='tooltip' data-delay='250' data-original-title='Delete this host port'></i></a>";				

			tblString+="</td>";
			tblString+="</tr>";
			displayed++;
		}
	}
	$('#hostPortTable').html(tblString);
}

function showInput(tblItem,field,valueStr,errorStr)
{
	if(errorStr != undefined)
	{
		retVal="<div class='form-group error' id='${obj}CtrlGroup'>";
	}
	else {
		retVal="<div class='form-group' id='${obj}CtrlGroup'>";		
	}
	retVal+="<input id='${obj}"+tblItem+"."+field+"' name='${obj}["+tblItem+"]."+field+"' value='"+valueStr+"' type='hidden' >";
	retVal+=valueStr;
	if(errorStr != undefined)
	{
		retVal+="<span class='help-block-has-error'>"+errorStr+"</span>";
	}
	retVal+="</div>";
	return retVal;
}
function removeHostPort(orgIdx)
{
	tblDataHostPorts[orgIdx].removed=true;
	tblDataHostPorts[orgIdx].enabled=false;
	if(tblDataHostPorts[orgIdx].added) //value did not exsits before and was just added
	{
		tblDataHostPorts.splice(orgIdx,1); //remove it
	}
	updateTableHostPorts();
}

</script>
<script type="text/javascript">
    $(function () {
        $("[data-toggle='tooltip']").tooltip();
    });
</script>