<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>
<%@ attribute name="obj" required="true" rtexprvalue="true" %>
<%@ attribute name="defaultStr" required="false" rtexprvalue="true" %>
<%@ attribute name="quotes" required="false" rtexprvalue="true" %>

<re:mark>if title is empty:</re:mark>
<re:mark>  see if obj exists in messages.properties</re:mark>
<re:mark>  if it doesn't, see if common.obj exists in messages.properties</re:mark>
<re:mark>  if it doesn't, return objVar</re:mark>
<re:mark>if title is not empty: <fmt> </re:mark>
<re:mark>  see if title exists in messages.properties</re:mark>
<re:mark>  if it doesn't, return title</re:mark>

<re:mark> remove any [#] from the obj.  supports arrays and their titles</re:mark>
<c:if test="${fn:contains(obj,'[')}">
	<c:set var="obj" value="${fn:substringBefore(obj,'[')}${fn:substringAfter(obj,']')}"/>
</c:if>
<c:set var="title_fmt" value="Unknown"/>
<c:set var="title_fmt" >
	<fmt:message key="${page}.${obj}" />
</c:set>
<c:if test="${empty page}">
	<c:set var="title_fmt" >
		<fmt:message key="${obj}" />
	</c:set>
</c:if>
<c:if test="${empty quotes}">
	<c:set var="quotes" value="false"/>
</c:if>

<c:if test='${fn:startsWith(title_fmt, "??")}'>
	<c:set var="title_fmt" >
		<fmt:message key="common.${obj}" />
	</c:set>
	<c:if test='${fn:startsWith(title_fmt, "??")}'>
		<c:set var="splits" value="${fn:split(obj, '.')}" />
		<c:choose>
			<c:when test='${fn:length(splits)==1}' >
				<c:choose>
					<c:when test='${empty defaultStr}'>
						<c:set var="title_fmt" >
							${obj}
						</c:set>
					</c:when>
					<c:otherwise>
						<c:set var="title_fmt" >
							${defaultStr}
						</c:set>
					</c:otherwise>
				</c:choose>
			</c:when>
			<c:otherwise>
				<c:set var="obj0">${splits[0]}</c:set>
				<c:set var="obj1">${splits[1]}</c:set>
				<c:if  test='${fn:length(splits)==3}' >
					<c:set var="obj1">${splits[1]}.${splits[2]}</c:set>
				</c:if>
				<re:mark>Changed to below (obj1) to support Virtual Host Performance Ports</re:mark>
				<re:mark>quick pass through app did not find any issues</re:mark>
				<c:if  test='${fn:length(splits)==3}' >
					<c:set var="obj1">${splits[2]}</c:set>
				</c:if>
				<c:if  test='${fn:length(splits)==4}' >
					<c:set var="obj1">${splits[3]}</c:set>
				</c:if>
				<c:set var="title_fmt" >
					<fmt:message key="common.${obj1}" />
				</c:set>
				<c:if test='${fn:startsWith(title_fmt, "??")}'>
					<c:choose>
						<c:when test='${empty defaultStr}'>
							<c:set var="title_fmt" >
								${obj1}
							</c:set>
						</c:when>
						<c:otherwise>
							<c:set var="title_fmt" >
								${defaultStr}
							</c:set>
						</c:otherwise>
					</c:choose>
				</c:if>	
			</c:otherwise>
		</c:choose>
	</c:if>
</c:if>	
<c:if test='${fn:startsWith(title_fmt, "${")}'>
	<c:set var="tmpTitle" value="${fn:substring(title_fmt,2,fn:length(title_fmt)-1)}"/>
	<c:set var="title_fmt">
		<wmsform:getlocalestring page="${page}" obj="${fn:substring(fn:replace(tmpTitle,page,''),1,99)}"/>	
	</c:set>
</c:if>
<c:choose>
	<c:when test="${quotes}">
		'${fn:trim(title_fmt)}'
	</c:when>
	<c:otherwise>
		${fn:trim(title_fmt)}
	</c:otherwise>
</c:choose>