<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>

<%@ attribute name="destType" required="true" rtexprvalue="true" %>
<%@ attribute name="destName" required="true" rtexprvalue="true" %>
<%@ attribute name="privacy" required="false" rtexprvalue="true" %>

<re:mark>Display a Facebook destination config</re:mark>

<c:set var="destTypeName"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget.facebookTypeName" obj="${destType}"/></c:set>
<c:set var="on"><wmsform:getlocalestring page="common" obj="on"/></c:set>
<c:set var="in"><wmsform:getlocalestring page="common" obj="in"/></c:set>

<c:choose>
	<c:when test="${destType=='timeline'}">
		<c:set var="destTypeAndName">
			${destTypeName}
		</c:set>
		<c:set var="showPriv">true</c:set>
	</c:when>
	<c:otherwise>
		<c:set var="destTypeAndName">
			${destTypeName} "${destName}"
		</c:set>
	</c:otherwise>
</c:choose>

<div style="margin-bottom:-14px">
<div class="form-group">
	<label class="control-label">
		<wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="facebookCurrentConfig"/>
	</label>
	<div class="controls">
		<div class="value">
			${destTypeAndName}
		</div>
	</div>
</div>

<c:if test="${showPriv == 'true' && !empty privacy}">
	<div>
		<label class="control-label">
			<wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="facebookPrivacy"/>
		</label>
	</div>
	<div class="controls">
		<div class="value">
			${privacy}
		</div>
	</div>
</c:if>
</div>

