<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="obj" required="false" rtexprvalue="true" %>
<%@ attribute name="tooltip" required="false" rtexprvalue="true" %>
<%@ attribute name="group" required="true" rtexprvalue="true" %>
<%@ attribute name="inputFilter" required="false" rtexprvalue="true" %>

<c:choose>
	<c:when test="${ inputFilter=='numerical'}">
		<script>
		$( '#${obj}' ).keypress(function( event ) {
			var code = String.fromCharCode(event.which);
			if (code.match(/[^0-9\.]/) && !(event.keyCode==8 || event.keyCode==46 || event.keyCode==9)){
				event.preventDefault();
			}
			var pos = $('#${obj}').getCursorPosition();
			var newcode = $('#${obj}').val().substring(0,pos)+code+$('#${obj}').val().substring(pos);
			if (!/^[0-9]+(\.[0-9]*)?$/.test(newcode))
			{
				event.preventDefault();
			}
		});
		</script>
	</c:when>
	<c:when test="${ inputFilter=='integer'}">
		<script>
		$( '#${obj}' ).keypress(function( event ) {
			var code = String.fromCharCode(event.which);
			if (code.match(/[^0-9]/) && !(event.keyCode==8 || event.keyCode==46 || event.keyCode==9)) {
				event.preventDefault();
			}
		});
		</script>
	</c:when>
	<c:when test="${ !empty inputFilter}">
		<script>
		$( '#${obj}' ).keypress(function( event ) {
			var code = String.fromCharCode(event.which);
			var pos = $('#${obj}').getCursorPosition();
			var newcode = $('#${obj}').val().substring(0,pos)+code+$('#${obj}').val().substring(pos);
			var newRegex = new RegExp("${inputFilter}","g");
			if (!newRegex.test(newcode) && !(event.keyCode==8 || event.keyCode==46 || event.keyCode==9))
			{
				event.preventDefault();
			}
		});
		</script>
	</c:when>
</c:choose>

<tr ${group} style="display:none">
	<c:set var="tooltip_msg">
		<wmsform:getlocaletooltip page="${page}" obj="${obj}" tooltip="${tooltip}"/>
	</c:set>
	<c:if test="${ empty cssClass}">
		<c:set var="cssClass" value="form-control"/>
	</c:if>
	<c:if test="${ empty cssSize}">
		<c:set var="cssSize" value="col-md-12"/>
	</c:if>
	<c:if test="${ empty cssRow}">
		<c:set var="cssRow" value="row"/>
	</c:if>
	
	<c:set var="objName"><wmsform:getlocalestring page="appconfig.streamTargets.wizard.configureTarget" obj="${obj}"/></c:set>
	<c:set var="objDesc"><wmsform:getlocalestring page="appconfigAdv.advancedTables.streamTarget.description" obj="${obj}" defaultStr="Missing description for ${objName}"/></c:set>
	<c:set var="objValue">${requestScope.formData[obj]}</c:set>
	<td>
		${objName}
	</td>
	<td>
		<div class="${cssRow}">
			<div class="${cssSize}">
				<form:input path="${obj}" title="${tooltip_msg}" class="${cssClass}" readonly="false" autocapitalize="none"/>
			</div>
		</div>
	</td>
	<td>
		<i id="${obj}EditDesc" class="fa fa-question-circle fa-2x" style="float:right" rel="popover" data-html="true" data-content="${objDesc}" data-trigger="click" data-animation="true" data-placement="left" data-delay="150" data-original-title="${objName}"></i>
		<script>WOWZA.Util.Popover("#${obj}EditDesc");</script>
	</td>
</tr>
	