<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<%@ attribute name="objName" required="true" rtexprvalue="true" %>
<%@ attribute name="objVar" required="true" rtexprvalue="true" %>
<%@ attribute name="title" required="false" rtexprvalue="true" %>
<%@ attribute name="tooltip" required="false" rtexprvalue="true" %>

<re:mark>Display a single dropdown box sourced from </re:mark>
<!-- 
<re:mark>Get the tooltip based on objName and objVar</re:mark>
<c:set var="tooltip_msg">
	<wmsform:getlocaletooltip objName="${objName}" objVar="${objVar}" tooltip="${tooltip}"/>
</c:set>

<re:mark>Title</re:mark>
<label class="control-label">
	<wmsform:getlocalestring objName="${objName}" objVar="${objVar}" title="${title}"/>
</label>

<re:mark>Get list of items</re:mark>
<c:set var="optionsList">
	<wmsform:objvaluearray objName="${objName}" objVar="${objVar}Options" />
</c:set>

<re:mark>We need the spring options from:select hidden.  When we submit the form, all options must be there</re:mark>
<form:select path="${objName}.${objVar}Options" size="5" style="display:none;">
	<c:forEach var="itemKey" items="${fn:split(optionsList,',')}">
		<option value="${fn:trim(itemKey)}" selected="selected">${fn:trim(itemKey)}</option>
	</c:forEach>
</form:select>

<re:mark>Get currently set value</re:mark>
<c:set var="objValue">
	<wmsform:objvaluearray objName="${objName}" objVar="${objVar}" />
</c:set>

<re:mark>Display the dropdown picker</re:mark>
<form:select path="${objName}.${objVar}">
	<c:forEach var="itemKey" items="${fn:split(optionsList,',')}">
		<c:choose>
      		<c:when test="${fn:trim(itemKey) == fn:trim(objValue)}">
  				<option value="${fn:trim(itemKey)}" selected>${fn:trim(itemKey)}</option>
      		</c:when>
      		<c:otherwise>
  				<option value="${fn:trim(itemKey)}">${fn:trim(itemKey)}</option>
      		</c:otherwise>
    	</c:choose>
	</c:forEach>
</form:select>
<re:mark>Errors and warnings</re:mark>
<form:errors path="${objName}.${objVar}" cssClass="text-danger"/>
<wmsform:warnings path="${objName}.${objVar}" cssClass="text-warning"/>
 -->
