<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="splitRecordingModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="splitRecordingModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:splitRecordingClose()">x</button>
					<h4 id="splitRecordingModalLabel" class="modal-title"><wmsform:getlocalestring page="splitRecordingDialog" obj="title"/></h4>
				  </div>
				  <div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="splitRecordingDialog" obj="message"/> <b><span id="splitRecorderName"></span></b>?</p>
				  </div>
				  <div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:splitRecordingClose()"/>
					<wmsform:buttonok  onClick="javascript:doSplit()"/>
				  </div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>
var currentInstance;
var currentStream;
var currentApp;

function splitRecordingShow(app, appInstance, recorderName) {
	$('#splitRecorderName').text(recorderName);
	currentApp=app;
	currentInstance=appInstance;
	currentRecorder=recorderName;
	$('#splitRecordingModal').on("shown.bs.modal", function() {});
	$('#splitRecordingModal').modal('show');	
}

function splitRecordingClose() {
	$('#splitRecordingModal').modal('hide');
}

function doSplit() {
	$('#splitRecordingModal').on('hidden.bs.modal', function() {
		postAJAXForm('streamrecorder/${page}/splitRecording.htm','vhost=${wmsutil:urlEncode(vhost)}&appName='+encodeURIComponent(currentApp)+'&appType=${appType}&appSection=${appSection}&instanceName='+encodeURIComponent(currentInstance)+'&recorder='+encodeURIComponent(currentRecorder)+'&returnPage=${page}');
	});
	splitRecordingClose();
}

</script>