<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="re" tagdir="/WEB-INF/tags/re" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="wmsform" tagdir="/WEB-INF/tags/wmsform" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<%@ taglib prefix="wmsutil" uri="/WEB-INF/tlds/wmsutil.tld" %>

<%@ attribute name="page" required="true" rtexprvalue="true" %>

<div id="enableStreamTargetingModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="enableStreamTargetingingModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<form class="form-modal"><fieldset>
				  <div class="modal-header">
					<button type="button" class="close" onClick="javascript:enableStreamTargetingClose()">x</button>
					<h4 id="enableStreamTargetingModalLabel" class="modal-title"><wmsform:getlocalestring page="enableStreamTargetingDialog" obj="title"/></h4>
				  </div>
				  <div class="modal-body">
						<p class="breakall"><wmsform:getlocalestring page="enableStreamTargetingDialog" obj="message"/></p>
						<p class="text-warning"><wmsform:getlocalestring page="enableStreamTargetingDialog" obj="warning"/></p>
				  </div>
				  <div class="modal-footer">
					<wmsform:buttoncancel  onClick="javascript:enableStreamTargetingClose()"/>
					<wmsform:buttonok  onClick="javascript:doEnableStreamTargeting()"/>
				  </div>
			</fieldset></form>
		</div>
	</div>
</div>
<script>
var currentStreamTarget;
var currentApp;

function enableStreamTargetingShow(app, streamTargetName) {
	$('#enableStreamTargetingName').text(streamTargetName);
	currentApp=app;
	currentStreamTarget=streamTargetName;
	$('#enableStreamTargetingModal').on("shown.bs.modal", function() {});
	$('#enableStreamTargetingModal').modal('show');
}

function enableStreamTargetingClose() {
	$('#enableStreamTargetingModal').modal('hide');
}

function doEnableStreamTargeting() {
	$('#enableStreamTargetingModal').on('hidden.bs.modal', function() {
		loadAjaxMainContent('applications/${appType}/streamtargets/enableStreamTargetsBtn.htm','vhost=${wmsutil:urlEncode(vhost)}&appName=${wmsutil:urlEncode(appName)}&banner=enable');
	});
	enableStreamTargetingClose();
}

</script>